/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGpath
extends PGobject
implements Serializable,
Cloneable {
    public boolean open;
    public PGpoint[] points;

    public PGpath(PGpoint[] points, boolean open) {
        this();
        this.points = points;
        this.open = open;
    }

    public PGpath() {
        this.setType("path");
    }

    public PGpath(String s2) throws SQLException {
        this();
        this.setValue(s2);
    }

    public void setValue(String s2) throws SQLException {
        if (s2.startsWith("[") && s2.endsWith("]")) {
            this.open = true;
            s2 = PGtokenizer.removeBox(s2);
        } else if (s2.startsWith("(") && s2.endsWith(")")) {
            this.open = false;
            s2 = PGtokenizer.removePara(s2);
        } else {
            throw new PSQLException(GT.tr("Cannot tell if path is open or closed: {0}.", s2), PSQLState.DATA_TYPE_MISMATCH);
        }
        PGtokenizer t = new PGtokenizer(s2, ',');
        int npoints = t.getSize();
        this.points = new PGpoint[npoints];
        for (int p2 = 0; p2 < npoints; ++p2) {
            this.points[p2] = new PGpoint(t.getToken(p2));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGpath) {
            PGpath p2 = (PGpath)obj;
            if (p2.points.length != this.points.length) {
                return false;
            }
            if (p2.open != this.open) {
                return false;
            }
            for (int i2 = 0; i2 < this.points.length; ++i2) {
                if (this.points[i2].equals(p2.points[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (int i2 = 0; i2 < this.points.length && i2 < 5; ++i2) {
            hash ^= this.points[i2].hashCode();
        }
        return hash;
    }

    public Object clone() throws CloneNotSupportedException {
        PGpath newPGpath = (PGpath)super.clone();
        if (newPGpath.points != null) {
            newPGpath.points = (PGpoint[])newPGpath.points.clone();
            for (int i2 = 0; i2 < newPGpath.points.length; ++i2) {
                newPGpath.points[i2] = (PGpoint)newPGpath.points[i2].clone();
            }
        }
        return newPGpath;
    }

    public String getValue() {
        StringBuilder b2 = new StringBuilder(this.open ? "[" : "(");
        for (int p2 = 0; p2 < this.points.length; ++p2) {
            if (p2 > 0) {
                b2.append(",");
            }
            b2.append(this.points[p2].toString());
        }
        b2.append(this.open ? "]" : ")");
        return b2.toString();
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClosed() {
        return !this.open;
    }

    public void closePath() {
        this.open = false;
    }

    public void openPath() {
        this.open = true;
    }
}

