# Copyright 1999-2021 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools toolchain-funcs

DESCRIPTION="lanmap sits quietly on a network and builds a picture of what it sees"
HOMEPAGE="http://www.parseerror.com/lanmap"
SRC_URI="http://www.parseerror.com/${PN}/rev/${PN}-2006-03-07-rev${PV}.zip"
S="${WORKDIR}/${PN}"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~x86 ~amd64-linux ~x86-linux"

DEPEND="net-libs/libpcap"
RDEPEND="${DEPEND}
	media-gfx/graphviz
"
BDEPEND="app-arch/unzip"

PATCHES=(
	"${FILESDIR}"/${P}-make.patch
	"${FILESDIR}"/${P}-printf-format.patch
)

src_prepare() {
	default
	rm configure || die
	eautoreconf
}

src_compile() {
	tc-export CC
	emake
}

src_install() {
	emake prefix="${ED}"/usr install
	dodoc README.txt TODO.txt
}
