# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DISTUTILS_USE_PEP517=setuptools
PYPI_PN=${PN/-/.}
PYTHON_COMPAT=( python3_{11..14} python3_{13..14}t pypy3_11 )

inherit distutils-r1 pypi

DESCRIPTION="Zope Deprecation Infrastructure"
HOMEPAGE="
	https://pypi.org/project/zope.deprecation/
	https://github.com/zopefoundation/zope.deprecation/
"

LICENSE="ZPL"
SLOT="0"
KEYWORDS="amd64 arm64 x86"

distutils_enable_tests unittest

src_prepare() {
	distutils-r1_src_prepare

	# strip rdep specific to namespaces
	sed -i -e "s:'setuptools',::" setup.py || die
}

python_test() {
	distutils_write_namespace zope
	eunittest -s "${BUILD_DIR}/install$(python_get_sitedir)"
}
