# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit desktop

DESCRIPTION="A Tcl/Tk GUI for writing DVDs and CDs"
HOMEPAGE="http://regis.damongeot.free.fr/tkdvd/"
SRC_URI="http://regis.damongeot.free.fr/tkdvd/dl/${P}.tar.gz"
S="${WORKDIR}"/tkdvd

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 ppc x86"

RDEPEND="
	app-cdr/cdrtools
	app-cdr/dvd+rw-tools
	dev-lang/tcl:0
	dev-lang/tk:0
"

src_compile() { :; }

src_install() {
	insinto /usr/share/${PF}/src
	doins src/*

	insinto /usr/share/${PF}
	doins TkDVD.sh

	cat <<- EOF >"${T}"/tkdvd
	#!/bin/sh
	cd /usr/share/${PF}
	sh TkDVD.sh
	EOF

	dobin "${T}"/tkdvd

	local DOCS=( ChangeLog FAQ README TODO doc/config_file )
	local HTML_DOCS=( doc/combobox.html )
	einstalldocs

	doicon icons/*.png
}
