/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.StatefulMappingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;

public final class ItemMappingIterator
implements SequenceIterator,
LookaheadIterator,
LastPositionFinder {
    private SequenceIterator base;
    private ItemMappingFunction action;
    private Item current = null;
    private int position = 0;
    private boolean oneToOne = false;

    public ItemMappingIterator(SequenceIterator base, ItemMappingFunction action) {
        this.base = base;
        this.action = action;
    }

    public ItemMappingIterator(SequenceIterator base, ItemMappingFunction action, boolean oneToOne) {
        this.base = base;
        this.action = action;
        this.oneToOne = oneToOne;
    }

    public void setOneToOne(boolean oneToOne) {
        this.oneToOne = oneToOne;
    }

    public boolean isOneToOne() {
        return this.oneToOne;
    }

    public boolean hasNext() {
        return ((LookaheadIterator)this.base).hasNext();
    }

    public Item next() throws XPathException {
        do {
            Item nextSource;
            if ((nextSource = this.base.next()) == null) {
                this.current = null;
                this.position = -1;
                return null;
            }
            this.current = this.action.mapItem(nextSource);
        } while (this.current == null);
        ++this.position;
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public void close() {
        this.base.close();
    }

    public SequenceIterator getAnother() throws XPathException {
        SequenceIterator newBase = this.base.getAnother();
        ItemMappingFunction newAction = this.action instanceof StatefulMappingFunction ? (ItemMappingFunction)((Object)((StatefulMappingFunction)((Object)this.action)).getAnother()) : this.action;
        return new ItemMappingIterator(newBase, newAction, this.oneToOne);
    }

    public int getLastPosition() throws XPathException {
        return ((LastPositionFinder)((Object)this.base)).getLastPosition();
    }

    public int getProperties() {
        if (this.oneToOne) {
            return this.base.getProperties() & 6;
        }
        return 0;
    }
}

