/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.EmptyTextNodeRemover;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public class AdjacentTextNodeMerger
extends UnaryExpression {
    public AdjacentTextNodeMerger(Expression p0) {
        super(p0);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e = super.typeCheck(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (th.relationship(this.getBaseExpression().getItemType(th), NodeKindTest.TEXT) == 4) {
            return this.getBaseExpression();
        }
        if (!Cardinality.allowsMany(this.getBaseExpression().getCardinality())) {
            return this.getBaseExpression();
        }
        if (this.getBaseExpression() instanceof Choose) {
            Choose choose = (Choose)this.getBaseExpression();
            Expression[] actions = choose.getActions();
            for (int i = 0; i < actions.length; ++i) {
                AdjacentTextNodeMerger atm2 = new AdjacentTextNodeMerger(actions[i]);
                actions[i] = atm2.typeCheck(visitor, contextItemType);
            }
            return choose;
        }
        if (this.getBaseExpression() instanceof Block) {
            Block block = (Block)this.getBaseExpression();
            Expression[] actions = block.getChildren();
            boolean prevtext = false;
            boolean needed = false;
            boolean maybeEmpty = false;
            for (int i = 0; i < actions.length; ++i) {
                boolean maybetext;
                if (actions[i] instanceof ValueOf) {
                    maybetext = true;
                    Expression content = ((ValueOf)actions[i]).getContentExpression();
                    maybeEmpty = content instanceof StringLiteral ? (maybeEmpty |= ((StringLiteral)content).getStringValue().length() == 0) : true;
                } else {
                    maybetext = th.relationship(actions[i].getItemType(th), NodeKindTest.TEXT) != 4;
                    maybeEmpty |= maybetext;
                }
                if (prevtext && maybetext) {
                    needed = true;
                    break;
                }
                if (maybetext && Cardinality.allowsMany(actions[i].getCardinality())) {
                    needed = true;
                    break;
                }
                prevtext = maybetext;
            }
            if (!needed) {
                if (maybeEmpty) {
                    return new EmptyTextNodeRemover(block);
                }
                return block;
            }
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.getBaseExpression().getItemType(th);
    }

    public int computeCardinality() {
        return this.getBaseExpression().getCardinality() | 0x2000;
    }

    public Expression copy() {
        return new AdjacentTextNodeMerger(this.getBaseExpression().copy());
    }

    public int getImplementationMethod() {
        return 25;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return new AdjacentTextNodeMergingIterator(this.getBaseExpression().iterate(context));
    }

    public void process(XPathContext context, int locationId, int options) throws XPathException {
        Item item;
        SequenceReceiver out = context.getReceiver();
        FastStringBuffer fsb = new FastStringBuffer(256);
        SequenceIterator iter = this.getBaseExpression().iterate(context);
        boolean prevText = false;
        while ((item = iter.next()) != null) {
            if (AdjacentTextNodeMerger.isTextNode(item)) {
                CharSequence s = item.getStringValueCS();
                if (s.length() <= 0) continue;
                fsb.append(s);
                prevText = true;
                continue;
            }
            if (prevText) {
                out.characters(fsb, locationId, options);
            }
            prevText = false;
            fsb.setLength(0);
            out.append(item, locationId, options);
        }
        if (prevText) {
            out.characters(fsb, locationId, options);
        }
    }

    public String getExpressionName() {
        return "mergeAdjacentText";
    }

    public static boolean isTextNode(Item item) {
        return item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 3;
    }

    public static class AdjacentTextNodeMergingIterator
    implements LookaheadIterator {
        private SequenceIterator base;
        private Item current;
        private Item next;
        private int position = 0;

        public AdjacentTextNodeMergingIterator(SequenceIterator base) throws XPathException {
            this.base = base;
            this.next = base.next();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Item next() throws XPathException {
            this.current = this.next;
            if (this.current == null) {
                this.position = -1;
                return null;
            }
            if (this.next != null) {
                this.next = this.base.next();
            }
            if (AdjacentTextNodeMerger.isTextNode(this.current)) {
                FastStringBuffer fsb = new FastStringBuffer(256);
                fsb.append(this.current.getStringValueCS());
                while (this.next != null && AdjacentTextNodeMerger.isTextNode(this.next)) {
                    fsb.append(this.next.getStringValueCS());
                    this.next = this.base.next();
                }
                if (fsb.length() == 0) {
                    return this.next();
                }
                Orphan o = new Orphan(((NodeInfo)this.current).getConfiguration());
                o.setNodeKind((short)3);
                o.setStringValue(fsb);
                this.current = o;
                ++this.position;
                return this.current;
            }
            ++this.position;
            return this.current;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public void close() {
            this.base.close();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new AdjacentTextNodeMergingIterator(this.base.getAnother());
        }

        public int getProperties() {
            return 4;
        }
    }
}

