/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.IntegratedFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegratedFunctionLibrary
implements FunctionLibrary,
Serializable {
    private HashMap<StructuredQName, ExtensionFunctionDefinition> functions = new HashMap();

    public void registerFunction(ExtensionFunctionDefinition function) throws XPathException {
        this.functions.put(function.getFunctionQName(), function);
    }

    @Override
    public SequenceType[] getFunctionSignature(StructuredQName functionName, int arity) {
        ExtensionFunctionDefinition defn = this.functions.get(functionName);
        if (defn == null) {
            return null;
        }
        if (arity == -1) {
            return new SequenceType[0];
        }
        try {
            if (defn.getMinimumNumberOfArguments() <= arity && defn.getMaximumNumberOfArguments() >= arity) {
                SequenceType[] sig = new SequenceType[arity + 1];
                sig[0] = defn.getResultType(defn.getArgumentTypes());
                System.arraycopy(defn.getArgumentTypes(), 0, sig, 1, arity);
                return sig;
            }
            return null;
        }
        catch (Exception err) {
            return null;
        }
    }

    @Override
    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env, Container container) throws XPathException {
        ExtensionFunctionDefinition defn = this.functions.get(functionName);
        if (defn == null) {
            return null;
        }
        try {
            ExtensionFunctionCall f = defn.makeCallExpression();
            f.setDefinition(defn, container);
            IntegratedFunctionCall fc = new IntegratedFunctionCall(f);
            fc.setFunctionName(functionName);
            fc.setArguments(staticArgs);
            return fc;
        }
        catch (Exception err) {
            throw new XPathException("Failed to create call to extension function " + functionName.getDisplayName(), err);
        }
    }

    @Override
    public FunctionLibrary copy() {
        IntegratedFunctionLibrary lib = new IntegratedFunctionLibrary();
        lib.functions = new HashMap<StructuredQName, ExtensionFunctionDefinition>(this.functions);
        return lib;
    }

    public Iterator<StructuredQName> iterateFunctionNames() {
        return this.functions.keySet().iterator();
    }
}

