/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import com.kenai.jaffl.Library;
import com.kenai.jaffl.LibraryOption;
import java.util.HashMap;
import java.util.Map;
import org.python.posix.FreeBSDPOSIX;
import org.python.posix.JavaPOSIX;
import org.python.posix.LazyPOSIX;
import org.python.posix.LibC;
import org.python.posix.LibCProvider;
import org.python.posix.LinuxLibC;
import org.python.posix.LinuxPOSIX;
import org.python.posix.MacOSPOSIX;
import org.python.posix.OpenBSDPOSIX;
import org.python.posix.POSIX;
import org.python.posix.POSIXHandler;
import org.python.posix.POSIXTypeMapper;
import org.python.posix.SolarisPOSIX;
import org.python.posix.WindowsLibC;
import org.python.posix.WindowsLibCFunctionMapper;
import org.python.posix.WindowsPOSIX;
import org.python.posix.util.Platform;

public class POSIXFactory {
    static final String LIBC = Platform.IS_LINUX ? "libc.so.6" : (Platform.IS_WINDOWS ? "msvcrt" : "c");
    static final Map<LibraryOption, Object> defaultOptions = new HashMap<LibraryOption, Object>(){
        {
            this.put(LibraryOption.TypeMapper, POSIXTypeMapper.INSTANCE);
            this.put(LibraryOption.LoadNow, Boolean.TRUE);
        }
    };

    public static POSIX getPOSIX(POSIXHandler handler, boolean useNativePOSIX) {
        return new LazyPOSIX(handler, useNativePOSIX);
    }

    static POSIX loadPOSIX(POSIXHandler handler, boolean useNativePOSIX) {
        POSIX posix;
        block18: {
            posix = null;
            if (useNativePOSIX) {
                try {
                    if (Platform.IS_MAC) {
                        posix = POSIXFactory.loadMacOSPOSIX(handler);
                    } else if (Platform.IS_LINUX) {
                        posix = POSIXFactory.loadLinuxPOSIX(handler);
                    } else if (Platform.IS_FREEBSD) {
                        posix = POSIXFactory.loadFreeBSDPOSIX(handler);
                    } else if (Platform.IS_OPENBSD) {
                        posix = POSIXFactory.loadOpenBSDPOSIX(handler);
                    } else if (Platform.IS_SOLARIS) {
                        posix = POSIXFactory.loadSolarisPOSIX(handler);
                    } else if (Platform.IS_WINDOWS) {
                        posix = POSIXFactory.loadWindowsPOSIX(handler);
                    }
                    if (handler.isVerbose()) {
                        if (posix != null) {
                            System.err.println("Successfully loaded native POSIX impl.");
                        } else {
                            System.err.println("Failed to load native POSIX impl; falling back on Java impl. Unsupported OS.");
                        }
                    }
                }
                catch (Throwable t) {
                    if (!handler.isVerbose()) break block18;
                    System.err.println("Failed to load native POSIX impl; falling back on Java impl. Stacktrace follows.");
                    t.printStackTrace();
                }
            }
        }
        if (posix == null) {
            posix = POSIXFactory.getJavaPOSIX(handler);
        }
        return posix;
    }

    public static POSIX getJavaPOSIX(POSIXHandler handler) {
        return new JavaPOSIX(handler);
    }

    public static POSIX loadLinuxPOSIX(POSIXHandler handler) {
        return new LinuxPOSIX(LIBC, new LinuxLibCProvider(), handler);
    }

    public static POSIX loadMacOSPOSIX(POSIXHandler handler) {
        return new MacOSPOSIX(LIBC, new DefaultLibCProvider(), handler);
    }

    public static POSIX loadSolarisPOSIX(POSIXHandler handler) {
        return new SolarisPOSIX(LIBC, new SolarisLibCProvider(), handler);
    }

    public static POSIX loadFreeBSDPOSIX(POSIXHandler handler) {
        return new FreeBSDPOSIX(LIBC, new DefaultLibCProvider(), handler);
    }

    public static POSIX loadOpenBSDPOSIX(POSIXHandler handler) {
        return new OpenBSDPOSIX(LIBC, new DefaultLibCProvider(), handler);
    }

    public static POSIX loadWindowsPOSIX(POSIXHandler handler) {
        return new WindowsPOSIX(LIBC, new WindowsLibCProvider(), handler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WindowsLibCProvider
    implements LibCProvider {
        private WindowsLibCProvider() {
        }

        @Override
        public final LibC getLibC() {
            return SingletonHolder.libc;
        }

        static final Map<LibraryOption, Object> getOptions() {
            HashMap<LibraryOption, Object> options = new HashMap<LibraryOption, Object>(defaultOptions);
            options.put(LibraryOption.FunctionMapper, WindowsLibCFunctionMapper.INSTANCE);
            return options;
        }

        static final class SingletonHolder {
            public static LibC libc = Library.loadLibrary(WindowsLibC.class, WindowsLibCProvider.getOptions(), "msvcrt", "kernel32");

            SingletonHolder() {
            }
        }
    }

    private static final class SolarisLibCProvider
    implements LibCProvider {
        private SolarisLibCProvider() {
        }

        public final LibC getLibC() {
            return SingletonHolder.libc;
        }

        private static final class SingletonHolder {
            public static LibC libc = Library.loadLibrary(LibC.class, defaultOptions, "socket", "nsl", "c");

            private SingletonHolder() {
            }
        }
    }

    private static final class LinuxLibCProvider
    implements LibCProvider {
        private LinuxLibCProvider() {
        }

        public final LibC getLibC() {
            return SingletonHolder.libc;
        }

        private static final class SingletonHolder {
            public static LibC libc = Library.loadLibrary(LinuxLibC.class, defaultOptions, "libc.so.6");

            private SingletonHolder() {
            }
        }
    }

    private static final class DefaultLibCProvider
    implements LibCProvider {
        private DefaultLibCProvider() {
        }

        public final LibC getLibC() {
            return SingletonHolder.libc;
        }

        private static final class SingletonHolder {
            public static LibC libc = Library.loadLibrary(LibC.class, defaultOptions, "c");

            private SingletonHolder() {
            }
        }
    }
}

