/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.functions.Extensions;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.nwalsh.saxon.ColumnScanEmitter;
import com.nwalsh.saxon.ColumnUpdateEmitter;
import java.util.Hashtable;
import javax.xml.transform.TransformerException;

public class Table {
    private static int pixelsPerInch = 96;
    private static int nominalWidth = 6 * pixelsPerInch;
    private static String tableWidth = "100%";
    private static boolean foStylesheet = false;
    protected static Hashtable unitHash = null;

    protected static void initializeHash() {
        unitHash = new Hashtable();
        unitHash.put("in", new Float(pixelsPerInch));
        unitHash.put("cm", new Float((double)pixelsPerInch / 2.54));
        unitHash.put("mm", new Float((double)pixelsPerInch / 25.4));
        unitHash.put("pc", new Float(pixelsPerInch / 72 * 12));
        unitHash.put("pt", new Float(pixelsPerInch / 72));
        unitHash.put("px", new Float(1.0f));
    }

    public static void setPixelsPerInch(int value) {
        if (value > 0) {
            pixelsPerInch = value;
            Table.initializeHash();
        }
    }

    public int getPixelsPerInch() {
        return pixelsPerInch;
    }

    public static int convertLength(String length) {
        int sign = 1;
        String digits = "";
        String units = "";
        char[] lench = length.toCharArray();
        float flength = 0.0f;
        boolean done = false;
        int pos = 0;
        float factor = 1.0f;
        int pixels = 0;
        if (unitHash == null) {
            Table.initializeHash();
        }
        if (lench[pos] == '+' || lench[pos] == '-') {
            if (lench[pos] == '-') {
                sign = -1;
            }
            ++pos;
        }
        while (!done) {
            if (pos >= lench.length) {
                done = true;
                continue;
            }
            if ((lench[pos] > '9' || lench[pos] < '0') && lench[pos] != '.') {
                done = true;
                units = length.substring(pos);
                continue;
            }
            digits = digits + lench[pos++];
        }
        try {
            flength = Float.parseFloat(digits);
        }
        catch (NumberFormatException e) {
            System.out.println(digits + " is not a number; 1 used instead.");
            flength = 1.0f;
        }
        Float f = null;
        if (!units.equals("")) {
            f = (Float)unitHash.get(units);
            if (f == null) {
                System.out.println(units + " is not a known unit; 1 used instead.");
                factor = 1.0f;
            } else {
                factor = f.floatValue();
            }
        } else {
            factor = 1.0f;
        }
        f = new Float(flength * factor);
        pixels = f.intValue() * sign;
        return pixels;
    }

    protected static String getVariable(Context context, String varName) throws TransformerException {
        Value variable = null;
        String varString = null;
        try {
            variable = Extensions.evaluate((Context)context, (String)("$" + varName));
            varString = variable.asString();
            return varString;
        }
        catch (IllegalArgumentException e) {
            System.out.println("Undefined variable: " + varName);
            return "";
        }
    }

    private static void setupColumnWidths(Context context) {
        nominalWidth = 6 * pixelsPerInch;
        tableWidth = "100%";
        String varString = null;
        try {
            varString = Table.getVariable(context, "stylesheet.result.type");
            foStylesheet = varString.equals("fo");
            varString = Table.getVariable(context, "nominal.table.width");
            nominalWidth = Table.convertLength(varString);
            tableWidth = varString = Table.getVariable(context, "table.width");
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public static NodeSetValue adjustColumnWidths(Context context, NodeSetValue rtf_ns) {
        FragmentValue rtf = (FragmentValue)rtf_ns;
        Table.setupColumnWidths(context);
        try {
            int count;
            Controller controller = context.getController();
            NamePool namePool = controller.getNamePool();
            ColumnScanEmitter csEmitter = new ColumnScanEmitter(namePool);
            rtf.replay((Emitter)csEmitter);
            int numColumns = csEmitter.columnCount();
            String[] widths = csEmitter.columnWidths();
            float relTotal = 0.0f;
            float[] relParts = new float[numColumns];
            float absTotal = 0.0f;
            float[] absParts = new float[numColumns];
            for (count = 0; count < numColumns; ++count) {
                String width = widths[count];
                int pos = width.indexOf("*");
                if (pos >= 0) {
                    String relPart = width.substring(0, pos);
                    String absPart = width.substring(pos + 1);
                    try {
                        float rel = Float.parseFloat(relPart);
                        relTotal += rel;
                        relParts[count] = rel;
                    }
                    catch (NumberFormatException e) {
                        System.out.println(relPart + " is not a valid relative unit.");
                    }
                    int pixels = 0;
                    if (absPart != null && !absPart.equals("")) {
                        pixels = Table.convertLength(absPart);
                    }
                    absTotal += (float)pixels;
                    absParts[count] = pixels;
                    continue;
                }
                relParts[count] = 0.0f;
                int pixels = 0;
                if (width != null && !width.equals("")) {
                    pixels = Table.convertLength(width);
                }
                absTotal += (float)pixels;
                absParts[count] = pixels;
            }
            if (relTotal == 0.0f) {
                for (count = 0; count < numColumns; ++count) {
                    Float f = new Float(absParts[count]);
                    if (foStylesheet) {
                        int pixels = f.intValue();
                        float inches = (float)pixels / (float)pixelsPerInch;
                        widths[count] = inches + "in";
                        continue;
                    }
                    widths[count] = Integer.toString(f.intValue());
                }
            } else if (absTotal == 0.0f) {
                for (count = 0; count < numColumns; ++count) {
                    float rel = relParts[count] / relTotal * 100.0f;
                    Float f = new Float(rel);
                    widths[count] = Integer.toString(f.intValue());
                }
                widths = Table.correctRoundingError(widths);
            } else {
                int count2;
                int pixelWidth = nominalWidth;
                if (tableWidth.indexOf("%") <= 0) {
                    pixelWidth = Table.convertLength(tableWidth);
                }
                if ((float)pixelWidth <= absTotal) {
                    System.out.println("Table is wider than table width.");
                } else {
                    pixelWidth = (int)((float)pixelWidth - absTotal);
                }
                absTotal = 0.0f;
                for (count2 = 0; count2 < numColumns; ++count2) {
                    float rel = relParts[count2] / relTotal * (float)pixelWidth;
                    relParts[count2] = rel + absParts[count2];
                    absTotal += rel + absParts[count2];
                }
                if (tableWidth.indexOf("%") <= 0) {
                    for (count2 = 0; count2 < numColumns; ++count2) {
                        Float f = new Float(relParts[count2]);
                        if (foStylesheet) {
                            int pixels = f.intValue();
                            float inches = (float)pixels / (float)pixelsPerInch;
                            widths[count2] = inches + "in";
                            continue;
                        }
                        widths[count2] = Integer.toString(f.intValue());
                    }
                } else {
                    for (count2 = 0; count2 < numColumns; ++count2) {
                        float rel = relParts[count2] / absTotal * 100.0f;
                        Float f = new Float(rel);
                        widths[count2] = Integer.toString(f.intValue());
                    }
                    widths = Table.correctRoundingError(widths);
                }
            }
            ColumnUpdateEmitter cuEmitter = new ColumnUpdateEmitter(controller, namePool, widths);
            rtf.replay((Emitter)cuEmitter);
            return cuEmitter.getResultTreeFragment();
        }
        catch (TransformerException e) {
            System.out.println("Transformer Exception in adjustColumnWidths");
            return rtf;
        }
    }

    protected static String[] correctRoundingError(String[] widths) {
        int totalWidth = 0;
        for (int count = 0; count < widths.length; ++count) {
            try {
                int width = Integer.parseInt(widths[count]);
                totalWidth += width;
                continue;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        float totalError = 100 - totalWidth;
        float columnError = totalError / (float)widths.length;
        float error = 0.0f;
        for (int count = 0; count < widths.length; ++count) {
            try {
                int width = Integer.parseInt(widths[count]);
                error += columnError;
                if ((double)error >= 1.0) {
                    int adj = (int)Math.round(Math.floor(error));
                    error -= (float)Math.floor(error);
                    widths[count] = Integer.toString(width += adj) + "%";
                    continue;
                }
                widths[count] = Integer.toString(width) + "%";
                continue;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return widths;
    }
}

