/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.NodeSetExpression;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.TextFragmentValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.tree.AttributeCollection;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLCopyOf
extends StyleElement {
    Expression select;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.SELECT) {
                string = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        } else {
            this.reportAbsence("select");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.checkEmpty();
    }

    public void process(Context context) throws TransformerException {
        if (this.select instanceof NodeSetExpression) {
            this.copyNodeSet(this.select, context);
        } else {
            Value value = this.select.evaluate(context);
            if (value instanceof FragmentValue) {
                ((FragmentValue)value).copy(context.getOutputter());
            } else if (value instanceof TextFragmentValue) {
                ((TextFragmentValue)value).copy(context.getOutputter());
            } else if (value instanceof NodeSetValue) {
                this.copyNodeSet((NodeSetValue)value, context);
            } else {
                context.getOutputter().writeContent(value.asString());
            }
        }
    }

    private void copyNodeSet(Expression expression, Context context) throws TransformerException {
        Outputter outputter = context.getOutputter();
        NodeEnumeration nodeEnumeration = expression.enumerate(context, true);
        while (nodeEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo = nodeEnumeration.nextElement();
            nodeInfo.copy(outputter);
        }
    }
}

