#ifndef _XRDOSSDEFAULTSS_H
#define _XRDOSSDEFAULTSS_H
/******************************************************************************/
/*                                                                            */
/*                       X r d O s s D e f a u l t S S                        */
/*                                                                            */
/* (c) 2012 by the Board of Trustees of the Leland Stanford, Jr., University  */
/*                            All Rights Reserved                             */
/*   Produced by Andrew Hanushevsky for Stanford University under contract    */
/*              DE-AC02-76-SFO0515 with the Department of Energy              */
/*                                                                            */
/* This file is part of the XRootD software suite.                            */
/*                                                                            */
/* XRootD is free software: you can redistribute it and/or modify it under    */
/* the terms of the GNU Lesser General Public License as published by the     */
/* Free Software Foundation, either version 3 of the License, or (at your     */
/* option) any later version.                                                 */
/*                                                                            */
/* XRootD is distributed in the hope that it will be useful, but WITHOUT      */
/* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or      */
/* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public       */
/* License for more details.                                                  */
/*                                                                            */
/* You should have received a copy of the GNU Lesser General Public License   */
/* along with XRootD in a file called COPYING.LESSER (LGPL license) and file  */
/* COPYING (GPL license).  If not, see <http://www.gnu.org/licenses/>.        */
/*                                                                            */
/* The copyright holder's institutional names and contributor's names may not */
/* be used to endorse or promote products derived from this software without  */
/* specific prior written permission of the institution or contributor.       */
/******************************************************************************/

#include "XrdVersion.hh"
#include "XrdOss/XrdOss.hh"

//-----------------------------------------------------------------------------
//! Get the default Storage System object.
//!
//! Include this file in your code to declare the external function that
//! obtains a default version of the XrdOss object; then simply invoke it.
//!
//! @param  logger  the address of the logging object to direct messages.
//! @param  cfg_fn  the address of the configuration file path.
//! @param  urVer   the version string associated with your code. This is
//!                 generated by the XrdVERSIONINFODEF macro and can be found
//!                 in XrdVersion.hh include file. You must supply a compatible
//!                 version identification string.
//!
//! @return XrdOss  pointer to a default configured storage system object.
//!         0       a storage system object could not be created because of
//!                 configration problems or your version is incompatible.
//-----------------------------------------------------------------------------

extern XrdOss *XrdOssDefaultSS(XrdSysLogger   *logger,
                               const char     *cfg_fn,
                               XrdVersionInfo &urVer);
#endif
