
#ifndef PIMCOMMON_EXPORT_H
#define PIMCOMMON_EXPORT_H

#ifdef PIMCOMMON_STATIC_DEFINE
#  define PIMCOMMON_EXPORT
#  define PIMCOMMON_NO_EXPORT
#else
#  ifndef PIMCOMMON_EXPORT
#    ifdef KPim6PimCommon_EXPORTS
        /* We are building this library */
#      define PIMCOMMON_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define PIMCOMMON_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef PIMCOMMON_NO_EXPORT
#    define PIMCOMMON_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef PIMCOMMON_DECL_DEPRECATED
#  define PIMCOMMON_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef PIMCOMMON_DECL_DEPRECATED_EXPORT
#  define PIMCOMMON_DECL_DEPRECATED_EXPORT PIMCOMMON_EXPORT PIMCOMMON_DECL_DEPRECATED
#endif

#ifndef PIMCOMMON_DECL_DEPRECATED_NO_EXPORT
#  define PIMCOMMON_DECL_DEPRECATED_NO_EXPORT PIMCOMMON_NO_EXPORT PIMCOMMON_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef PIMCOMMON_NO_DEPRECATED
#    define PIMCOMMON_NO_DEPRECATED
#  endif
#endif
#include <pimcommon_version.h>

#define PIMCOMMON_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(PIMCOMMON_NO_DEPRECATED)
#  undef PIMCOMMON_DEPRECATED
#  define PIMCOMMON_DEPRECATED_EXPORT PIMCOMMON_EXPORT
#  define PIMCOMMON_DEPRECATED_NO_EXPORT PIMCOMMON_NO_EXPORT
#elif defined(PIMCOMMON_NO_DEPRECATED_WARNINGS)
#  define PIMCOMMON_DEPRECATED
#  define PIMCOMMON_DEPRECATED_EXPORT PIMCOMMON_EXPORT
#  define PIMCOMMON_DEPRECATED_NO_EXPORT PIMCOMMON_NO_EXPORT
#else
#  define PIMCOMMON_DEPRECATED PIMCOMMON_DECL_DEPRECATED
#  define PIMCOMMON_DEPRECATED_EXPORT PIMCOMMON_DECL_DEPRECATED_EXPORT
#  define PIMCOMMON_DEPRECATED_NO_EXPORT PIMCOMMON_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define PIMCOMMON_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define PIMCOMMON_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef PIMCOMMON_NO_DEPRECATED
#  define PIMCOMMON_DISABLE_DEPRECATED_BEFORE_AND_AT PIMCOMMON_VERSION
#endif
#ifdef PIMCOMMON_NO_DEPRECATED_WARNINGS
#  define PIMCOMMON_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef PIMCOMMON_DEPRECATED_WARNINGS_SINCE
#  ifdef PIMCOMMON_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define PIMCOMMON_DEPRECATED_WARNINGS_SINCE PIMCOMMON_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define PIMCOMMON_DEPRECATED_WARNINGS_SINCE PIMCOMMON_VERSION
#  endif
#endif

#ifndef PIMCOMMON_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define PIMCOMMON_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef PIMCOMMON_DEPRECATED
#  define PIMCOMMON_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > PIMCOMMON_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define PIMCOMMON_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* PIMCOMMON_EXPORT_H */
