%%
%% This is file `rub-kunstgeschichte.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% rub-kunstgeschichte.dtx  (with options: `class')
%% 
%% This is a generated file.
%% 
%% Copyright (C) 2024 by Joran Schneyer <joran.schneyer@ruhr-uni-bochum.de>
%% 
%% This work may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3c
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%   https://www.latex-project.org/lppl.txt
%% and version 1.3c or later is part of all distributions of LaTeX
%% version 2008 or later.
%% 
%% This work has the LPPL maintenance status `maintained'.
%% 
%% The Current Maintainer of this work is Joran Schneyer <joran.schneyer@ruhr-uni-bochum.de>.
%% 
%% This work consists of the files rub-kunstgeschichte.dtx
%%                                 rub-kunstgeschichte.ins
%%           and the derived files rub-kunstgeschichte.cls
%%                                 rub-kunstgeschichte-example.tex
%% 

\NeedsTeXFormat{LaTeX2e}[2022-06-01]
\ProvidesClass{rub-kunstgeschichte}
    [2024-10-30 v0.3.0 RUB Kunstgeschichte class]
%% Class options
\DeclareKeys[rubkgi]{
    biblatex.store = \@rubkgi@biblatexOptions,
    biblatex.usage = load
}
\DeclareKeys[rubkgi]{
    hyperref.code  = \PassOptionsToPackage{#1}{hyperref},
    hyperref.usage = load
}
%% TeX switch to decide wether to load the parskip package
\newif\if@rubkgi@parskip
\@rubkgi@parskiptrue
\DeclareKeys[rubkgi]{
    parskip.if      = @rubkgi@parskip,
    parskip.usage   = load,
    noparskip.ifnot = @rubkgi@parskip,
    noparskip.usage = load
}
\ProcessKeyOptions[rubkgi]
%% Load base class with 12pt base font size
\LoadClass[12pt]{article}
%% biblatex options
\PassOptionsToPackage{
    backend=biber,
    singletitle=true,
    autocite=footnote,
    autopunct=true
}{biblatex}
%% biblatex-arthistory-bonn package
\PassOptionsToPackage{
    style=arthistory-bonn,
    firstcitefull=true,
    enddot=true,
    namelinked=true
}{biblatex}
%% pass biblatex class options along
\PassOptionsToPackage{\@rubkgi@biblatexOptions}{biblatex}
%% load biblatex
\RequirePackage{biblatex}
%% Set 1.5 times line spacing
\RequirePackage[onehalfspacing]{setspace}
%% Set a4 paper size and margins
\RequirePackage[
    a4paper,
    top=2cm,left=2cm,bottom=2cm,right=4cm
]{geometry}
%% Avoid paragraph indentation
\if@rubkgi@parskip
    \RequirePackage{parskip}
\fi
%% Hyperref
\RequirePackage{hyperref}
\hypersetup{hidelinks}
%% Translations
\RequirePackage{translations}
%% Other
\RequirePackage{tabularx} % For fancy tables. Is used in title page.
\RequirePackage{boxedminipage} % Used in title page.
%% Macros
\newcommand{\printbibliographies}[1][]{%
    \SetKeys[rubkgi@printbibliographies]{#1}%
    \addcontentsline{toc}{section}{%
        \texorpdfstring{\@rubkgi@bibheading}{bibliography}%
    }%
    \printbibheading[%
        heading = bibliography,%
        title = {\@rubkgi@bibheading}%
    ]
    \printbibliography[%
        keyword = source,%
        heading = subbibliography,%
        title = {\@rubkgi@bibheading@primary}%
    ]
    \printbibliography[%
        notkeyword = source,%
        heading = subbibliography,%
        title = {\@rubkgi@bibheading@secondary}%
    ]
}
\newcommand*{\@rubkgi@bibheading}{
    \GetTranslationWarn{Bibliography}
}
\newcommand*{\@rubkgi@bibheading@primary}{
    \GetTranslationWarn{Primary Bibliography}
}
\newcommand*{\@rubkgi@bibheading@secondary}{
    \GetTranslationWarn{Secondary Bibliography}
}
\DeclareKeys[rubkgi@printbibliographies]
{
    heading           .store = \@rubkgi@bibheading,
    heading-primary   .store = \@rubkgi@bibheading@primary,
    heading-secondary .store = \@rubkgi@bibheading@secondary
}
\renewcommand{\maketitle}[1][]{%
    \SetKeys[rubkgi@titlepage]{#1}%
    \@rubkgi@maketitle%
}
\newcommand{\@rubkgi@maketitle}{
    \begin{titlepage}
        % set page margins for the title page
        \newgeometry{left=2.5cm,top=2.5cm,bottom=2cm,right=2.5cm}%
        % define the width of the grade box
        \def\@rubkgi@titlepage@gradebox@width{5.03cm}%
        %
        % create a group for the top part of the title page
        {\raggedright%
        % create a minipage for the top left part
        \begin{minipage}[t]%
        % calculate the width of the top left part
        % based on the grade box width
        {\dimexpr\textwidth%
        -\@rubkgi@titlepage@gradebox@width%
        -0.5cm\relax}%
        \vspace{0pt}% somehow helps aligning at the top
        \begin{tabularx}{\linewidth}{@{}lX}%
            \multicolumn{2}{@{}l}{%
                Ruhr-Universität Bochum%
            }\\%
            \multicolumn{2}{@{}l}{%
                Fakultät für Geschichtswissenschaft%
            }\\%
            \multicolumn{2}{@{}l}{%
                Kunstgeschichtliches Institut%
            }\\%
            \multicolumn{2}{@{}l}{%
                \@rubkgi@titlepage@seminar@semester%
            }\\%
            Dozent:in:    & \@rubkgi@titlepage@seminar@lecturer\\%
            Seminartitel: & \@rubkgi@titlepage@seminar@name\\%
            Studiengang:  & \@rubkgi@titlepage@seminar@degree\\%
            Modul:        & \@rubkgi@titlepage@seminar@module\\%
            Kreditpunkte: & \@rubkgi@titlepage@seminar@creditpoints\\%
        \end{tabularx}%
        \end{minipage}%
        % align grade box on the right side by filling in the gap
        \hfill%
        % define the grade box as a boxedminipage
        \begin{boxedminipage}[t][3.78cm][t]%
        {\@rubkgi@titlepage@gradebox@width}%
        % leave a little space and add the text inside
        \vspace{1em}%
        \hspace{1em}Note:%
        \end{boxedminipage}%
        }% top part ends here
        %
        \vfill% vertical space to fill
        %
        % create center part (title and author)
        \begin{center}%
        % add title relatively LARGE
        {\LARGE \@title \par}%
        \vskip 2em% add space between title and author
        % add author slightly larger than normal text
        {\large \@author \par}%
        % end the center environment
        % and switch back to normal paragraph text style
        \end{center}\par%
        %
        \vfill% fill gap to put next part at bottom
        %
        % create bottom part
        {\raggedright%
        \begin{tabular}{@{}ll}%
            Matrikelnr.: & \@rubkgi@titlepage@author@matricnum\\%
            % Add email as a clickable link
            Email: & \href{mailto:\@rubkgi@titlepage@author@email}%
                                 {\@rubkgi@titlepage@author@email}\\%
            Fachsemester: & \@rubkgi@titlepage@author@semester\\%
            Abgabetermin: & \@date\\%
        \end{tabular}
        }%
    \end{titlepage}%
    \setcounter{page}{2}%
    \restoregeometry%
}
\DeclareKeys[rubkgi@titlepage]
{
    email            .store = \@rubkgi@titlepage@author@email,
    matricnum        .store = \@rubkgi@titlepage@author@matricnum,
    author-semester  .store = \@rubkgi@titlepage@author@semester,
    seminar-semester .store = \@rubkgi@titlepage@seminar@semester,
    seminar-lecturer .store = \@rubkgi@titlepage@seminar@lecturer,
    seminar-name     .store = \@rubkgi@titlepage@seminar@name,
    seminar-degree   .store = \@rubkgi@titlepage@seminar@degree,
    seminar-module   .store = \@rubkgi@titlepage@seminar@module,
    seminar-cp       .store = \@rubkgi@titlepage@seminar@creditpoints
}
\SetKeys[rubkgi@titlepage]
{
    email            = {YOUR-EMAIL},
    matricnum        = {YOUR MATRICULATION NUMBER},
    author-semester  = {YOUR NUMBER OF SEMESTERS},
    seminar-semester = {THE SEMESTER IN WHCIH THE SEMINAR IS HELD},
    seminar-lecturer = {NAME OF SEMINAR LECTURER},
    seminar-name     = {NAME OF THE SEMINAR},
    seminar-degree   = {DEGREE SEMINAR IS TAKEN IN},
    seminar-module   = {MODULE SEMINAR IS TAKEN IN},
    seminar-cp       = {SEMINAR CP}
}
\newcommand{\configureTitlepage}[1]{%
    \SetKeys[rubkgi@titlepage]{#1}%
}
\DeclareTranslation{english}{Primary Bibliography}{Primary sources}
\DeclareTranslation{german}{Primary Bibliography}{Primärliteratur}
\DeclareTranslation{english}{Secondary Bibliography}{Secondary literature}
\DeclareTranslation{german}{Secondary Bibliography}{Sekundärliteratur}

\endinput
%%
%% End of file `rub-kunstgeschichte.cls'.
