/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.trans.XPathException;

public class TransformerReceiver
extends ProxyReceiver {
    Controller controller;
    Builder builder;
    Result result;

    public TransformerReceiver(Controller controller) {
        this.controller = controller;
    }

    public void open() throws XPathException {
        this.builder = this.controller.makeBuilder();
        this.setPipelineConfiguration(this.builder.getPipelineConfiguration());
        this.builder.setSystemId(this.systemId);
        Receiver stripper = this.controller.makeStripper(this.builder);
        if (this.controller.getExecutable().stripsInputTypeAnnotations()) {
            stripper = this.controller.getConfiguration().getAnnotationStripper(stripper);
        }
        this.setUnderlyingReceiver(stripper);
        this.nextReceiver.open();
    }

    public Transformer getTransformer() {
        return this.controller;
    }

    public void setSystemId(String systemId) {
        super.setSystemId(systemId);
        this.controller.setBaseOutputURI(systemId);
    }

    public void setResult(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("Result must not be null");
        }
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public void close() throws XPathException {
        this.nextReceiver.close();
        DocumentInfo doc = (DocumentInfo)this.builder.getCurrentRoot();
        this.builder.reset();
        this.builder = null;
        if (doc == null) {
            throw new XPathException("No source document has been built");
        }
        try {
            this.controller.transformDocument(doc, this.result);
        }
        catch (TransformerException e) {
            throw XPathException.makeXPathException(e);
        }
    }
}

