/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.StandardURIResolver;
import com.icl.saxon.om.ProcInstParser;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PIGrabber
extends DefaultHandler {
    private String reqMedia = null;
    private String reqTitle = null;
    private String baseURI = null;
    private URIResolver uriResolver = null;
    private Vector stylesheets = new Vector();

    public void setCriteria(String string, String string2, String string3) {
        this.reqMedia = string;
        this.reqTitle = string2;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        throw new SAXException("#start#");
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (string.equals("xml-stylesheet")) {
            String string3 = ProcInstParser.getPseudoAttribute(string2, "media");
            String string4 = ProcInstParser.getPseudoAttribute(string2, "title");
            String string5 = ProcInstParser.getPseudoAttribute(string2, "type");
            String string6 = ProcInstParser.getPseudoAttribute(string2, "alternate");
            if (string5 == null) {
                return;
            }
            if ((string5.equals("text/xml") || string5.equals("application/xml") || string5.equals("text/xsl") || string5.equals("applicaton/xsl")) && (this.reqMedia == null || string3 == null || this.reqMedia.equals(string3)) && (string4 == null && (string6 == null || string6.equals("no")) || this.reqTitle == null || string4 != null && string4.equals(this.reqTitle))) {
                String string7 = ProcInstParser.getPseudoAttribute(string2, "href");
                if (string7 == null) {
                    throw new SAXException("xml-stylesheet PI has no href attribute");
                }
                if (string4 == null && (string6 == null || string6.equals("no"))) {
                    this.stylesheets.insertElementAt(string7, 0);
                } else {
                    this.stylesheets.addElement(string7);
                }
            }
        }
    }

    public SAXSource[] getAssociatedStylesheets() throws TransformerException {
        if (this.stylesheets.size() == 0) {
            return null;
        }
        if (this.uriResolver == null) {
            this.uriResolver = new StandardURIResolver();
        }
        SAXSource[] sAXSourceArray = new SAXSource[this.stylesheets.size()];
        int n = 0;
        while (n < this.stylesheets.size()) {
            String string = (String)this.stylesheets.elementAt(n);
            Source source = this.uriResolver.resolve(string, this.baseURI);
            if (!(source instanceof SAXSource)) {
                throw new TransformerException("Associated stylesheet URI must yield a SAX source");
            }
            sAXSourceArray[n] = (SAXSource)source;
            ++n;
        }
        return sAXSourceArray;
    }

    public String[] getStylesheetURIs() throws SAXException {
        if (this.stylesheets.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.stylesheets.size()];
        int n = 0;
        while (n < this.stylesheets.size()) {
            stringArray[n] = (String)this.stylesheets.elementAt(n);
            ++n;
        }
        return stringArray;
    }
}

