/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutableFunctionLibrary
implements FunctionLibrary {
    private transient Configuration config;
    private HashMap<String, UserFunction> functions = new HashMap(20);

    public ExecutableFunctionLibrary(Configuration config) {
        this.config = config;
    }

    private String makeKey(StructuredQName functionName, int arity) {
        String uri = functionName.getNamespaceURI();
        String local = functionName.getLocalName();
        FastStringBuffer sb = new FastStringBuffer(uri.length() + local.length() + 8);
        sb.append('{');
        sb.append(uri);
        sb.append('}');
        sb.append(local);
        sb.append("#" + arity);
        return sb.toString();
    }

    public void addFunction(UserFunction fn) {
        this.functions.put(this.makeKey(fn.getFunctionName(), fn.getNumberOfArguments()), fn);
    }

    @Override
    public SequenceType[] getFunctionSignature(StructuredQName functionName, int arity) {
        if (arity == -1) {
            for (int i = 0; i <= 20; ++i) {
                SequenceType[] sig = this.getFunctionSignature(functionName, i);
                if (sig == null) continue;
                return sig;
            }
            return null;
        }
        UserFunction uf = this.functions.get(this.makeKey(functionName, arity));
        if (uf != null) {
            SequenceType[] sig = new SequenceType[arity + 1];
            UserFunctionParameter[] params = uf.getParameterDefinitions();
            sig[0] = uf.getResultType(this.config.getTypeHierarchy());
            for (int i = 0; i < params.length; ++i) {
                sig[i + 1] = params[i].getRequiredType();
            }
            return sig;
        }
        return null;
    }

    @Override
    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env, Container container) throws XPathException {
        UserFunction fn = this.functions.get(this.makeKey(functionName, staticArgs.length));
        if (fn == null) {
            return null;
        }
        ExpressionVisitor visitor = ExpressionVisitor.make(env, fn.getExecutable());
        UserFunctionCall fc = new UserFunctionCall();
        fc.setFunctionName(functionName);
        fc.setArguments(staticArgs);
        fc.setFunction(fn);
        fc.checkFunctionCall(fn, visitor);
        fc.setStaticType(fn.getResultType(this.config.getTypeHierarchy()));
        return fc;
    }

    @Override
    public FunctionLibrary copy() {
        ExecutableFunctionLibrary efl = new ExecutableFunctionLibrary(this.config);
        efl.functions = new HashMap<String, UserFunction>(this.functions);
        return efl;
    }

    public Iterator<UserFunction> iterateFunctions() {
        return this.functions.values().iterator();
    }
}

