/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ur extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "فجی";
        final String metaValue_ar = "عربی";
        final String metaValue_hy = "آرمینیائی";
        final String metaValue_chr = "چیروکی";
        final String metaValue_ka = "جارجیائی";
        final String metaValue_el = "یونانی";
        final String metaValue_gu = "گجراتی";
        final String metaValue_he = "عبرانی";
        final String metaValue_ja = "جاپانی";
        final String metaValue_km = "خمیر";
        final String metaValue_ko = "کوریائی";
        final String metaValue_lo = "لاؤ";
        final String metaValue_la = "لاطینی";
        final String metaValue_ml = "ملیالم";
        final String metaValue_or = "اڑیہ";
        final String metaValue_si = "سنہالا";
        final String metaValue_syr = "سریانی";
        final String metaValue_ta = "تمل";
        final String metaValue_te = "تیلگو";
        final String metaValue_th = "تھائی";
        final String metaValue_bo = "تبتی";
        final String metaValue_vai = "وائی";
        final String metaValue_MD = "مالدووا";
        final Object[][] data = new Object[][] {
            { "001", "دنیا" },
            { "002", "افریقہ" },
            { "003", "شمالی امریکہ" },
            { "005", "جنوبی امریکہ" },
            { "009", "اوشیانیا" },
            { "011", "مغربی افریقہ" },
            { "013", "وسطی امریکہ" },
            { "014", "مشرقی افریقہ" },
            { "015", "شمالی افریقہ" },
            { "017", "وسطی افریقہ" },
            { "018", "جنوبی افریقہ کا علاقہ" },
            { "019", "امیریکاز" },
            { "021", "شمالی امریکہ کا علاقہ" },
            { "029", "کریبیائی" },
            { "030", "مشرقی ایشیا" },
            { "034", "جنوبی ایشیا" },
            { "035", "جنوب مشرقی ایشیا" },
            { "039", "جنوبی یورپ" },
            { "053", "آسٹریلیشیا" },
            { "054", "مالینیشیا" },
            { "057", "مائکرونیشیائی علاقہ" },
            { "061", "پولینیشیا" },
            { "142", "ایشیا" },
            { "143", "وسطی ایشیا" },
            { "145", "مغربی ایشیا" },
            { "150", "یورپ" },
            { "151", "مشرقی یورپ" },
            { "154", "شمالی یورپ" },
            { "155", "مغربی یورپ" },
            { "202", "ذیلی صحارن افریقہ" },
            { "419", "لاطینی امریکہ" },
            { "AC", "اسینشن آئلینڈ" },
            { "AD", "انڈورا" },
            { "AE", "متحدہ عرب امارات" },
            { "AF", "افغانستان" },
            { "AG", "انٹیگوا اور باربودا" },
            { "AI", "انگوئیلا" },
            { "AL", "البانیہ" },
            { "AM", "آرمینیا" },
            { "AO", "انگولا" },
            { "AQ", "انٹارکٹیکا" },
            { "AR", "ارجنٹینا" },
            { "AS", "امریکی ساموآ" },
            { "AT", "آسٹریا" },
            { "AU", "آسٹریلیا" },
            { "AW", "اروبا" },
            { "AX", "آلینڈ آئلینڈز" },
            { "AZ", "آذربائیجان" },
            { "BA", "بوسنیا اور ہرزیگووینا" },
            { "BB", "بارباڈوس" },
            { "BD", "بنگلہ دیش" },
            { "BE", "بیلجیم" },
            { "BF", "برکینا فاسو" },
            { "BG", "بلغاریہ" },
            { "BH", "بحرین" },
            { "BI", "برونڈی" },
            { "BJ", "بینن" },
            { "BL", "سینٹ برتھلیمی" },
            { "BM", "برمودا" },
            { "BN", "برونائی" },
            { "BO", "بولیویا" },
            { "BQ", "کریبیائی نیدرلینڈز" },
            { "BR", "برازیل" },
            { "BS", "بہاماس" },
            { "BT", "بھوٹان" },
            { "BV", "بؤویٹ آئلینڈ" },
            { "BW", "بوتسوانا" },
            { "BY", "بیلاروس" },
            { "BZ", "بیلائز" },
            { "CA", "کینیڈا" },
            { "CC", "کوکوس (کیلنگ) جزائر" },
            { "CD", "کانگو - کنشاسا" },
            { "CF", "وسط افریقی جمہوریہ" },
            { "CG", "کانگو - برازاویلے" },
            { "CH", "سوئٹزر لینڈ" },
            { "CI", "کوٹ ڈی آئیوری" },
            { "CK", "کک آئلینڈز" },
            { "CL", "چلی" },
            { "CM", "کیمرون" },
            { "CN", "چین" },
            { "CO", "کولمبیا" },
            { "CP", "کلپرٹن آئلینڈ" },
            { "CQ", "سارک" },
            { "CR", "کوسٹا ریکا" },
            { "CU", "کیوبا" },
            { "CV", "کیپ ورڈی" },
            { "CW", "کیوراکاؤ" },
            { "CX", "جزیرہ کرسمس" },
            { "CY", "قبرص" },
            { "CZ", "چیکیا" },
            { "DE", "جرمنی" },
            { "DG", "ڈائجو گارسیا" },
            { "DJ", "جبوتی" },
            { "DK", "ڈنمارک" },
            { "DM", "ڈومنیکا" },
            { "DO", "جمہوریہ ڈومينيکن" },
            { "DZ", "الجیریا" },
            { "EA", "سیئوٹا اور میلیلا" },
            { "EC", "ایکواڈور" },
            { "EE", "اسٹونیا" },
            { "EG", "مصر" },
            { "EH", "مغربی صحارا" },
            { "ER", "اریٹیریا" },
            { "ES", "ہسپانیہ" },
            { "ET", "ایتھوپیا" },
            { "EU", "یوروپی یونین" },
            { "EZ", "یوروزون" },
            { "FI", "فن لینڈ" },
            { "FJ", metaValue_FJ },
            { "FK", "فاکلینڈ جزائر" },
            { "FM", "مائکرونیشیا" },
            { "FO", "جزائر فارو" },
            { "FR", "فرانس" },
            { "GA", "گیبون" },
            { "GB", "سلطنت متحدہ" },
            { "GD", "گریناڈا" },
            { "GE", "جارجیا" },
            { "GF", "فرینچ گیانا" },
            { "GG", "گوئرنسی" },
            { "GH", "گھانا" },
            { "GI", "جبل الطارق" },
            { "GL", "گرین لینڈ" },
            { "GM", "گیمبیا" },
            { "GN", "گنی" },
            { "GP", "گواڈیلوپ" },
            { "GQ", "استوائی گیانا" },
            { "GR", "یونان" },
            { "GS", "جنوبی جارجیا اور جنوبی سینڈوچ جزائر" },
            { "GT", "گواٹے مالا" },
            { "GU", "گوام" },
            { "GW", "گنی بساؤ" },
            { "GY", "گیانا" },
            { "HK", "ہانگ کانگ SAR چین" },
            { "HM", "ہیرڈ جزیرہ و میکڈولینڈ جزائر" },
            { "HN", "ہونڈاروس" },
            { "HR", "کروشیا" },
            { "HT", "ہیٹی" },
            { "HU", "ہنگری" },
            { "IC", "کینری آئلینڈز" },
            { "ID", "انڈونیشیا" },
            { "IE", "آئرلینڈ" },
            { "IL", "اسرائیل" },
            { "IM", "آئل آف مین" },
            { "IN", "بھارت" },
            { "IO", "برطانوی بحر ہند کا علاقہ" },
            { "IQ", "عراق" },
            { "IR", "ایران" },
            { "IS", "آئس لینڈ" },
            { "IT", "اٹلی" },
            { "JE", "جرسی" },
            { "JM", "جمائیکا" },
            { "JO", "اردن" },
            { "JP", "جاپان" },
            { "KE", "کینیا" },
            { "KG", "کرغزستان" },
            { "KH", "کمبوڈیا" },
            { "KI", "کریباتی" },
            { "KM", "کوموروس" },
            { "KN", "سینٹ کٹس اور نیویس" },
            { "KP", "شمالی کوریا" },
            { "KR", "جنوبی کوریا" },
            { "KW", "کویت" },
            { "KY", "کیمین آئلینڈز" },
            { "KZ", "قزاخستان" },
            { "LA", "لاؤس" },
            { "LB", "لبنان" },
            { "LC", "سینٹ لوسیا" },
            { "LI", "لیشٹنسٹائن" },
            { "LK", "سری لنکا" },
            { "LR", "لائبیریا" },
            { "LS", "لیسوتھو" },
            { "LT", "لیتھونیا" },
            { "LU", "لکسمبرگ" },
            { "LV", "لٹویا" },
            { "LY", "لیبیا" },
            { "MA", "مراکش" },
            { "MC", "موناکو" },
            { "MD", metaValue_MD },
            { "ME", "مونٹے نیگرو" },
            { "MF", "سینٹ مارٹن" },
            { "MG", "مڈغاسکر" },
            { "MH", "مارشل آئلینڈز" },
            { "MK", "شمالی مقدونیہ" },
            { "ML", "مالی" },
            { "MM", "میانمار (برما)" },
            { "MN", "منگولیا" },
            { "MO", "مکاؤ SAR چین" },
            { "MP", "شمالی ماریانا آئلینڈز" },
            { "MQ", "مارٹینک" },
            { "MR", "موریطانیہ" },
            { "MS", "مونٹسیراٹ" },
            { "MT", "مالٹا" },
            { "MU", "ماریشس" },
            { "MV", "مالدیپ" },
            { "MW", "ملاوی" },
            { "MX", "میکسیکو" },
            { "MY", "ملائشیا" },
            { "MZ", "موزمبیق" },
            { "NA", "نامیبیا" },
            { "NC", "نیو کلیڈونیا" },
            { "NE", "نائجر" },
            { "NF", "نارفوک آئلینڈ" },
            { "NG", "نائجیریا" },
            { "NI", "نکاراگووا" },
            { "NL", "نیدر لینڈز" },
            { "NO", "ناروے" },
            { "NP", "نیپال" },
            { "NR", "نؤرو" },
            { "NU", "نیئو" },
            { "NZ", "نیوزی لینڈ" },
            { "OM", "عمان" },
            { "PA", "پانامہ" },
            { "PE", "پیرو" },
            { "PF", "فرانسیسی پولینیشیا" },
            { "PG", "پاپوآ نیو گنی" },
            { "PH", "فلپائن" },
            { "PK", "پاکستان" },
            { "PL", "پولینڈ" },
            { "PM", "سینٹ پیئر اور میکلیئون" },
            { "PN", "پٹکائرن جزائر" },
            { "PR", "پیورٹو ریکو" },
            { "PS", "فلسطینی خطے" },
            { "PT", "پرتگال" },
            { "PW", "پلاؤ" },
            { "PY", "پیراگوئے" },
            { "QA", "قطر" },
            { "QO", "بیرونی اوشیانیا" },
            { "RE", "ری یونین" },
            { "RO", "رومانیہ" },
            { "RS", "سربیا" },
            { "RU", "روس" },
            { "RW", "روانڈا" },
            { "SA", "سعودی عرب" },
            { "SB", "سولومن آئلینڈز" },
            { "SC", "سشلیز" },
            { "SD", "سوڈان" },
            { "SE", "سویڈن" },
            { "SG", "سنگاپور" },
            { "SH", "سینٹ ہیلینا" },
            { "SI", "سلووینیا" },
            { "SJ", "سوالبرڈ اور جان ماین" },
            { "SK", "سلوواکیہ" },
            { "SL", "سیرالیون" },
            { "SM", "سان مارینو" },
            { "SN", "سینیگل" },
            { "SO", "صومالیہ" },
            { "SR", "سورینام" },
            { "SS", "جنوبی سوڈان" },
            { "ST", "ساؤ ٹومے اور پرنسپے" },
            { "SV", "ال سلواڈور" },
            { "SX", "سنٹ مارٹن" },
            { "SY", "شام" },
            { "SZ", "سواتنی" },
            { "TA", "ٹرسٹن ڈا کیونہا" },
            { "TC", "ٹرکس اور کیکوس جزائر" },
            { "TD", "چاڈ" },
            { "TF", "فرانسیسی جنوبی خطے" },
            { "TG", "ٹوگو" },
            { "TH", "تھائی لینڈ" },
            { "TJ", "تاجکستان" },
            { "TK", "ٹوکیلاؤ" },
            { "TL", "تیمور لیسٹ" },
            { "TM", "ترکمانستان" },
            { "TN", "تونس" },
            { "TO", "ٹونگا" },
            { "TR", "ترکیہ" },
            { "TT", "ترینیداد اور ٹوباگو" },
            { "TV", "ٹووالو" },
            { "TW", "تائیوان" },
            { "TZ", "تنزانیہ" },
            { "UA", "یوکرین" },
            { "UG", "یوگنڈا" },
            { "UM", "امریکہ سے باہر کے چھوٹے جزائز" },
            { "UN", "اقوام متحدہ" },
            { "US", "ریاست ہائے متحدہ امریکہ" },
            { "UY", "یوروگوئے" },
            { "UZ", "ازبکستان" },
            { "VA", "ویٹیکن سٹی" },
            { "VC", "سینٹ ونسنٹ اور گرینیڈائنز" },
            { "VE", "وینزوئیلا" },
            { "VG", "برٹش ورجن آئلینڈز" },
            { "VI", "امریکی ورجن آئلینڈز" },
            { "VN", "ویتنام" },
            { "VU", "وینوآٹو" },
            { "WF", "ویلیز اور فیوٹیونا" },
            { "WS", "ساموآ" },
            { "XA", "بناوٹی لہجے" },
            { "XB", "بناوٹی دو سمتی" },
            { "XK", "کوسووو" },
            { "YE", "یمن" },
            { "YT", "مایوٹ" },
            { "ZA", "جنوبی افریقہ" },
            { "ZM", "زامبیا" },
            { "ZW", "زمبابوے" },
            { "ZZ", "نامعلوم علاقہ" },
            { "aa", "افار" },
            { "ab", "ابقازیان" },
            { "af", "افریقی" },
            { "ak", "اکان" },
            { "am", "امہاری" },
            { "an", "اراگونیز" },
            { "ar", metaValue_ar },
            { "as", "آسامی" },
            { "av", "اواری" },
            { "ay", "ایمارا" },
            { "az", "آذربائیجانی" },
            { "ba", "باشکیر" },
            { "be", "بیلاروسی" },
            { "bg", "بلغاری" },
            { "bi", "بسلاما" },
            { "bm", "بمبارا" },
            { "bn", "بنگلہ" },
            { "bo", metaValue_bo },
            { "br", "بریٹن" },
            { "bs", "بوسنیائی" },
            { "ca", "کیٹالان" },
            { "ce", "چیچن" },
            { "ch", "چیمارو" },
            { "co", "کوراسیکن" },
            { "cs", "چیک" },
            { "cu", "چرچ سلاوک" },
            { "cv", "چوواش" },
            { "cy", "ویلش" },
            { "da", "ڈینش" },
            { "de", "جرمن" },
            { "dv", "ڈیویہی" },
            { "dz", "ژونگکھا" },
            { "ee", "ایو" },
            { "el", metaValue_el },
            { "en", "انگریزی" },
            { "eo", "ایسپرانٹو" },
            { "es", "ہسپانوی" },
            { "et", "اسٹونین" },
            { "eu", "باسکی" },
            { "fa", "فارسی" },
            { "ff", "فولہ" },
            { "fi", "فینیش" },
            { "fj", metaValue_FJ },
            { "fo", "فیروئیز" },
            { "fr", "فرانسیسی" },
            { "fy", "مغربی فریسیئن" },
            { "ga", "آئرش" },
            { "gd", "سکاٹش گیلک" },
            { "gl", "گالیشیائی" },
            { "gn", "گُارانی" },
            { "gu", metaValue_gu },
            { "gv", "مینکس" },
            { "ha", "ہؤسا" },
            { "he", metaValue_he },
            { "hi", "ہندی" },
            { "hr", "کراتی" },
            { "ht", "ہیتی" },
            { "hu", "ہنگیرین" },
            { "hy", metaValue_hy },
            { "hz", "ہریرو" },
            { "ia", "بین لسانیات" },
            { "id", "انڈونیثیائی" },
            { "ie", "غربی" },
            { "ig", "اِگبو" },
            { "ii", "سچوان ای" },
            { "io", "ایڈو" },
            { "is", "آئس لینڈک" },
            { "it", "اطالوی" },
            { "iu", "اینُکٹیٹٹ" },
            { "ja", metaValue_ja },
            { "jv", "جاوی" },
            { "ka", metaValue_ka },
            { "kg", "کانگو" },
            { "ki", "کیکویو" },
            { "kj", "کونیاما" },
            { "kk", "قزاخ" },
            { "kl", "کالاليست" },
            { "km", metaValue_km },
            { "kn", "کنّاڈا" },
            { "ko", metaValue_ko },
            { "kr", "کنوری" },
            { "ks", "کشمیری" },
            { "ku", "کرمانجی" },
            { "kv", "کومی" },
            { "kw", "کورنش" },
            { "ky", "کرغیزی" },
            { "la", metaValue_la },
            { "lb", "لکسمبرگیش" },
            { "lg", "گینڈا" },
            { "li", "لیمبرگش" },
            { "ln", "لِنگَلا" },
            { "lo", metaValue_lo },
            { "lt", "لیتھوینین" },
            { "lu", "لبا-کاتانجا" },
            { "lv", "لیٹوین" },
            { "mg", "ملاگاسی" },
            { "mh", "مارشلیز" },
            { "mi", "ماؤری" },
            { "mk", "مقدونیائی" },
            { "ml", metaValue_ml },
            { "mn", "منگولین" },
            { "mr", "مراٹھی" },
            { "ms", "مالے" },
            { "mt", "مالٹی" },
            { "my", "برمی" },
            { "na", "ناؤرو" },
            { "nb", "نارویجین بوکمل" },
            { "nd", "شمالی دبیل" },
            { "ne", "نیپالی" },
            { "ng", "نڈونگا" },
            { "nl", "ڈچ" },
            { "nn", "نارویجین نینورسک" },
            { "no", "نارویجین" },
            { "nr", "جنوبی نڈیبیلی" },
            { "nv", "نواجو" },
            { "ny", "نیانجا" },
            { "oc", "آکسیٹان" },
            { "om", "اورومو" },
            { "or", metaValue_or },
            { "os", "اوسیٹک" },
            { "pa", "پنجابی" },
            { "pl", "پولش" },
            { "ps", "پشتو" },
            { "pt", "پُرتگالی" },
            { "qu", "کویچوآ" },
            { "rm", "رومانش" },
            { "rn", "رونڈی" },
            { "ro", "رومینین" },
            { "ru", "روسی" },
            { "rw", "کینیاروانڈا" },
            { "sa", "سنسکرت" },
            { "sc", "سردینین" },
            { "sd", "سندھی" },
            { "se", "شمالی سامی" },
            { "sg", "ساںغو" },
            { "sh", "سربو-کروئیشین" },
            { "si", metaValue_si },
            { "sk", "سلوواک" },
            { "sl", "سلووینیائی" },
            { "sm", "ساموآن" },
            { "sn", "شونا" },
            { "so", "صومالی" },
            { "sq", "البانی" },
            { "sr", "سربین" },
            { "ss", "سواتی" },
            { "st", "جنوبی سوتھو" },
            { "su", "سنڈانیز" },
            { "sv", "سویڈش" },
            { "sw", "سواحلی" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "تاجک" },
            { "th", metaValue_th },
            { "ti", "ٹگرینیا" },
            { "tk", "ترکمان" },
            { "tl", "ٹیگا لوگ" },
            { "tn", "سوانا" },
            { "to", "ٹونگن" },
            { "tr", "ترکی" },
            { "ts", "زونگا" },
            { "tt", "تاتار" },
            { "tw", "توی" },
            { "ty", "تاہیتی" },
            { "ug", "یوئگہر" },
            { "uk", "یوکرینیائی" },
            { "ur", "اردو" },
            { "uz", "ازبیک" },
            { "ve", "وینڈا" },
            { "vi", "ویتنامی" },
            { "vo", "وولاپوک" },
            { "wa", "والون" },
            { "wo", "وولوف" },
            { "xh", "ژوسا" },
            { "yi", "یدش" },
            { "yo", "یوروبا" },
            { "za", "ژوانگی" },
            { "zh", "چینی" },
            { "zu", "زولو" },
            { "ace", "اچائینیز" },
            { "ach", "اکولی" },
            { "ada", "ادانگمے" },
            { "ady", "ادیگھے" },
            { "agq", "اغم" },
            { "ain", "اینو" },
            { "ale", "الیوت" },
            { "alt", "جنوبی الٹائی" },
            { "ann", "اوبولو" },
            { "anp", "انگیکا" },
            { "arn", "ماپوچے" },
            { "arp", "اراپاہو" },
            { "ars", "نجدی عربی" },
            { "asa", "آسو" },
            { "ast", "اسٹوریائی" },
            { "atj", "اٹیکامیکو" },
            { "awa", "اوادھی" },
            { "bal", "بلوچی" },
            { "ban", "بالینیز" },
            { "bas", "باسا" },
            { "bem", "بیمبا" },
            { "bez", "بینا" },
            { "bgc", "ہریانوی" },
            { "bgn", "مغربی بلوچی" },
            { "bho", "بھوجپوری" },
            { "bin", "بینی" },
            { "bla", "سکسیکا" },
            { "blo", "عانی" },
            { "brx", "بوڈو" },
            { "bug", "بگینیز" },
            { "byn", "بلین" },
            { "cay", "کایوگا" },
            { "ccp", "چکمہ" },
            { "ceb", "سیبوآنو" },
            { "cgg", "چیگا" },
            { "chk", "چوکیز" },
            { "chm", "ماری" },
            { "cho", "چاکٹاؤ" },
            { "chp", "چپوائن" },
            { "chr", metaValue_chr },
            { "chy", "چینّے" },
            { "ckb", "سینٹرل کردش" },
            { "clc", "چلکوٹن" },
            { "crg", "میچیف" },
            { "crj", "جنوب مشرقی کری" },
            { "crk", "پلینز کری" },
            { "crl", "شمال مشرقی کری" },
            { "crm", "موس کری" },
            { "crr", "کیرولینا الگونکوئن" },
            { "crs", "سیسلوا کریولے فرانسیسی" },
            { "csw", "سوامپی کری" },
            { "dak", "ڈاکوٹا" },
            { "dar", "درگوا" },
            { "dav", "تائتا" },
            { "dgr", "دوگریب" },
            { "dje", "زرما" },
            { "doi", "ڈوگری" },
            { "dsb", "ذیلی سربیائی" },
            { "dua", "دوالا" },
            { "dyo", "جولا فونيا" },
            { "dzg", "دزاگا" },
            { "ebu", "امبو" },
            { "efi", "ایفِک" },
            { "eka", "ایکاجوک" },
            { "ewo", "ایوانڈو" },
            { "fil", "فلیپینو" },
            { "fon", "فون" },
            { "frc", "کاجن فرانسیسی" },
            { "frr", "شمالی فریزئین" },
            { "fur", "فریولیائی" },
            { "gaa", "گا" },
            { "gag", "غاغاوز" },
            { "gan", "gan" },
            { "gez", "گیز" },
            { "gil", "گلبرتیز" },
            { "gor", "گورانٹالو" },
            { "gsw", "سوئس جرمن" },
            { "guz", "گسی" },
            { "gwi", "گوئچ ان" },
            { "hai", "ہائیڈا" },
            { "haw", "ہوائی" },
            { "hax", "جنوبی ہائیڈا" },
            { "hil", "ہالیگینون" },
            { "hmn", "ہمانگ" },
            { "hsb", "اپر سربیائی" },
            { "hup", "ہیوپا" },
            { "hur", "ہالکومیلم" },
            { "iba", "ایبان" },
            { "ibb", "ابی بیو" },
            { "ikt", "مغربی کینیڈین اینُکٹیٹٹ" },
            { "ilo", "ایلوکو" },
            { "inh", "انگوش" },
            { "jbo", "لوجبان" },
            { "jgo", "نگومبا" },
            { "jmc", "ماشیم" },
            { "kab", "قبائلی" },
            { "kac", "کاچن" },
            { "kaj", "جے جو" },
            { "kam", "کامبا" },
            { "kbd", "کبارڈین" },
            { "kcg", "تیاپ" },
            { "kde", "ماکونده" },
            { "kea", "کابويرديانو" },
            { "kfo", "کورو" },
            { "kgp", "کینگینگ" },
            { "kha", "کھاسی" },
            { "khq", "کويرا شيني" },
            { "kkj", "کاکو" },
            { "kln", "کالينجين" },
            { "kmb", "کیمبونڈو" },
            { "koi", "کومی پرمیاک" },
            { "kok", "کونکنی" },
            { "kpe", "کیپیلّے" },
            { "krc", "کراچے بالکر" },
            { "krl", "کیرلین" },
            { "kru", "کوروکھ" },
            { "ksb", "شامبالا" },
            { "ksf", "بافيا" },
            { "ksh", "کولوگنیائی" },
            { "kum", "کومیک" },
            { "kwk", "کیواکوالا" },
            { "kxv", "کووی" },
            { "lad", "لیڈینو" },
            { "lag", "لانگی" },
            { "lez", "لیزگیان" },
            { "lij", "لیگوریائی" },
            { "lil", "للوئیٹ" },
            { "lkt", "لاکوٹا" },
            { "lmo", "لومبارڈ" },
            { "lou", "لوزیانا کریول" },
            { "loz", "لوزی" },
            { "lrc", "شمالی لری" },
            { "lsm", "سامیہ" },
            { "lua", "لیوبا لولوآ" },
            { "lun", "لونڈا" },
            { "luo", "لو" },
            { "lus", "میزو" },
            { "luy", "لویا" },
            { "mad", "مدورسی" },
            { "mag", "مگاہی" },
            { "mai", "میتھیلی" },
            { "mak", "مکاسر" },
            { "mas", "مسائی" },
            { "mdf", "موکشا" },
            { "men", "میندے" },
            { "mer", "میرو" },
            { "mfe", "موریسیین" },
            { "mgh", "ماخاوا-ميتو" },
            { "mgo", "میٹا" },
            { "mic", "مکمیک" },
            { "min", "منانگکباؤ" },
            { "mni", "منی پوری" },
            { "moe", "انو ایمن" },
            { "moh", "موہاک" },
            { "mos", "موسی" },
            { "mua", "منڈانگ" },
            { "mul", "متعدد زبانیں" },
            { "mus", "کریک" },
            { "mwl", "میرانڈیز" },
            { "myv", "ارزیا" },
            { "mzn", "مزندرانی" },
            { "nap", "نیاپولیٹن" },
            { "naq", "ناما" },
            { "nds", "ادنی جرمن" },
            { "new", "نیواری" },
            { "nia", "نیاس" },
            { "niu", "نیویائی" },
            { "nmg", "کوايسو" },
            { "nnh", "نگیمبون" },
            { "nog", "نوگائی" },
            { "nqo", "اینکو" },
            { "nso", "شمالی سوتھو" },
            { "nus", "نویر" },
            { "nyn", "نینکول" },
            { "ojb", "شمال مغربی اوجبوا" },
            { "ojc", "سینٹرل اوجبوا" },
            { "ojs", "اوجی کری" },
            { "ojw", "مغربی اوجبوا" },
            { "oka", "اوکناگن" },
            { "pag", "پنگاسنان" },
            { "pam", "پامپنگا" },
            { "pap", "پاپیامینٹو" },
            { "pau", "پالاون" },
            { "pcm", "نائجیریائی پڈگن" },
            { "pis", "پجن" },
            { "pqm", "مالیسیٹ پاساماکوڈی" },
            { "prg", "پارسی" },
            { "quc", "کيشی" },
            { "raj", "راجستھانی" },
            { "rap", "رپانوی" },
            { "rar", "راروتونگان" },
            { "rhg", "روہنگیا" },
            { "rof", "رومبو" },
            { "rup", "ارومانی" },
            { "rwk", "روا" },
            { "sad", "سنڈاوے" },
            { "sah", "ساکھا" },
            { "saq", "سامبورو" },
            { "sat", "سنتالی" },
            { "sba", "نگامبے" },
            { "sbp", "سانگو" },
            { "scn", "سیسیلین" },
            { "sco", "سکاٹ" },
            { "sdh", "جنوبی کرد" },
            { "seh", "سینا" },
            { "ses", "کويرابورو سينی" },
            { "shi", "تشلحيت" },
            { "shn", "شان" },
            { "slh", "جنوبی لوشوٹسیڈ" },
            { "sma", "جنوبی سامی" },
            { "smj", "لول سامی" },
            { "smn", "اناری سامی" },
            { "sms", "سکولٹ سامی" },
            { "snk", "سوننکے" },
            { "srn", "سرانن ٹونگو" },
            { "ssy", "ساہو" },
            { "str", "سٹریٹس سالِش" },
            { "suk", "سکوما" },
            { "swb", "کوموریائی" },
            { "syr", metaValue_syr },
            { "szl", "سیلیزیائی" },
            { "tce", "جنوبی ٹچون" },
            { "tem", "ٹمنے" },
            { "teo", "تیسو" },
            { "tet", "ٹیٹم" },
            { "tgx", "ٹاگش" },
            { "tht", "ٹاہلٹن" },
            { "tig", "ٹگرے" },
            { "tlh", "کلنگن" },
            { "tli", "ٹلنگٹ" },
            { "tok", "ٹوکی پونا" },
            { "tpi", "ٹوک پِسِن" },
            { "trv", "ٹوروکو" },
            { "ttm", "شمالی ٹچون" },
            { "tum", "ٹمبوکا" },
            { "tvl", "تووالو" },
            { "twq", "تاساواق" },
            { "tyv", "تووینین" },
            { "tzm", "سینٹرل ایٹلس ٹمازائٹ" },
            { "udm", "ادمورت" },
            { "umb", "اومبوندو" },
            { "und", "نامعلوم زبان" },
            { "vai", metaValue_vai },
            { "vec", "وینسی" },
            { "vmw", "ماکوائی" },
            { "vun", "ونجو" },
            { "wae", "والسر" },
            { "wal", "وولایتا" },
            { "war", "وارے" },
            { "wbp", "وارلپیری" },
            { "wuu", "وو چائینیز" },
            { "xal", "کالمیک" },
            { "xnr", "کانگری" },
            { "xog", "سوگا" },
            { "yav", "یانگبین" },
            { "ybb", "یمبا" },
            { "yrl", "نینگاٹو" },
            { "yue", "کینٹونیز" },
            { "zgh", "اسٹینڈرڈ مراقشی تمازیقی" },
            { "zun", "زونی" },
            { "zxx", "کوئی لسانی مواد نہیں" },
            { "zza", "زازا" },
            { "Adlm", "ایڈلم" },
            { "Arab", metaValue_ar },
            { "Aran", "نستعلیق" },
            { "Armn", metaValue_hy },
            { "Beng", "بنگالی" },
            { "Bopo", "بوپوموفو" },
            { "Brai", "بریل" },
            { "Cakm", "چکما" },
            { "Cans", "متحدہ کینیڈین ایبوریجنل سلیبکس" },
            { "Cher", metaValue_chr },
            { "Cyrl", "سیریلک" },
            { "Deva", "دیوناگری" },
            { "Ethi", "ایتھوپیائی" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "گرمکھی" },
            { "Hanb", "ہینب" },
            { "Hang", "ہنگول" },
            { "Hani", "ہان" },
            { "Hans", "آسان" },
            { "Hant", "روایتی" },
            { "Hebr", metaValue_he },
            { "Hira", "ہیراگینا" },
            { "Hrkt", "جاپانی سیلابریز" },
            { "Jamo", "جامو" },
            { "Jpan", metaValue_ja },
            { "Kana", "کٹاکانا" },
            { "Khmr", metaValue_km },
            { "Knda", "کنڑ" },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", "منگولیائی" },
            { "Mtei", "میتی مئیک" },
            { "Mymr", "میانمار" },
            { "Nkoo", "نکو" },
            { "Olck", "اول چکی" },
            { "Orya", metaValue_or },
            { "Rohg", "حنیفی" },
            { "Sinh", metaValue_si },
            { "Sund", "سوڈانی" },
            { "Syrc", metaValue_syr },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "ٹفناگ" },
            { "Thaa", "تھانا" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "یی" },
            { "Zmth", "ریاضی کی علامتیں" },
            { "Zsye", "ایموجی" },
            { "Zsym", "علامات" },
            { "Zxxx", "غیر تحریر شدہ" },
            { "Zyyy", "عام" },
            { "Zzzz", "نامعلوم رسم الخط" },
            { "de_AT", "آسٹریائی جرمن" },
            { "de_CH", "سوئس ہائی جرمن" },
            { "en_AU", "آسٹریلیائی انگریزی" },
            { "en_CA", "کینیڈین انگریزی" },
            { "en_GB", "برطانوی انگریزی" },
            { "en_US", "امریکی انگریزی" },
            { "es_ES", "یورپی ہسپانوی" },
            { "es_MX", "میکسیکن ہسپانوی" },
            { "fa_AF", "دری" },
            { "fr_CA", "کینیڈین فرانسیسی" },
            { "fr_CH", "سوئس فرینچ" },
            { "nl_BE", "فلیمِش" },
            { "pt_BR", "برازیلی پرتگالی" },
            { "pt_PT", "یورپی پرتگالی" },
            { "ro_MD", metaValue_MD },
            { "sw_CD", "کانگو سواحلی" },
            { "ar_001", "ماڈرن اسٹینڈرڈ عربی" },
            { "es_419", "لاطینی امریکی ہسپانوی" },
            { "key.ca", "کیلنڈر" },
            { "key.cf", "کرنسی فارمیٹ" },
            { "key.co", "چھٹائی کی ترتیب" },
            { "key.cu", "کرنسی" },
            { "key.em", "ایموجی پریزینٹیشن" },
            { "key.hc", "گھنٹہ سائیکل (12 بنام 24)" },
            { "key.lb", "لائن بریک انداز" },
            { "key.lw", "الفاظ کے اندر لائن بریکس" },
            { "key.ms", "پیمائش کا نظام" },
            { "key.nu", "اعداد" },
            { "key.ss", "مخففات کے بعد سنٹینس بریک" },
            { "key.tz", "منطقۂ وقت" },
            { "key.va", "مقام کا متغیرہ" },
            { "nds_NL", "ادنی سیکسن" },
            { "az_Arab", "آزربائیجانی (عربی)" },
            { "zh_Hans", "چینی (آسان کردہ)" },
            { "zh_Hant", "روایتی چینی" },
            { "type.ca.roc", "منگوو کیلنڈر" },
            { "type.co.eor", "یورپی ترتیبی قوانین" },
            { "type.hc.h11", "12 گھنٹے کا نظام (0–11)" },
            { "type.hc.h12", "12 گھنٹے کا نظام (1–12)" },
            { "type.hc.h23", "24 گھنٹے کا نظام (0–23)" },
            { "type.hc.h24", "24 گھنٹے کا نظام (1–24)" },
            { "type.m0.bgn", "US BGN ٹرانسلٹریشن" },
            { "type.nu.arab", "عربی ہندی ہندسے" },
            { "type.nu.armn", "آرمینیائی اعداد" },
            { "type.nu.beng", "بنگالی ہندسے" },
            { "type.nu.cakm", "چکما اعداد" },
            { "type.nu.deva", "دیوناگری ہندسے" },
            { "type.nu.ethi", "ایتھوپیائی اعداد" },
            { "type.nu.geor", "جارجیائی اعداد" },
            { "type.nu.grek", "یونانی اعداد" },
            { "type.nu.gujr", "گجراتی ہندسے" },
            { "type.nu.guru", "گرمکھی ہندسے" },
            { "type.nu.hans", "آسان چینی اعداد" },
            { "type.nu.hant", "روایتی چینی اعداد" },
            { "type.nu.hebr", "عبرانی اعداد" },
            { "type.nu.java", "جاویانی اعداد" },
            { "type.nu.jpan", "جاپانی اعداد" },
            { "type.nu.khmr", "خمیر ہندسے" },
            { "type.nu.knda", "کنڑ ہندسے" },
            { "type.nu.laoo", "لاؤ ہندسے" },
            { "type.nu.latn", "مغربی ہندسے" },
            { "type.nu.mlym", "ملیالم ہندسے" },
            { "type.nu.mong", "منگولیائی ہندسے" },
            { "type.nu.mtei", "میٹی مئیک اعداد" },
            { "type.nu.mymr", "میانمار کے ہندسے" },
            { "type.nu.olck", "اول چیکی اعداد" },
            { "type.nu.orya", "اڑیہ ہندسے" },
            { "type.nu.taml", "روایتی تمل اعداد" },
            { "type.nu.telu", "تیلگو ہندسے" },
            { "type.nu.thai", "تھائی ہندسے" },
            { "type.nu.tibt", "تبتی اعداد" },
            { "type.nu.vaii", "وائی ہندسے" },
            { "type.ca.dangi", "ڈانگی کیلنڈر" },
            { "type.co.ducet", "ڈیفالٹ یونی کوڈ چھانٹی کی ترتیب" },
            { "type.lb.loose", "ڈھیلا لائن بریک انداز" },
            { "type.nu.roman", "رومن اعداد" },
            { "type.ca.coptic", "کاپٹک کیلنڈر" },
            { "type.ca.hebrew", "عبرانی کیلنڈر" },
            { "type.ca.indian", "بھارتی قومی کیلنڈر" },
            { "type.co.compat", "سابقہ چھٹائی کی ترتیب، مطابقت کیلئے" },
            { "type.co.pinyin", "پن ین کی چھٹنی کی ترتیب" },
            { "type.co.search", "عمومی تلاش" },
            { "type.co.stroke", "سٹروک کی چھٹنی کی ترتیب" },
            { "type.co.unihan", "اساسی-سٹروک کی چھٹنی کی ترتیب" },
            { "type.d0.fwidth", "پورا عرض" },
            { "type.d0.hwidth", "نصف عرض" },
            { "type.lb.normal", "عمومی لائن بریک انداز" },
            { "type.lb.strict", "سخت لائن بریک انداز" },
            { "type.m0.ungegn", "UN GEGN ٹرانسلٹریشن" },
            { "type.ms.metric", "میٹرک نظام" },
            { "type.nu.native", "اصل ہندسے" },
            { "type.ca.chinese", "چینی کیلنڈر" },
            { "type.ca.islamic", "ہجری کیلنڈر" },
            { "type.ca.iso8601", "ISO-8601 کیلنڈر" },
            { "type.ca.persian", "فارسی کیلنڈر" },
            { "type.cf.account", "اکاؤنٹنگ کرنسی فارمیٹ" },
            { "type.d0.npinyin", "عددی" },
            { "type.nu.arabext", "توسیع شدہ عربی ہندی ہندسے" },
            { "type.nu.armnlow", "آرمینیائی زیریں اعداد" },
            { "type.nu.finance", "مالیاتی ہندسے" },
            { "type.nu.greklow", "یونانی زیریں اعداد" },
            { "type.nu.hanidec", "چینی اعشاری اعداد" },
            { "type.nu.hansfin", "آسان چینی مالی اعداد" },
            { "type.nu.hantfin", "روایتی چینی مالی اعداد" },
            { "type.nu.jpanfin", "جاپانی مالی اعداد" },
            { "type.nu.tamldec", "تمل اعداد" },
            { "type.ca.buddhist", "بودھ کلینڈر" },
            { "type.ca.ethiopic", "ایتھوپیائی کیلنڈر" },
            { "type.ca.japanese", "جاپانی کیلنڈر" },
            { "type.cf.standard", "اسٹینڈرڈ کرنسی فارمیٹ" },
            { "type.co.phonetic", "صوتی چھٹائی کی ترتیب" },
            { "type.co.searchjl", "Hangul Initial Consonant کے لحاظ سے تلاش کریں" },
            { "type.co.standard", "معیاری چھانٹی کی ترتیب" },
            { "type.ms.uksystem", "پیمائش کا امپیریل نظام" },
            { "type.ms.ussystem", "پیمائش کا امریکی نظام" },
            { "type.nu.fullwide", "پورے عرض والے ہندسے" },
            { "type.nu.romanlow", "رومن زیریں اعداد" },
            { "type.ca.gregorian", "گریگورین کیلنڈر" },
            { "type.co.phonebook", "فون بک کی چھٹنی کی ترتیب" },
            { "type.co.dictionary", "لغت کی چھٹنی کی ترتیب" },
            { "type.co.traditional", "روایتی چھٹنی کی ترتیب" },
            { "type.nu.traditional", "روایتی اعداد" },
            { "type.ca.islamic-tbla", "ہجری کیلنڈر (لوحی، ایسٹرونومیکل ایپوک)" },
            { "type.ca.islamic-civil", "اسلامی شہری کیلنڈر (ٹیبیولر، مدنی دور)" },
            { "ListCompositionPattern", "{0}،{1}" },
            { "type.ca.islamic-umalqura", "ہجری کیلنڈر (ام القریٰ)" },
            { "type.ca.ethiopic-amete-alem", "ایتھوپک امیٹ الیم کیلنڈر" },
        };
        return data;
    }
}
