/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_gu = "gudżarati";
        final String metaValue_kn = "kannada";
        final String metaValue_ml = "malajalam";
        final String metaValue_nqo = "n’ko";
        final String metaValue_or = "orija";
        final String metaValue_phn = "fenicki";
        final String metaValue_te = "telugu";
        final String metaValue_ccp = "czakma";
        final Object[][] data = new Object[][] {
            { "001", "świat" },
            { "002", "Afryka" },
            { "003", "Ameryka Północna" },
            { "005", "Ameryka Południowa" },
            { "009", "Oceania" },
            { "011", "Afryka Zachodnia" },
            { "013", "Ameryka Środkowa" },
            { "014", "Afryka Wschodnia" },
            { "015", "Afryka Północna" },
            { "017", "Afryka Środkowa" },
            { "018", "Afryka Południowa" },
            { "019", "Ameryka" },
            { "021", "Ameryka Północna (USA, Kanada)" },
            { "029", "Karaiby" },
            { "030", "Azja Wschodnia" },
            { "034", "Azja Południowa" },
            { "035", "Azja Południowo-Wschodnia" },
            { "039", "Europa Południowa" },
            { "053", "Australazja" },
            { "054", "Melanezja" },
            { "057", "Region Mikronezji" },
            { "061", "Polinezja" },
            { "142", "Azja" },
            { "143", "Azja Środkowa" },
            { "145", "Azja Zachodnia" },
            { "150", "Europa" },
            { "151", "Europa Wschodnia" },
            { "154", "Europa Północna" },
            { "155", "Europa Zachodnia" },
            { "202", "Afryka Subsaharyjska" },
            { "419", "Ameryka Łacińska" },
            { "AC", "Wyspa Wniebowstąpienia" },
            { "AD", "Andora" },
            { "AE", "Zjednoczone Emiraty Arabskie" },
            { "AF", "Afganistan" },
            { "AG", "Antigua i Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarktyda" },
            { "AR", "Argentyna" },
            { "AS", "Samoa Amerykańskie" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Wyspy Alandzkie" },
            { "AZ", "Azerbejdżan" },
            { "BA", "Bośnia i Hercegowina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesz" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bułgaria" },
            { "BH", "Bahrajn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barthélemy" },
            { "BM", "Bermudy" },
            { "BN", "Brunei" },
            { "BO", "Boliwia" },
            { "BQ", "Niderlandy Karaibskie" },
            { "BR", "Brazylia" },
            { "BS", "Bahamy" },
            { "BT", "Bhutan" },
            { "BV", "Wyspa Bouveta" },
            { "BW", "Botswana" },
            { "BY", "Białoruś" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Wyspy Kokosowe" },
            { "CD", "Demokratyczna Republika Konga" },
            { "CF", "Republika Środkowoafrykańska" },
            { "CG", "Kongo" },
            { "CH", "Szwajcaria" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Wyspy Cooka" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "Chiny" },
            { "CO", "Kolumbia" },
            { "CP", "Wyspa Clippertona" },
            { "CQ", "Sark" },
            { "CR", "Kostaryka" },
            { "CU", "Kuba" },
            { "CV", "Republika Zielonego Przylądka" },
            { "CW", "Curaçao" },
            { "CX", "Wyspa Bożego Narodzenia" },
            { "CY", "Cypr" },
            { "CZ", "Czechy" },
            { "DE", "Niemcy" },
            { "DG", "Diego Garcia" },
            { "DJ", "Dżibuti" },
            { "DK", "Dania" },
            { "DM", "Dominika" },
            { "DO", "Dominikana" },
            { "DZ", "Algieria" },
            { "EA", "Ceuta i Melilla" },
            { "EC", "Ekwador" },
            { "EE", "Estonia" },
            { "EG", "Egipt" },
            { "EH", "Sahara Zachodnia" },
            { "ER", "Erytrea" },
            { "ES", "Hiszpania" },
            { "ET", "Etiopia" },
            { "EU", "Unia Europejska" },
            { "EZ", "strefa euro" },
            { "FI", "Finlandia" },
            { "FJ", "Fidżi" },
            { "FK", "Falklandy" },
            { "FM", "Mikronezja" },
            { "FO", "Wyspy Owcze" },
            { "FR", "Francja" },
            { "GA", "Gabon" },
            { "GB", "Wielka Brytania" },
            { "GD", "Grenada" },
            { "GE", "Gruzja" },
            { "GF", "Gujana Francuska" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Grenlandia" },
            { "GM", "Gambia" },
            { "GN", "Gwinea" },
            { "GP", "Gwadelupa" },
            { "GQ", "Gwinea Równikowa" },
            { "GR", "Grecja" },
            { "GS", "Georgia Południowa i Sandwich Południowy" },
            { "GT", "Gwatemala" },
            { "GU", "Guam" },
            { "GW", "Gwinea Bissau" },
            { "GY", "Gujana" },
            { "HK", "SRA Hongkong (Chiny)" },
            { "HM", "Wyspy Heard i McDonalda" },
            { "HN", "Honduras" },
            { "HR", "Chorwacja" },
            { "HT", "Haiti" },
            { "HU", "Węgry" },
            { "IC", "Wyspy Kanaryjskie" },
            { "ID", "Indonezja" },
            { "IE", "Irlandia" },
            { "IL", "Izrael" },
            { "IM", "Wyspa Man" },
            { "IN", "Indie" },
            { "IO", "Brytyjskie Terytorium Oceanu Indyjskiego" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islandia" },
            { "IT", "Włochy" },
            { "JE", "Jersey" },
            { "JM", "Jamajka" },
            { "JO", "Jordania" },
            { "JP", "Japonia" },
            { "KE", "Kenia" },
            { "KG", "Kirgistan" },
            { "KH", "Kambodża" },
            { "KI", "Kiribati" },
            { "KM", "Komory" },
            { "KN", "Saint Kitts i Nevis" },
            { "KP", "Korea Północna" },
            { "KR", "Korea Południowa" },
            { "KW", "Kuwejt" },
            { "KY", "Kajmany" },
            { "KZ", "Kazachstan" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litwa" },
            { "LU", "Luksemburg" },
            { "LV", "Łotwa" },
            { "LY", "Libia" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Mołdawia" },
            { "ME", "Czarnogóra" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Wyspy Marshalla" },
            { "MK", "Macedonia Północna" },
            { "ML", "Mali" },
            { "MM", "Mjanma (Birma)" },
            { "MN", "Mongolia" },
            { "MO", "SRA Makau (Chiny)" },
            { "MP", "Mariany Północne" },
            { "MQ", "Martynika" },
            { "MR", "Mauretania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Malediwy" },
            { "MW", "Malawi" },
            { "MX", "Meksyk" },
            { "MY", "Malezja" },
            { "MZ", "Mozambik" },
            { "NA", "Namibia" },
            { "NC", "Nowa Kaledonia" },
            { "NE", "Niger" },
            { "NF", "Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nikaragua" },
            { "NL", "Holandia" },
            { "NO", "Norwegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nowa Zelandia" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polinezja Francuska" },
            { "PG", "Papua-Nowa Gwinea" },
            { "PH", "Filipiny" },
            { "PK", "Pakistan" },
            { "PL", "Polska" },
            { "PM", "Saint-Pierre i Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Portoryko" },
            { "PS", "Terytoria Palestyńskie" },
            { "PT", "Portugalia" },
            { "PW", "Palau" },
            { "PY", "Paragwaj" },
            { "QA", "Katar" },
            { "QO", "Oceania — wyspy dalekie" },
            { "RE", "Reunion" },
            { "RO", "Rumunia" },
            { "RS", "Serbia" },
            { "RU", "Rosja" },
            { "RW", "Rwanda" },
            { "SA", "Arabia Saudyjska" },
            { "SB", "Wyspy Salomona" },
            { "SC", "Seszele" },
            { "SD", "Sudan" },
            { "SE", "Szwecja" },
            { "SG", "Singapur" },
            { "SH", "Wyspa Świętej Heleny" },
            { "SI", "Słowenia" },
            { "SJ", "Svalbard i Jan Mayen" },
            { "SK", "Słowacja" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Sudan Południowy" },
            { "ST", "Wyspy Świętego Tomasza i Książęca" },
            { "SV", "Salwador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks i Caicos" },
            { "TD", "Czad" },
            { "TF", "Francuskie Terytoria Południowe i Antarktyczne" },
            { "TG", "Togo" },
            { "TH", "Tajlandia" },
            { "TJ", "Tadżykistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor Wschodni" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunezja" },
            { "TO", "Tonga" },
            { "TR", "Turcja" },
            { "TT", "Trynidad i Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tajwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Dalekie Wyspy Mniejsze Stanów Zjednoczonych" },
            { "UN", "Organizacja Narodów Zjednoczonych" },
            { "US", "Stany Zjednoczone" },
            { "UY", "Urugwaj" },
            { "UZ", "Uzbekistan" },
            { "VA", "Watykan" },
            { "VC", "Saint Vincent i Grenadyny" },
            { "VE", "Wenezuela" },
            { "VG", "Brytyjskie Wyspy Dziewicze" },
            { "VI", "Wyspy Dziewicze Stanów Zjednoczonych" },
            { "VN", "Wietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis i Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudoakcenty" },
            { "XB", "Pseudodwukierunkowe" },
            { "XK", "Kosowo" },
            { "YE", "Jemen" },
            { "YT", "Majotta" },
            { "ZA", "Republika Południowej Afryki" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Nieznany region" },
            { "aa", "afar" },
            { "ab", "abchaski" },
            { "ae", "awestyjski" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amharski" },
            { "an", "aragoński" },
            { "ar", "arabski" },
            { "as", "asamski" },
            { "av", "awarski" },
            { "ay", "ajmara" },
            { "az", "azerbejdżański" },
            { "ba", "baszkirski" },
            { "be", "białoruski" },
            { "bg", "bułgarski" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengalski" },
            { "bo", "tybetański" },
            { "br", "bretoński" },
            { "bs", "bośniacki" },
            { "ca", "kataloński" },
            { "ce", "czeczeński" },
            { "ch", "czamorro" },
            { "co", "korsykański" },
            { "cr", "kri" },
            { "cs", "czeski" },
            { "cu", "cerkiewnosłowiański" },
            { "cv", "czuwaski" },
            { "cy", "walijski" },
            { "da", "duński" },
            { "de", "niemiecki" },
            { "dv", "malediwski" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", "grecki" },
            { "en", "angielski" },
            { "eo", "esperanto" },
            { "es", "hiszpański" },
            { "et", "estoński" },
            { "eu", "baskijski" },
            { "fa", "perski" },
            { "ff", "fulani" },
            { "fi", "fiński" },
            { "fj", "fidżijski" },
            { "fo", "farerski" },
            { "fr", "francuski" },
            { "fy", "zachodniofryzyjski" },
            { "ga", "irlandzki" },
            { "gd", "szkocki gaelicki" },
            { "gl", "galicyjski" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", "hebrajski" },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "chorwacki" },
            { "ht", "kreolski haitański" },
            { "hu", "węgierski" },
            { "hy", "ormiański" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonezyjski" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "syczuański" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "islandzki" },
            { "it", "włoski" },
            { "iu", "inuktitut" },
            { "ja", "japoński" },
            { "jv", "jawajski" },
            { "ka", "gruziński" },
            { "kg", "kongo" },
            { "ki", "kikuju" },
            { "kj", "kwanyama" },
            { "kk", "kazachski" },
            { "kl", "grenlandzki" },
            { "km", "khmerski" },
            { "kn", metaValue_kn },
            { "ko", "koreański" },
            { "kr", "kanuri" },
            { "ks", "kaszmirski" },
            { "ku", "kurmandżi" },
            { "kv", "komi" },
            { "kw", "kornijski" },
            { "ky", "kirgiski" },
            { "la", "łaciński" },
            { "lb", "luksemburski" },
            { "lg", "ganda" },
            { "li", "limburski" },
            { "ln", "lingala" },
            { "lo", "laotański" },
            { "lt", "litewski" },
            { "lu", "luba-katanga" },
            { "lv", "łotewski" },
            { "mg", "malgaski" },
            { "mh", "marszalski" },
            { "mi", "maoryjski" },
            { "mk", "macedoński" },
            { "ml", metaValue_ml },
            { "mn", "mongolski" },
            { "mr", "marathi" },
            { "ms", "malajski" },
            { "mt", "maltański" },
            { "my", "birmański" },
            { "na", "nauruański" },
            { "nb", "norweski (bokmål)" },
            { "nd", "ndebele północny" },
            { "ne", "nepalski" },
            { "ng", "ndonga" },
            { "nl", "niderlandzki" },
            { "nn", "norweski (nynorsk)" },
            { "no", "norweski" },
            { "nr", "ndebele południowy" },
            { "nv", "nawaho" },
            { "ny", "njandża" },
            { "oc", "oksytański" },
            { "oj", "odżibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "osetyjski" },
            { "pa", "pendżabski" },
            { "pi", "palijski" },
            { "pl", "polski" },
            { "ps", "paszto" },
            { "pt", "portugalski" },
            { "qu", "keczua" },
            { "rm", "retoromański" },
            { "rn", "rundi" },
            { "ro", "rumuński" },
            { "ru", "rosyjski" },
            { "rw", "kinya-ruanda" },
            { "sa", "sanskryt" },
            { "sc", "sardyński" },
            { "sd", "sindhi" },
            { "se", "północnolapoński" },
            { "sg", "sango" },
            { "sh", "serbsko-chorwacki" },
            { "si", "syngaleski" },
            { "sk", "słowacki" },
            { "sl", "słoweński" },
            { "sm", "samoański" },
            { "sn", "shona" },
            { "so", "somalijski" },
            { "sq", "albański" },
            { "sr", "serbski" },
            { "ss", "suazi" },
            { "st", "sotho południowy" },
            { "su", "sundajski" },
            { "sv", "szwedzki" },
            { "sw", "suahili" },
            { "ta", "tamilski" },
            { "te", metaValue_te },
            { "tg", "tadżycki" },
            { "th", "tajski" },
            { "ti", "tigrinia" },
            { "tk", "turkmeński" },
            { "tl", "tagalski" },
            { "tn", "setswana" },
            { "to", "tonga" },
            { "tr", "turecki" },
            { "ts", "tsonga" },
            { "tt", "tatarski" },
            { "tw", "twi" },
            { "ty", "tahitański" },
            { "ug", "ujgurski" },
            { "uk", "ukraiński" },
            { "ur", "urdu" },
            { "uz", "uzbecki" },
            { "ve", "venda" },
            { "vi", "wietnamski" },
            { "vo", "wolapik" },
            { "wa", "waloński" },
            { "wo", "wolof" },
            { "xh", "khosa" },
            { "yi", "jidysz" },
            { "yo", "joruba" },
            { "za", "czuang" },
            { "zh", "chiński" },
            { "zu", "zulu" },
            { "ace", "aceh" },
            { "ach", "aczoli" },
            { "ada", "adangme" },
            { "ady", "adygejski" },
            { "aeb", "tunezyjski arabski" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ajnu" },
            { "akk", "akadyjski" },
            { "akz", "alabama" },
            { "ale", "aleucki" },
            { "aln", "albański gegijski" },
            { "alt", "południowoałtajski" },
            { "ang", "staroangielski" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aramejski" },
            { "arn", "mapudungun" },
            { "aro", "araona" },
            { "arp", "arapaho" },
            { "arq", "algierski arabski" },
            { "ars", "arabski nadżdyjski" },
            { "arw", "arawak" },
            { "ary", "marokański arabski" },
            { "arz", "egipski arabski" },
            { "asa", "asu" },
            { "ase", "amerykański język migowy" },
            { "ast", "asturyjski" },
            { "atj", "atikamekw" },
            { "avk", "kotava" },
            { "awa", "awadhi" },
            { "bal", "beludżi" },
            { "ban", "balijski" },
            { "bar", "bawarski" },
            { "bas", "basaa" },
            { "bax", "bamum" },
            { "bbc", "batak toba" },
            { "bbj", "ghomala" },
            { "bej", "bedża" },
            { "bem", "bemba" },
            { "bew", "betawi" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bfq", "badaga" },
            { "bgc", "haryanvi" },
            { "bgn", "beludżi północny" },
            { "bho", "bhodżpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bjn", "banjar" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "bpy", "bisznuprija-manipuri" },
            { "bqi", "bachtiarski" },
            { "bra", "bradź" },
            { "brh", "brahui" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "buriacki" },
            { "bug", "bugijski" },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "kaddo" },
            { "car", "karaibski" },
            { "cay", "kajuga" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuański" },
            { "cgg", "chiga" },
            { "chb", "czibcza" },
            { "chg", "czagatajski" },
            { "chk", "chuuk" },
            { "chm", "maryjski" },
            { "chn", "żargon czinucki" },
            { "cho", "czoktawski" },
            { "chp", "czipewiański" },
            { "chr", "czirokeski" },
            { "chy", "czejeński" },
            { "ckb", "sorani" },
            { "clc", "chilcotin" },
            { "cop", "koptyjski" },
            { "cps", "capiznon" },
            { "crg", "miszif" },
            { "crh", "krymskotatarski" },
            { "crj", "kri południowo-wschodni" },
            { "crk", "kri równinny" },
            { "crl", "kri północno-wschodni" },
            { "crm", "kri Moose" },
            { "crr", "algonkiński (Karolina Północna)" },
            { "crs", "kreolski seszelski" },
            { "csb", "kaszubski" },
            { "csw", "kri bagienny" },
            { "dak", "dakota" },
            { "dar", "dargwijski" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "dżerma" },
            { "doi", "dogri" },
            { "dsb", "dolnołużycki" },
            { "dtp", "dusun centralny" },
            { "dua", "duala" },
            { "dum", "średniowieczny niderlandzki" },
            { "dyo", "diola" },
            { "dyu", "diula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egl", "emilijski" },
            { "egy", "staroegipski" },
            { "eka", "ekajuk" },
            { "elx", "elamicki" },
            { "enm", "średnioangielski" },
            { "esu", "yupik środkowosyberyjski" },
            { "ewo", "ewondo" },
            { "ext", "estremadurski" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipiński" },
            { "fit", "meänkieli" },
            { "fon", "fon" },
            { "frc", "cajuński" },
            { "frm", "średniofrancuski" },
            { "fro", "starofrancuski" },
            { "frp", "franko-prowansalski" },
            { "frr", "północnofryzyjski" },
            { "frs", "wschodniofryzyjski" },
            { "fur", "friulski" },
            { "gaa", "ga" },
            { "gag", "gagauski" },
            { "gan", "gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gbz", "zaratusztriański dari" },
            { "gez", "gyyz" },
            { "gil", "gilbertański" },
            { "glk", "giliański" },
            { "gmh", "średnio-wysoko-niemiecki" },
            { "goh", "staro-wysoko-niemiecki" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", "gocki" },
            { "grb", "grebo" },
            { "grc", "starogrecki" },
            { "gsw", "szwajcarski niemiecki" },
            { "guc", "wayúu" },
            { "gur", "frafra" },
            { "guz", "gusii" },
            { "gwi", "gwichʼin" },
            { "hai", "haida" },
            { "hak", "hakka" },
            { "haw", "hawajski" },
            { "hax", "haida południowy" },
            { "hif", "hindi fidżyjskie" },
            { "hil", "hiligaynon" },
            { "hit", "hetycki" },
            { "hmn", "hmong" },
            { "hsb", "górnołużycki" },
            { "hsn", "xiang" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut zachodniokanadyjski" },
            { "ilo", "ilokano" },
            { "inh", "inguski" },
            { "izh", "ingryjski" },
            { "jam", "jamajski" },
            { "jbo", "lojban" },
            { "jgo", "ngombe" },
            { "jmc", "machame" },
            { "jpr", "judeo-perski" },
            { "jrb", "judeoarabski" },
            { "jut", "jutlandzki" },
            { "kaa", "karakałpacki" },
            { "kab", "kabylski" },
            { "kac", "kaczin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardyjski" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kreolski Wysp Zielonego Przylądka" },
            { "ken", "kenyang" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "kho", "chotański" },
            { "khq", "koyra chiini" },
            { "khw", "khowar" },
            { "kiu", "kirmandżki" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permiacki" },
            { "kok", "konkani" },
            { "kos", "kosrae" },
            { "kpe", "kpelle" },
            { "krc", "karaczajsko-bałkarski" },
            { "kri", "krio" },
            { "krj", "kinaraya" },
            { "krl", "karelski" },
            { "kru", "kurukh" },
            { "ksb", "sambala" },
            { "ksf", "bafia" },
            { "ksh", "gwara kolońska" },
            { "kum", "kumycki" },
            { "kut", "kutenai" },
            { "kwk", "kwakiutl" },
            { "kxv", "kuvi" },
            { "lad", "ladyński" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezgijski" },
            { "lfn", "Lingua Franca Nova" },
            { "lij", "liguryjski" },
            { "lil", "lillooet" },
            { "liv", "liwski" },
            { "lkt", "lakota" },
            { "lmo", "lombardzki" },
            { "lol", "mongo" },
            { "lou", "kreolski luizjański" },
            { "loz", "lozi" },
            { "lrc", "luryjski północny" },
            { "lsm", "saamia" },
            { "ltg", "łatgalski" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "lus", "mizo" },
            { "luy", "luhya" },
            { "lzh", "chiński klasyczny" },
            { "lzz", "lazyjski" },
            { "mad", "madurski" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mandingo" },
            { "mas", "masajski" },
            { "mde", "maba" },
            { "mdf", "moksza" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "kreolski Mauritiusa" },
            { "mga", "średnioirlandzki" },
            { "mgh", "makua-meetto" },
            { "mgo", "meta" },
            { "mic", "mikmak" },
            { "min", "minangkabu" },
            { "mnc", "manchu" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mrj", "zachodniomaryjski" },
            { "mua", "mundang" },
            { "mul", "wiele języków" },
            { "mus", "krik" },
            { "mwl", "mirandyjski" },
            { "mwr", "marwari" },
            { "mwv", "mentawai" },
            { "mye", "myene" },
            { "myv", "erzja" },
            { "mzn", "mazanderański" },
            { "nan", "minnański" },
            { "nap", "neapolitański" },
            { "naq", "nama" },
            { "nds", "dolnoniemiecki" },
            { "new", "newarski" },
            { "nia", "nias" },
            { "niu", "niue" },
            { "njo", "ao" },
            { "nmg", "ngumba" },
            { "nnh", "ngiemboon" },
            { "nog", "nogajski" },
            { "non", "staronordyjski" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "sotho północny" },
            { "nus", "nuer" },
            { "nwc", "newarski klasyczny" },
            { "nym", "niamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzema" },
            { "ojb", "odżibwe północno-zachodni" },
            { "ojc", "odżibwe centralny" },
            { "ojs", "odżi-kri" },
            { "ojw", "odżibwe zachodni" },
            { "oka", "okanagan" },
            { "osa", "osage" },
            { "ota", "osmańsko-turecki" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampango" },
            { "pap", "papiamento" },
            { "pau", "palau" },
            { "pcd", "pikardyjski" },
            { "pcm", "pidżyn nigeryjski" },
            { "pdc", "pensylwański" },
            { "pdt", "plautdietsch" },
            { "peo", "staroperski" },
            { "pfl", "palatynacki" },
            { "phn", metaValue_phn },
            { "pis", "pijin" },
            { "pms", "piemoncki" },
            { "pnt", "pontyjski" },
            { "pon", "ponpejski" },
            { "pqm", "malecite-passamaquoddy" },
            { "prg", "pruski" },
            { "pro", "staroprowansalski" },
            { "quc", "kicze" },
            { "qug", "keczua górski (Chimborazo)" },
            { "raj", "radźasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotonga" },
            { "rgn", "romagnol" },
            { "rhg", "rohingya" },
            { "rif", "tarifit" },
            { "rof", "rombo" },
            { "rom", "cygański" },
            { "rtm", "rotumański" },
            { "rue", "rusiński" },
            { "rug", "roviana" },
            { "rup", "arumuński" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "jakucki" },
            { "sam", "samarytański aramejski" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "saz", "saurasztryjski" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sycylijski" },
            { "sco", "scots" },
            { "sdc", "sassarski" },
            { "sdh", "południowokurdyjski" },
            { "see", "seneka" },
            { "seh", "sena" },
            { "sei", "seri" },
            { "sel", "selkupski" },
            { "ses", "koyraboro senni" },
            { "sga", "staroirlandzki" },
            { "sgs", "żmudzki" },
            { "shi", "tashelhiyt" },
            { "shn", "szan" },
            { "shu", "arabski (Czad)" },
            { "sid", "sidamo" },
            { "slh", "lushootseed południowy" },
            { "sli", "dolnośląski" },
            { "sly", "selayar" },
            { "sma", "południowolapoński" },
            { "smj", "lule" },
            { "smn", "inari" },
            { "sms", "skolt" },
            { "snk", "soninke" },
            { "sog", "sogdyjski" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", "saho" },
            { "stq", "fryzyjski saterlandzki" },
            { "str", "salisz" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeryjski" },
            { "swb", "komoryjski" },
            { "syc", "syriacki" },
            { "syr", "syryjski" },
            { "szl", "śląski" },
            { "tce", "tutchone południowy" },
            { "tcy", "tulu" },
            { "tem", "temne" },
            { "teo", "ateso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigre" },
            { "tiv", "tiw" },
            { "tkl", "tokelau" },
            { "tkr", "cachurski" },
            { "tlh", "klingoński" },
            { "tli", "tlingit" },
            { "tly", "tałyski" },
            { "tmh", "tamaszek" },
            { "tog", "tonga (Niasa)" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "tru", "turoyo" },
            { "trv", "taroko" },
            { "tsd", "cakoński" },
            { "tsi", "tsimshian" },
            { "ttm", "tutchone północny" },
            { "ttt", "tacki" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawaq" },
            { "tyv", "tuwiński" },
            { "tzm", "tamazight (Atlas Środkowy)" },
            { "udm", "udmurcki" },
            { "uga", "ugarycki" },
            { "umb", "umbundu" },
            { "und", "nieznany język" },
            { "vai", "wai" },
            { "vec", "wenecki" },
            { "vep", "wepski" },
            { "vls", "zachodnioflamandzki" },
            { "vmf", "meński frankoński" },
            { "vmw", "makua" },
            { "vot", "wotiacki" },
            { "vro", "võro" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolayta" },
            { "war", "waraj" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "wu" },
            { "xal", "kałmucki" },
            { "xmf", "megrelski" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "japski" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "kantoński" },
            { "zap", "zapotecki" },
            { "zbl", "bliss" },
            { "zea", "zelandzki" },
            { "zen", "zenaga" },
            { "zgh", "standardowy marokański tamazight" },
            { "zun", "zuni" },
            { "zxx", "brak treści o charakterze językowym" },
            { "zza", "zazaki" },
            { "Adlm", "adlam" },
            { "Arab", "arabskie" },
            { "Aran", "nastaliq" },
            { "Armi", "armi" },
            { "Armn", "ormiańskie" },
            { "Avst", "awestyjskie" },
            { "Bali", "balijskie" },
            { "Bamu", "bamun" },
            { "Batk", "batak" },
            { "Beng", "bengalskie" },
            { "Blis", "symbole Blissa" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "Braille’a" },
            { "Bugi", "bugińskie" },
            { "Buhd", "buhid" },
            { "Cakm", "chakma" },
            { "Cans", "zunifikowane symbole kanadyjskich autochtonów" },
            { "Cari", "karyjskie" },
            { "Cham", "czamskie" },
            { "Cher", "czirokeskie" },
            { "Cirt", "cirth" },
            { "Copt", "koptyjskie" },
            { "Cprt", "cypryjskie" },
            { "Cyrl", "cyrylica" },
            { "Cyrs", "cyrylica staro-cerkiewno-słowiańska" },
            { "Deva", "dewanagari" },
            { "Dsrt", "deseret" },
            { "Egyd", "egipskie demotyczne" },
            { "Egyh", "egipskie hieratyczne" },
            { "Egyp", "hieroglify egipskie" },
            { "Ethi", "etiopskie" },
            { "Geok", "gruzińskie chucuri" },
            { "Geor", "gruzińskie" },
            { "Glag", "głagolica" },
            { "Goth", "gotyckie" },
            { "Grek", "greckie" },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "chińskie z bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "chińskie" },
            { "Hano", "hanunoo" },
            { "Hans", "uproszczone" },
            { "Hant", "tradycyjne" },
            { "Hebr", "hebrajskie" },
            { "Hira", "hiragana" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "sylabariusze japońskie" },
            { "Hung", "starowęgierskie" },
            { "Inds", "indus" },
            { "Ital", "starowłoskie" },
            { "Jamo", "jamo" },
            { "Java", "jawajskie" },
            { "Jpan", "japońskie" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "charosti" },
            { "Khmr", "khmerskie" },
            { "Knda", metaValue_kn },
            { "Kore", "koreańskie" },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", "laotańskie" },
            { "Latf", "łaciński - fraktura" },
            { "Latg", "łaciński - odmiana gaelicka" },
            { "Latn", "łacińskie" },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "linearne A" },
            { "Linb", "linearne B" },
            { "Lyci", "likijskie" },
            { "Lydi", "lidyjskie" },
            { "Mand", "mandejskie" },
            { "Mani", "manichejskie" },
            { "Maya", "hieroglify Majów" },
            { "Mero", "meroickie" },
            { "Mlym", metaValue_ml },
            { "Mong", "mongolskie" },
            { "Moon", "Moon’a" },
            { "Mtei", "meitei mayek" },
            { "Mymr", "birmańskie" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ogham" },
            { "Olck", "ol ciki" },
            { "Orkh", "orchońskie" },
            { "Orya", metaValue_or },
            { "Osma", "osmanya" },
            { "Perm", "staropermskie" },
            { "Phag", "phags-pa" },
            { "Phli", "inskrypcyjne pahlawi" },
            { "Phlp", "pahlawi psałterzowy" },
            { "Phlv", "pahlawi książkowy" },
            { "Phnx", metaValue_phn },
            { "Plrd", "fonetyczny Pollard’a" },
            { "Prti", "partyjski inskrypcyjny" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "runiczne" },
            { "Samr", "samarytański" },
            { "Sara", "sarati" },
            { "Saur", "saurashtra" },
            { "Sgnw", "pismo znakowe" },
            { "Shaw", "shawa" },
            { "Sinh", "syngaleskie" },
            { "Sund", "sundajskie" },
            { "Sylo", "syloti nagri" },
            { "Syrc", "syryjskie" },
            { "Syre", "syriacki estrangelo" },
            { "Syrj", "syryjski (odmiana zachodnia)" },
            { "Syrn", "syryjski (odmiana wschodnia)" },
            { "Tagb", "tagbanwa" },
            { "Tale", "tai le" },
            { "Talu", "nowy tai lue" },
            { "Taml", "tamilskie" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh (berberski)" },
            { "Tglg", "tagalog" },
            { "Thaa", "taana" },
            { "Thai", "tajskie" },
            { "Tibt", "tybetańskie" },
            { "Ugar", "ugaryckie" },
            { "Vaii", "vai" },
            { "Visp", "Visible Speech" },
            { "Xpeo", "staroperskie" },
            { "Xsux", "klinowe sumero-akadyjskie" },
            { "Yiii", "yi" },
            { "Zinh", "dziedziczone" },
            { "Zmth", "notacja matematyczna" },
            { "Zsye", "emoji" },
            { "Zsym", "symbole" },
            { "Zxxx", "język bez systemu pisma" },
            { "Zyyy", "wspólne" },
            { "Zzzz", "nieznane pismo" },
            { "de_AT", "niemiecki austriacki" },
            { "de_CH", "wysokoniemiecki szwajcarski" },
            { "en_AU", "angielski australijski" },
            { "en_CA", "angielski kanadyjski" },
            { "en_GB", "angielski brytyjski" },
            { "en_US", "angielski amerykański" },
            { "es_ES", "europejski hiszpański" },
            { "es_MX", "meksykański hiszpański" },
            { "fa_AF", "dari" },
            { "fr_CA", "francuski kanadyjski" },
            { "fr_CH", "francuski szwajcarski" },
            { "nl_BE", "flamandzki" },
            { "pt_BR", "brazylijski portugalski" },
            { "pt_PT", "europejski portugalski" },
            { "ro_MD", "mołdawski" },
            { "sw_CD", "kongijski suahili" },
            { "%%1901", "tradycyjna ortografia niemiecka" },
            { "%%1994", "standardowa ortografia regionu Resia" },
            { "%%1996", "ortografia niemiecka z 1996 r." },
            { "ar_001", "współczesny arabski" },
            { "es_419", "amerykański hiszpański" },
            { "key.ca", "kalendarz" },
            { "key.cf", "format waluty" },
            { "key.co", "kolejność sortowania" },
            { "key.cu", "waluta" },
            { "key.em", "prezentacja emoji" },
            { "key.hc", "cykl (12- lub 24-godzinny)" },
            { "key.lb", "styl podziału wiersza" },
            { "key.lw", "podział wierszy wewnątrz wyrazów" },
            { "key.ms", "system miar" },
            { "key.nu", "cyfry" },
            { "key.ss", "koniec zdania po skrócie" },
            { "key.tz", "strefa czasowa" },
            { "key.va", "wariant regionalny" },
            { "nds_NL", "dolnosaksoński" },
            { "%%BISKE", "dialekt San Giorgio/Bila" },
            { "%%BOONT", "dialekt Boontling" },
            { "%%KKCOR", "ortografia wspólna" },
            { "%%LIPAW", "dialekt Lipovaz w regionie Resia" },
            { "%%NEDIS", "dialekt Natisone" },
            { "%%NJIVA", "dialekt Gniva/Njiva" },
            { "%%OSOJS", "dialekt Oseacco/Osojane" },
            { "%%POSIX", "komputerowy" },
            { "%%ROZAJ", "dialekt regionu Resia" },
            { "%%SAAHO", "dialekt Saho" },
            { "%%SOLBA", "dialekt Stolvizza/Solbica" },
            { "%%UCCOR", "ortografia ujednolicona" },
            { "hi_Latn", "hindi (alfabet łaciński)" },
            { "zh_Hans", "chiński uproszczony" },
            { "zh_Hant", "chiński tradycyjny" },
            { "%%FONIPA", "fonetyczny międzynarodowy" },
            { "%%FONUPA", "fonetyczny" },
            { "%%SCOUSE", "dialekt Scouse" },
            { "%%TARASK", "ortografia taraszkiewicka" },
            { "%%UCRCOR", "zreformowana ortografia ujednolicona" },
            { "%%AREVELA", "ormiański wchodni" },
            { "%%AREVMDA", "ormiański zachodni" },
            { "%%MONOTON", "monotoniczny" },
            { "%%POLYTON", "politoniczny" },
            { "%%REVISED", "ortografia zreformowana" },
            { "%%1606NICT", "szesnastowieczny francuski" },
            { "%%1694ACAD", "siedemnastowieczny francuski" },
            { "%%BAKU1926", "turecki zunifikowany alfabet łaciński" },
            { "%%SCOTLAND", "standardowy szkocki angielski" },
            { "%%VALENCIA", "walencki" },
            { "%%WADEGILE", "latynizacja Wade’a i Gilesa" },
            { "type.ca.roc", "kalendarz Republiki Chińskiej" },
            { "type.co.eor", "europejskie reguły określania kolejności" },
            { "type.hc.h11", "system 12-godzinny (0–11)" },
            { "type.hc.h12", "system 12-godzinny (1–12)" },
            { "type.hc.h23", "system 24-godzinny (0–23)" },
            { "type.hc.h24", "system 24-godzinny (1–24)" },
            { "type.m0.bgn", "transliteracja BGN" },
            { "type.nu.arab", "cyfry arabsko-indyjskie" },
            { "type.nu.armn", "cyfry ormiańskie" },
            { "type.nu.beng", "cyfry bengalskie" },
            { "type.nu.cakm", metaValue_ccp },
            { "type.nu.deva", "cyfry dewanagari" },
            { "type.nu.ethi", "cyfry etiopskie" },
            { "type.nu.geor", "cyfry gruzińskie" },
            { "type.nu.grek", "cyfry greckie" },
            { "type.nu.gujr", "cyfry gudżarati" },
            { "type.nu.guru", "cyfry gurmukhi" },
            { "type.nu.hans", "uproszczone cyfry chińskie" },
            { "type.nu.hant", "tradycyjne cyfry chińskie" },
            { "type.nu.hebr", "cyfry hebrajskie" },
            { "type.nu.java", "cyfry jawajskie" },
            { "type.nu.jpan", "cyfry japońskie" },
            { "type.nu.khmr", "cyfry khmerskie" },
            { "type.nu.knda", "cyfry kannada" },
            { "type.nu.laoo", "cyfry laotańskie" },
            { "type.nu.latn", "cyfry arabskie" },
            { "type.nu.mlym", "cyfry malajalam" },
            { "type.nu.mong", "Cyfry mongolskie" },
            { "type.nu.mtei", "cyfry meetei mayek" },
            { "type.nu.mymr", "cyfry birmańskie" },
            { "type.nu.olck", "cyfry ol ciki" },
            { "type.nu.orya", "cyfry orija" },
            { "type.nu.taml", "tradycyjne cyfry tamilskie" },
            { "type.nu.telu", "cyfry telugu" },
            { "type.nu.thai", "cyfry tajskie" },
            { "type.nu.tibt", "cyfry tybetańskie" },
            { "type.nu.vaii", "cyfry vai" },
            { "type.ca.dangi", "kalendarz koreański" },
            { "type.co.ducet", "domyślna kolejność sortowania Unicode" },
            { "type.lb.loose", "luźny styl podziału wiersza" },
            { "type.nu.roman", "cyfry rzymskie" },
            { "type.ca.coptic", "kalendarz koptyjski" },
            { "type.ca.hebrew", "kalendarz hebrajski" },
            { "type.ca.indian", "narodowy kalendarz hinduski" },
            { "type.co.compat", "poprzedni porządek sortowania, dla zgodności" },
            { "type.co.pinyin", "porządek sortowania pinyin" },
            { "type.co.search", "wyszukiwanie ogólnego zastosowania" },
            { "type.co.stroke", "sortowanie wg liczby kresek" },
            { "type.co.unihan", "sortowanie wg kluczy i ich liczby kresek" },
            { "type.co.zhuyin", "sortowanie bopomofo" },
            { "type.d0.fwidth", "pełna szerokość" },
            { "type.d0.hwidth", "połowa szerokości" },
            { "type.lb.normal", "normalny styl podziału wiersza" },
            { "type.lb.strict", "ścisły styl podziału wiersza" },
            { "type.m0.ungegn", "transliteracja UNGEGN" },
            { "type.ms.metric", "system metryczny" },
            { "type.nu.native", "cyfry macierzyste" },
            { "type.ca.chinese", "kalendarz chiński" },
            { "type.ca.islamic", "kalendarz muzułmański" },
            { "type.ca.iso8601", "kalendarz ISO-8601" },
            { "type.ca.persian", "kalendarz perski" },
            { "type.cf.account", "księgowy format waluty" },
            { "type.d0.npinyin", "Liczbowe" },
            { "type.nu.arabext", "rozszerzone cyfry arabsko-indyjskie" },
            { "type.nu.armnlow", "cyfry ormiańskie (małe litery)" },
            { "type.nu.finance", "Liczebniki księgowe" },
            { "type.nu.greklow", "cyfry greckie (małe litery)" },
            { "type.nu.hanidec", "chińskie cyfry dziesiętne" },
            { "type.nu.hansfin", "uproszczone chińskie cyfry księgowe" },
            { "type.nu.hantfin", "tradycyjne chińskie cyfry księgowe" },
            { "type.nu.jpanfin", "japońskie cyfry księgowe" },
            { "type.nu.tamldec", "cyfry tamilskie" },
            { "type.ca.buddhist", "kalendarz buddyjski" },
            { "type.ca.ethiopic", "kalendarz etiopski" },
            { "type.ca.japanese", "kalendarz japoński" },
            { "type.cf.standard", "standardowy format waluty" },
            { "type.co.phonetic", "sortowanie fonetyczne" },
            { "type.co.searchjl", "Wyszukiwanie według początkowej spółgłoski hangul" },
            { "type.co.standard", "standardowa kolejność sortowania" },
            { "type.ms.uksystem", "imperialny system miar" },
            { "type.ms.ussystem", "amerykański system miar" },
            { "type.nu.fullwide", "cyfry o pełnej szerokości" },
            { "type.nu.romanlow", "cyfry rzymskie (małe litery)" },
            { "type.ca.gregorian", "kalendarz gregoriański" },
            { "type.co.phonebook", "porządek sortowania książki telefonicznej" },
            { "type.co.dictionary", "sortowanie słownikowe" },
            { "type.co.traditional", "tradycyjny porządek sortowania" },
            { "type.nu.traditional", "Liczebniki tradycyjne" },
            { "type.ca.islamic-rgsa", "kalendarz islamski (Arabia Saudyjska, metoda wzrokowa)" },
            { "type.ca.islamic-tbla", "kalendarz islamski (metoda obliczeniowa, epoka astronomiczna)" },
            { "type.ca.islamic-civil", "kalendarz muzułmański (metoda obliczeniowa)" },
            { "type.ca.islamic-umalqura", "kalendarz muzułmański (Umm al-Kura)" },
            { "type.ca.ethiopic-amete-alem", "kalendarz etiopski Amete Alem" },
        };
        return data;
    }
}
