/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ky extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Гринвич боюнча орточо убакыт",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Апиа кышкы убактысы",
               "",
               "Апиа жайкы убактысы",
               "",
               "Апиа убактысы",
               "",
            };
        final String[] Cook = new String[] {
               "Кук аралдарынын кышкы убактысы",
               "",
               "Кук аралдарынын жарым жайкы убактысы",
               "",
               "Кук аралдарынын убактысы",
               "",
            };
        final String[] Cuba = new String[] {
               "Куба кышкы убактысы",
               "CST",
               "Куба жайкы убактысы",
               "CDT",
               "Куба убактысы",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Фижи кышкы убакыты",
               "",
               "Фижи жайкы убактысы",
               "",
               "Фижи убактысы",
               "",
            };
        final String[] Gulf = new String[] {
               "Булуңдун стандарттык убакыты",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Ховд кышкы убакыты",
               "",
               "Ховд жайкы убактысы",
               "",
               "Ховд убактысы",
               "",
            };
        final String[] Iran = new String[] {
               "Иран кышкы убакыты",
               "",
               "Иран күндүзгү убактысы",
               "",
               "Иран убактысы",
               "",
            };
        final String[] Niue = new String[] {
               "Ниуэ убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Омск кышкы убакыты",
               "",
               "Омск жайкы убактысы",
               "",
               "Омск убактысы",
               "",
            };
        final String[] Peru = new String[] {
               "Перу кышкы убактысы",
               "",
               "Перу жайкы убактысы",
               "",
               "Перу убактысы",
               "",
            };
        final String[] Truk = new String[] {
               "Чуук убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Уейк аралдарынын убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Чили кышкы убактысы",
               "",
               "Чили жайкы убактысы",
               "",
               "Чили убактысы",
               "",
            };
        final String[] China = new String[] {
               "Кытай кышкы убакыты",
               "CST",
               "Кытай жайкы убакыты",
               "CDT",
               "Кытай убактысы",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Кокос аралдарынын убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Дэвис убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Индия убактысы",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Жапон кышкы убакыты",
               "JST",
               "Жапон жайкы убактысы",
               "JDT",
               "Жапон убактысы",
               "JT",
            };
        final String[] Korea = new String[] {
               "Корея кышкы убакыты",
               "KST",
               "Корея жайкы убактысы",
               "KST",
               "Корея убактысы",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Науру убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Непал убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Палау убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Самоа кышкы убактысы",
               "SST",
               "Самоа жайкы убактысы",
               "SST",
               "Самоа убактысы",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Саоа убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Тонга кышкы убактысы",
               "",
               "Тонга жайкы убактысы",
               "",
               "Тонга убактысы",
               "",
            };
        final String[] Yukon = new String[] {
               "Юкон убактысы",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Аляска кышкы убактысы",
               "AKST",
               "Аляска жайкы убактысы",
               "AKDT",
               "Аляска убактысы",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Амазон кышкы убактысы",
               "",
               "Амазон жайкы убактысы",
               "",
               "Амазон убактысы",
               "",
            };
        final String[] Azores = new String[] {
               "Азор кышкы убакыты",
               "",
               "Азорс жайкы убактысы",
               "",
               "Азор убактысы",
               "",
            };
        final String[] Bhutan = new String[] {
               "Бутан убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Бруней Даруссалам убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Истер аралынын кышкы убакыты",
               "",
               "Истер аралынын жайкы убакыты",
               "",
               "Истер аралынын убактысы",
               "",
            };
        final String[] Guyana = new String[] {
               "Гвиана убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Гавайи-Алеут кышкы убактысы",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Израиль кышкы убакыты",
               "IST",
               "Израиль жайкы убакыты",
               "IDT",
               "Израиль убакыты",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Косрае убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Моусон убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Москва кышкы убакыты",
               "MSK",
               "Москва жайкы убактысы",
               "MSK",
               "Москва убактысы",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Понапе убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Таити убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Тайпей кышкы убакыты",
               "CST",
               "Тайпей жайкы убакыты",
               "CDT",
               "Тайпей убактысы",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Тувалу убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Восток убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Уолис жана Футуна убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Арабия кышкы убакыты",
               "",
               "Арабия жайкы убакыты",
               "",
               "Арабия убактысы",
               "",
            };
        final String[] Armenia = new String[] {
               "Армения кышкы убакыты",
               "",
               "Армения жайкы убактысы",
               "",
               "Армения убактысы",
               "",
            };
        final String[] Bolivia = new String[] {
               "Боливия убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Чатам кышкы убакыт",
               "",
               "Чатам жайкы убактысы",
               "",
               "Чатам убактысы",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Бирдиктүү дүйнөлүк убакыт",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Экуадор убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Гамбие убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Грузия кышкы убакыты",
               "",
               "Грузия жайкы убактысы",
               "",
               "Грузия убактысы",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Иркутск кышкы убакыты",
               "",
               "Иркутск жайкы убакыты",
               "",
               "Иркутск убактысы",
               "",
            };
        final String[] Magadan = new String[] {
               "Магадан кышкы убакыты",
               "",
               "Магадан жайкы убактысы",
               "",
               "Магадан убактысы",
               "",
            };
        final String[] Myanmar = new String[] {
               "Мйанмар убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Норфолк кышкы убактысы",
               "",
               "Норфолк жайкы убактысы",
               "",
               "Норфолк убактысы",
               "",
            };
        final String[] Noronha = new String[] {
               "Фернандо де Норонья кышкы убактысы",
               "",
               "Фернандо де Норонья жайкы убактысы",
               "",
               "Фернандо де Норонья убактысы",
               "",
            };
        final String[] Reunion = new String[] {
               "Реюнион убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ротера убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Соломон аралдарынын убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Токелау убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Уругвай кышкы убактысы",
               "",
               "Уругвай жайкы убактысы",
               "",
               "Уругвай убактысы",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Вануату кышкы убакыты",
               "",
               "Вануату жайкы убактысы",
               "",
               "Вануату убактысы",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Якутск кышкы убакыты",
               "",
               "Якутск жайкы убактысы",
               "",
               "Якутск убактысы",
               "",
            };
        final String[] Atlantic = new String[] {
               "Атлантика кышкы убактысы",
               "AST",
               "Атлантика жайкы убактысы",
               "AST",
               "Атлантика убактысы",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Бразилия кышкы убактысы",
               "",
               "Бразилия жайкы убактысы",
               "",
               "Бразилия убактысы",
               "",
            };
        final String[] Chamorro = new String[] {
               "Чаморро убактысы",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Колумбия кышкы убактысы",
               "",
               "Колумбия жайкы убактысы",
               "",
               "Колумбия убактысы",
               "",
            };
        final String[] Falkland = new String[] {
               "Фолкленд аралдарынын кышкы убакыты",
               "",
               "Фолкленд аралдарынын жайкы убактысы",
               "",
               "Фолкленд аралдарынын убактысы",
               "",
            };
        final String[] Malaysia = new String[] {
               "Малайзия убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Мальдив убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Улан Батор кышкы убакыты",
               "",
               "Улан Батор жайкы убактысы",
               "",
               "Улан Батор убактысы",
               "",
            };
        final String[] Pakistan = new String[] {
               "Пакистан кышкы убакыты",
               "PKT",
               "Пакистан жайкы убактысы",
               "PKST",
               "Пакистан убактысы",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Парагвай кышкы убактысы",
               "",
               "Парагвай жайкы убактысы",
               "",
               "Парагвай убактысы",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Питкэрнг убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Суринаме убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Аргентина кышкы убактысы",
               "",
               "Аргентина жайкы убактысы",
               "",
               "Аргентина убактысы",
               "",
            };
        final String[] Christmas = new String[] {
               "Крисмас аралынын убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Галапагос убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Гонконг кышкы убакыты",
               "HKT",
               "Гонконг жайкы убактысы",
               "HKST",
               "Гонконг убактысы",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Индокытай убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Кыргызстан убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Лорд Хау кышкы убакыты",
               "",
               "Лорд Хау жайкы убактысы",
               "",
               "Лорд Хау убактысы",
               "",
            };
        final String[] Marquesas = new String[] {
               "Маркезас убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Маврикий кышкы убакыты",
               "",
               "Маврикий жайкы убактысы",
               "",
               "Маврикий убактысы",
               "",
            };
        final String[] Singapore = new String[] {
               "Сингапур убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Венесуэла убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Азербайжан кышкы убакыты",
               "",
               "Азербайжан жайкы убактысы",
               "",
               "Азербайжан убактысы",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Бангладеш кышкы убакыты",
               "",
               "Бангладеш жайкы убактысы",
               "",
               "Бангладеш убактысы",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Капе Верде кышкы убакыты",
               "",
               "Капе Верде жайкы убактысы",
               "",
               "Капе Верде убактысы",
               "",
            };
        final String[] East_Timor = new String[] {
               "Чыгыш Тимор убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Казакстан убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Сейшел убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Тажикстан убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Өзбекстан кышкы убакыты",
               "",
               "Өзбекстан жайкы убактысы",
               "",
               "Өзбекстан убактысы",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Афганистан убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Красноярск кышкы убакыты",
               "",
               "Красноярск жайкы убактысы",
               "",
               "Красноярск убактысы",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Жаңы Зеландия кышкы убакыты",
               "NZST",
               "Жаңы Зеландия жайкы убакыты",
               "NZDT",
               "Жаңы Зеландия убактысы",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Филиппин аралдарынын кышкы убактысы",
               "PST",
               "Филиппин аралдарынын жайкы убактысы",
               "PDT",
               "Филиппин аралдарынын убактысы",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Владивосток кышкы убакыты",
               "",
               "Владивосток жайкы убактысы",
               "",
               "Владивосток убактысы",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Инди океан убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Лайн аралдарынын убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Нюфаундлэнд кышкы убактысы",
               "NST",
               "Нюфаундлэнд жайкы убактысы",
               "NDT",
               "Нюфаундлэнд убактысы",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Түркмөнстан кышкы убакыты",
               "",
               "Түркмөнстан жайкы убактысы",
               "",
               "Түркмөнстан убактысы",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Француз Гвиана убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Жаңы Каледония кышкы убактысы",
               "",
               "Жаңы Каледония жайкы убактысы",
               "",
               "Жаңы Каледония убактысы",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Түштүк Жоржия убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Екатеринбург кышкы убакыты",
               "",
               "Екатеринбург жайкы убактысы",
               "",
               "Екатеринбург убактысы",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Борбордук Африка убактысы",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Чыгыш Африка убактысы",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Батыш Африка убактысы",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Дюмон-д-Урвил убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Борбордук Европа кышкы убакыты",
               "CET",
               "Борбордук Европа жайкы убактысы",
               "CEST",
               "Борбордук Европа убактысы",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Чыгыш Европа кышкы убакыты",
               "EET",
               "Чыгыш Европа жайкы убактысы",
               "EEST",
               "Чыгыш Европа убактысы",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Батыш Европа кышкы убакыты",
               "WET",
               "Батыш Европа жайкы убактысы",
               "WEST",
               "Батыш Европа убактысы",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Мексика, Тынч океан кышкы убактысы",
               "MST",
               "Мексика, Тынч океан жайкы убактысы",
               "MDT",
               "Мексика, Тынч океан убактысы",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Түштүк Африка убактысы",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Түндүк Америка, борбордук кышкы убактысы",
               "CST",
               "Түндүк Америка, борбордук жайкы убактысы",
               "CDT",
               "Түндүк Америка, борбордук убакыт",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Түндүк Америка, чыгыш кышкы убактысы",
               "EST",
               "Түндүк Америка, чыгыш жайкы убактысы",
               "EST",
               "Түндүк Америка, чыгыш убактысы",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Түндүк Америка, Тынч океан кышкы убактысы",
               "PST",
               "Түндүк Америка, Тынч океан жайкы убактысы",
               "PDT",
               "Түндүк Америка, Тынч океан убактысы",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Француз Түштүгү жана Антарктика убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Гилберт убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Гавайи-Алеут кышкы убактысы",
               "HST",
               "Гавайи-Алеут жайкы убактысы",
               "HDT",
               "Гавайи-Алеут убактысы",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Феникс аралдарынын убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Сен Пьер жана Микелон кышкы убактысы",
               "",
               "Сен Пьер жана Микелон жайкы убактысы",
               "",
               "Сен Пьер жана Микелон убактысы",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Түндүк Америка, тоо кышкы убактысы",
               "MST",
               "Түндүк Америка, тоо жайкы убактысы",
               "MST",
               "Түндүк Америка, тоо убактысы",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Маршалл аралдарынын убактысы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Папуа-Жаңы Гвинея убакыты",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Австралия борбордук кышкы убакыты",
               "ACST",
               "Австралия борбордук жайкы убактысы",
               "ACDT",
               "Австралия борбордук убактысы",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Австралия чыгыш кышкы убакыты",
               "AEST",
               "Австралия чыгыш жайкы убактысы",
               "AEDT",
               "Австралия чыгыш убактысы",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Австралия батыш кышкы убакыты",
               "AWST",
               "Австралия батыш жайкы убактысы",
               "AWDT",
               "Австралия батыш убактысы",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Борбордук Индонезия убактысы",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Чыгыш Индонезия убактысы",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Батыш Индонезия убактысы",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Австралия борбордук батыш кышкы убакыты",
               "",
               "Австралия борбордук чыгыш жайкы убактысы",
               "",
               "Австралия борбордук батыш убактысы",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Гринвич боюнча орточо убакыт",
                    "GMT",
                    "Британия жайкы убактысы",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Бирдиктүү дүйнөлүк убакыт",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Гринвич боюнча орточо убакыт",
                    "GMT",
                    "Ирландия кышкы убакыты",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Бирдиктүү дүйнөлүк убакыт",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Бирдиктүү дүйнөлүк убакыт",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Гринвич боюнча орточо убакыт",
                    "GMT",
                    "Британия жайкы убактысы",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Бирдиктүү дүйнөлүк убакыт",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "Бирдиктүү дүйнөлүк убакыт",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Бирдиктүү дүйнөлүк убакыт",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Гринвич боюнча орточо убакыт",
                    "GMT",
                    "Ирландия кышкы убакыты",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Гринвич боюнча орточо убакыт",
                    "GMT",
                    "Британия жайкы убактысы",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Гринвич боюнча орточо убакыт",
                    "GMT",
                    "Британия жайкы убактысы",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Гринвич боюнча орточо убакыт",
                    "GMT",
                    "Британия жайкы убактысы",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Гринвич боюнча орточо убакыт",
                    "GMT",
                    "Британия жайкы убактысы",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Гринвич боюнча орточо убакыт",
                    "GMT",
                    "Британия жайкы убактысы",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Аден" },
            { "timezone.excity.Asia/Baku", "Баку" },
            { "timezone.excity.Asia/Dili", "Дили" },
            { "timezone.excity.Asia/Gaza", "Газа" },
            { "timezone.excity.Asia/Hovd", "Ховд" },
            { "timezone.excity.Asia/Omsk", "Омск" },
            { "timezone.excity.Asia/Oral", "Орал" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Амман" },
            { "timezone.excity.Asia/Aqtau", "Актау" },
            { "timezone.excity.Asia/Chita", "Чита" },
            { "timezone.excity.Asia/Dhaka", "Дакка" },
            { "timezone.excity.Asia/Dubai", "Дубай" },
            { "timezone.excity.Asia/Kabul", "Кабул" },
            { "timezone.excity.Asia/Macau", "Макау" },
            { "timezone.excity.Asia/Qatar", "Катар" },
            { "timezone.excity.Asia/Seoul", "Сеул" },
            { "timezone.excity.Asia/Tokyo", "Токио" },
            { "timezone.excity.Asia/Tomsk", "Томск" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Жуба" },
            { "timezone.excity.Africa/Lome", "Ломе" },
            { "timezone.excity.Asia/Almaty", "Алматы" },
            { "timezone.excity.Asia/Anadyr", "Анадыр" },
            { "timezone.excity.Asia/Aqtobe", "Актобе" },
            { "timezone.excity.Asia/Atyrau", "Атырау" },
            { "timezone.excity.Asia/Beirut", "Бейрут" },
            { "timezone.excity.Asia/Brunei", "Бруней" },
            { "timezone.excity.Asia/Hebron", "Хеброн" },
            { "timezone.excity.Asia/Kuwait", "Кувейт" },
            { "timezone.excity.Asia/Manila", "Манила" },
            { "timezone.excity.Asia/Muscat", "Мускат" },
            { "timezone.excity.Asia/Riyadh", "Рийад" },
            { "timezone.excity.Asia/Saigon", "Хо Ши Мин" },
            { "timezone.excity.Asia/Taipei", "Тайпей" },
            { "timezone.excity.Asia/Tehran", "Тегеран" },
            { "timezone.excity.Asia/Urumqi", "Үрүмчү" },
            { "timezone.excity.Etc/Unknown", "Белгисиз шаар" },
            { "timezone.excity.Europe/Kiev", "Киев" },
            { "timezone.excity.Europe/Oslo", "Осло" },
            { "timezone.excity.Europe/Riga", "Рига" },
            { "timezone.excity.Europe/Rome", "Рим" },
            { "timezone.excity.Indian/Mahe", "Маэ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Аккра" },
            { "timezone.excity.Africa/Cairo", "Каир" },
            { "timezone.excity.Africa/Ceuta", "Сеута" },
            { "timezone.excity.Africa/Dakar", "Дакар" },
            { "timezone.excity.Africa/Lagos", "Лагос" },
            { "timezone.excity.Africa/Tunis", "Тунис" },
            { "timezone.excity.America/Adak", "Адак" },
            { "timezone.excity.America/Lima", "Лима" },
            { "timezone.excity.America/Nome", "Ном" },
            { "timezone.excity.Asia/Baghdad", "Багдад" },
            { "timezone.excity.Asia/Bahrain", "Бахрейн" },
            { "timezone.excity.Asia/Bangkok", "Бангкок" },
            { "timezone.excity.Asia/Barnaul", "Барнаул" },
            { "timezone.excity.Asia/Bishkek", "Бишкек" },
            { "timezone.excity.Asia/Colombo", "Коломбо" },
            { "timezone.excity.Asia/Irkutsk", "Иркутск" },
            { "timezone.excity.Asia/Jakarta", "Жакарта" },
            { "timezone.excity.Asia/Karachi", "Карачи" },
            { "timezone.excity.Asia/Kuching", "Кучиң" },
            { "timezone.excity.Asia/Magadan", "Магадан" },
            { "timezone.excity.Asia/Nicosia", "Никосия" },
            { "timezone.excity.Asia/Rangoon", "Рангун" },
            { "timezone.excity.Asia/Tbilisi", "Тбилиси" },
            { "timezone.excity.Asia/Thimphu", "Тимпу" },
            { "timezone.excity.Asia/Yakutsk", "Якутск" },
            { "timezone.excity.Asia/Yerevan", "Ереван" },
            { "timezone.excity.Europe/Kirov", "Киров" },
            { "timezone.excity.Europe/Malta", "Мальта" },
            { "timezone.excity.Europe/Minsk", "Минск" },
            { "timezone.excity.Europe/Paris", "Париж" },
            { "timezone.excity.Europe/Sofia", "София" },
            { "timezone.excity.Europe/Vaduz", "Фадуц" },
            { "timezone.excity.Indian/Cocos", "Кокос" },
            { "timezone.excity.Pacific/Apia", "Апиа" },
            { "timezone.excity.Pacific/Fiji", "Фижи" },
            { "timezone.excity.Pacific/Guam", "Гуам" },
            { "timezone.excity.Pacific/Niue", "Ниуэ" },
            { "timezone.excity.Pacific/Truk", "Чуук" },
            { "timezone.excity.Pacific/Wake", "Уейк" },
            { "timezone.excity.Africa/Asmera", "Асмара" },
            { "timezone.excity.Africa/Bamako", "Бамако" },
            { "timezone.excity.Africa/Bangui", "Баги" },
            { "timezone.excity.Africa/Banjul", "Банжул" },
            { "timezone.excity.Africa/Bissau", "Бисау" },
            { "timezone.excity.Africa/Douala", "Дуала" },
            { "timezone.excity.Africa/Harare", "Хараре" },
            { "timezone.excity.Africa/Kigali", "Кигали" },
            { "timezone.excity.Africa/Luanda", "Луанда" },
            { "timezone.excity.Africa/Lusaka", "Лусака" },
            { "timezone.excity.Africa/Malabo", "Малабо" },
            { "timezone.excity.Africa/Maputo", "Мапуто" },
            { "timezone.excity.Africa/Maseru", "Масеру" },
            { "timezone.excity.Africa/Niamey", "Нйаме" },
            { "timezone.excity.America/Aruba", "Аруба" },
            { "timezone.excity.America/Bahia", "Байиа" },
            { "timezone.excity.America/Belem", "Белем" },
            { "timezone.excity.America/Boise", "Бойсе" },
            { "timezone.excity.America/Jujuy", "Жужуй" },
            { "timezone.excity.America/Sitka", "Ситка" },
            { "timezone.excity.America/Thule", "Туле" },
            { "timezone.excity.Asia/Ashgabat", "Ашхабад" },
            { "timezone.excity.Asia/Calcutta", "Калькутта" },
            { "timezone.excity.Asia/Damascus", "Дамаск" },
            { "timezone.excity.Asia/Dushanbe", "Душанбе" },
            { "timezone.excity.Asia/Jayapura", "Жайапура" },
            { "timezone.excity.Asia/Katmandu", "Катманду" },
            { "timezone.excity.Asia/Khandyga", "Кандыга" },
            { "timezone.excity.Asia/Makassar", "Макассар" },
            { "timezone.excity.Asia/Qostanay", "Костанай" },
            { "timezone.excity.Asia/Sakhalin", "Сахалин" },
            { "timezone.excity.Asia/Shanghai", "Шанхай" },
            { "timezone.excity.Asia/Tashkent", "Ташкент" },
            { "timezone.excity.Asia/Ust-Nera", "Усть-Нера" },
            { "timezone.excity.Europe/Athens", "Афины" },
            { "timezone.excity.Europe/Berlin", "Берлин" },
            { "timezone.excity.Europe/Dublin", "Дублин" },
            { "timezone.excity.Europe/Jersey", "Жерси" },
            { "timezone.excity.Europe/Lisbon", "Лиссабон" },
            { "timezone.excity.Europe/London", "Лондон" },
            { "timezone.excity.Europe/Madrid", "Мадрид" },
            { "timezone.excity.Europe/Monaco", "Монако" },
            { "timezone.excity.Europe/Moscow", "Москва" },
            { "timezone.excity.Europe/Prague", "Прага" },
            { "timezone.excity.Europe/Samara", "Самара" },
            { "timezone.excity.Europe/Skopje", "Скопйе" },
            { "timezone.excity.Europe/Tirane", "Тирана" },
            { "timezone.excity.Europe/Vienna", "Вена" },
            { "timezone.excity.Europe/Warsaw", "Варшава" },
            { "timezone.excity.Europe/Zagreb", "Загреб" },
            { "timezone.excity.Europe/Zurich", "Цюрих" },
            { "timezone.excity.Indian/Chagos", "Чагос" },
            { "timezone.excity.Indian/Comoro", "Коморо" },
            { "timezone.excity.Pacific/Efate", "Эфат" },
            { "timezone.excity.Pacific/Nauru", "Науру" },
            { "timezone.excity.Pacific/Palau", "Палау" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Абиджан" },
            { "timezone.excity.Africa/Algiers", "Алжир" },
            { "timezone.excity.Africa/Conakry", "Конакри" },
            { "timezone.excity.Africa/Kampala", "Кампала" },
            { "timezone.excity.Africa/Mbabane", "Мбабане" },
            { "timezone.excity.Africa/Nairobi", "Найроби" },
            { "timezone.excity.Africa/Tripoli", "Триполи" },
            { "timezone.excity.America/Belize", "Белиз" },
            { "timezone.excity.America/Bogota", "Богота" },
            { "timezone.excity.America/Cancun", "Канкун" },
            { "timezone.excity.America/Cayman", "Кайман" },
            { "timezone.excity.America/Cuiaba", "Куйаба" },
            { "timezone.excity.America/Dawson", "Доусон" },
            { "timezone.excity.America/Denver", "Денвер" },
            { "timezone.excity.America/Guyana", "Гуйана" },
            { "timezone.excity.America/Havana", "Гавана" },
            { "timezone.excity.America/Inuvik", "Инувик" },
            { "timezone.excity.America/Juneau", "Жуно" },
            { "timezone.excity.America/La_Paz", "Ла Пас" },
            { "timezone.excity.America/Maceio", "Масейо" },
            { "timezone.excity.America/Manaus", "Манаус" },
            { "timezone.excity.America/Merida", "Мерида" },
            { "timezone.excity.America/Nassau", "Нассау" },
            { "timezone.excity.America/Panama", "Панама" },
            { "timezone.excity.America/Recife", "Ресифи" },
            { "timezone.excity.America/Regina", "Регина" },
            { "timezone.excity.Asia/Famagusta", "Фамагуста" },
            { "timezone.excity.Asia/Hong_Kong", "Гонконг" },
            { "timezone.excity.Asia/Jerusalem", "Иерусалим" },
            { "timezone.excity.Asia/Kamchatka", "Камчатка" },
            { "timezone.excity.Asia/Pontianak", "Понтианак" },
            { "timezone.excity.Asia/Pyongyang", "Пхеньян" },
            { "timezone.excity.Asia/Qyzylorda", "Кызылорда" },
            { "timezone.excity.Asia/Samarkand", "Самарканд" },
            { "timezone.excity.Asia/Singapore", "Сингапур" },
            { "timezone.excity.Asia/Vientiane", "Виентиан" },
            { "timezone.excity.Europe/Andorra", "Андорра" },
            { "timezone.excity.Europe/Saratov", "Саратов" },
            { "timezone.excity.Europe/Tallinn", "Таллин" },
            { "timezone.excity.Europe/Vatican", "Ватикан" },
            { "timezone.excity.Europe/Vilnius", "Вильнюс" },
            { "timezone.excity.Indian/Mayotte", "Майотт" },
            { "timezone.excity.Indian/Reunion", "Реюнион" },
            { "timezone.excity.Pacific/Easter", "Истер" },
            { "timezone.excity.Pacific/Kosrae", "Козрае" },
            { "timezone.excity.Pacific/Majuro", "Мажуро" },
            { "timezone.excity.Pacific/Midway", "Мидуэй" },
            { "timezone.excity.Pacific/Noumea", "Нумеа" },
            { "timezone.excity.Pacific/Ponape", "Понпей" },
            { "timezone.excity.Pacific/Saipan", "Сайпан" },
            { "timezone.excity.Pacific/Tahiti", "Таити" },
            { "timezone.excity.Pacific/Tarawa", "Тарава" },
            { "timezone.excity.Pacific/Wallis", "Уолис" },
            { "timezone.excity.Africa/Blantyre", "Блантайр" },
            { "timezone.excity.Africa/Djibouti", "Жибути" },
            { "timezone.excity.Africa/El_Aaiun", "Эл Айун" },
            { "timezone.excity.Africa/Freetown", "Фритаун" },
            { "timezone.excity.Africa/Gaborone", "Габороне" },
            { "timezone.excity.Africa/Khartoum", "Картум" },
            { "timezone.excity.Africa/Kinshasa", "Киншаса" },
            { "timezone.excity.Africa/Monrovia", "Монровиа" },
            { "timezone.excity.Africa/Ndjamena", "Нжамена" },
            { "timezone.excity.Africa/Sao_Tome", "Сао Томе" },
            { "timezone.excity.Africa/Windhoek", "Уиндхук" },
            { "timezone.excity.America/Antigua", "Антигуа" },
            { "timezone.excity.America/Caracas", "Каракас" },
            { "timezone.excity.America/Cayenne", "Кайен" },
            { "timezone.excity.America/Chicago", "Чикаго" },
            { "timezone.excity.America/Cordoba", "Кордова" },
            { "timezone.excity.America/Creston", "Крестон" },
            { "timezone.excity.America/Curacao", "Кюрасао" },
            { "timezone.excity.America/Detroit", "Детройт" },
            { "timezone.excity.America/Godthab", "Нуук" },
            { "timezone.excity.America/Grenada", "Гренада" },
            { "timezone.excity.America/Halifax", "Галифакс" },
            { "timezone.excity.America/Iqaluit", "Икалуит" },
            { "timezone.excity.America/Jamaica", "Ямайка" },
            { "timezone.excity.America/Managua", "Манагуа" },
            { "timezone.excity.America/Marigot", "Мариго" },
            { "timezone.excity.America/Mendoza", "Мендоза" },
            { "timezone.excity.America/Moncton", "Монктон" },
            { "timezone.excity.America/Noronha", "Норониа" },
            { "timezone.excity.America/Ojinaga", "Охинага" },
            { "timezone.excity.America/Phoenix", "Феникс" },
            { "timezone.excity.America/Tijuana", "Тихуана" },
            { "timezone.excity.America/Toronto", "Торонто" },
            { "timezone.excity.America/Tortola", "Тортола" },
            { "timezone.excity.America/Yakutat", "Якутат" },
            { "timezone.excity.Asia/Phnom_Penh", "Пномпень" },
            { "timezone.excity.Atlantic/Azores", "Азор" },
            { "timezone.excity.Atlantic/Canary", "Канари" },
            { "timezone.excity.Atlantic/Faeroe", "Фарер" },
            { "timezone.excity.Australia/Eucla", "Юкла" },
            { "timezone.excity.Australia/Perth", "Перт" },
            { "timezone.excity.Europe/Belgrade", "Белград" },
            { "timezone.excity.Europe/Brussels", "Брюссель" },
            { "timezone.excity.Europe/Budapest", "Будапешт" },
            { "timezone.excity.Europe/Busingen", "Бузинген" },
            { "timezone.excity.Europe/Chisinau", "Кишинев" },
            { "timezone.excity.Europe/Guernsey", "Гернси" },
            { "timezone.excity.Europe/Helsinki", "Хельсинки" },
            { "timezone.excity.Europe/Istanbul", "Стамбул" },
            { "timezone.excity.Europe/Sarajevo", "Сараево" },
            { "timezone.excity.Indian/Maldives", "Мальдив аралдары" },
            { "timezone.excity.Pacific/Chatham", "Чатем" },
            { "timezone.excity.Pacific/Fakaofo", "Факаофо" },
            { "timezone.excity.Pacific/Gambier", "Гамбие" },
            { "timezone.excity.Pacific/Norfolk", "Норфолк" },
            { "timezone.excity.Africa/Bujumbura", "Бужумбура" },
            { "timezone.excity.Africa/Mogadishu", "Могадишу" },
            { "timezone.excity.America/Anguilla", "Ангуила" },
            { "timezone.excity.America/Asuncion", "Асунсион" },
            { "timezone.excity.America/Barbados", "Барбадос" },
            { "timezone.excity.America/Dominica", "Доминика" },
            { "timezone.excity.America/Edmonton", "Эдмонтон" },
            { "timezone.excity.America/Eirunepe", "Эйрунепе" },
            { "timezone.excity.America/Mazatlan", "Мазатлан" },
            { "timezone.excity.America/Miquelon", "Микелон" },
            { "timezone.excity.America/New_York", "Нью-Йорк" },
            { "timezone.excity.America/Resolute", "Резолут" },
            { "timezone.excity.America/Santarem", "Сантарем" },
            { "timezone.excity.America/Santiago", "Сантиаго" },
            { "timezone.excity.America/St_Johns", "Сент Жонс" },
            { "timezone.excity.America/St_Kitts", "Сент-Китс" },
            { "timezone.excity.America/St_Lucia", "Санта Лючия" },
            { "timezone.excity.America/Winnipeg", "Уиннипег" },
            { "timezone.excity.Antarctica/Casey", "Кейси" },
            { "timezone.excity.Antarctica/Davis", "Дэвис" },
            { "timezone.excity.Antarctica/Syowa", "Саоа" },
            { "timezone.excity.Antarctica/Troll", "Тролл" },
            { "timezone.excity.Asia/Krasnoyarsk", "Красноярск" },
            { "timezone.excity.Asia/Novosibirsk", "Новосибирск" },
            { "timezone.excity.Asia/Ulaanbaatar", "Улан-Батор" },
            { "timezone.excity.Asia/Vladivostok", "Владивосток" },
            { "timezone.excity.Atlantic/Bermuda", "Бермуда" },
            { "timezone.excity.Atlantic/Madeira", "Мадейра" },
            { "timezone.excity.Atlantic/Stanley", "Стэнли" },
            { "timezone.excity.Australia/Darwin", "Дарвин" },
            { "timezone.excity.Australia/Hobart", "Хобарт" },
            { "timezone.excity.Australia/Sydney", "Сидней" },
            { "timezone.excity.Europe/Amsterdam", "Амстердам" },
            { "timezone.excity.Europe/Astrakhan", "Астрахань" },
            { "timezone.excity.Europe/Bucharest", "Бухарест" },
            { "timezone.excity.Europe/Gibraltar", "Гибралтар" },
            { "timezone.excity.Europe/Ljubljana", "Любляна" },
            { "timezone.excity.Europe/Mariehamn", "Мариехамн" },
            { "timezone.excity.Europe/Podgorica", "Подгорица" },
            { "timezone.excity.Europe/Stockholm", "Стокгольм" },
            { "timezone.excity.Europe/Ulyanovsk", "Ульяновск" },
            { "timezone.excity.Europe/Volgograd", "Волгоград" },
            { "timezone.excity.Indian/Christmas", "Крисмас" },
            { "timezone.excity.Indian/Kerguelen", "Кергелен" },
            { "timezone.excity.Indian/Mauritius", "Маврикий" },
            { "timezone.excity.Pacific/Auckland", "Оклэнд" },
            { "timezone.excity.Pacific/Funafuti", "Фунафути" },
            { "timezone.excity.Pacific/Honolulu", "Гонолулу" },
            { "timezone.excity.Pacific/Pitcairn", "Питкэрн" },
            { "timezone.excity.Africa/Casablanca", "Касабланка" },
            { "timezone.excity.Africa/Libreville", "Либревилл" },
            { "timezone.excity.Africa/Lubumbashi", "Лубумбаши" },
            { "timezone.excity.Africa/Nouakchott", "Нуакшот" },
            { "timezone.excity.Africa/Porto-Novo", "Порто-Ново" },
            { "timezone.excity.America/Anchorage", "Анкориж" },
            { "timezone.excity.America/Araguaina", "Арагуаина" },
            { "timezone.excity.America/Boa_Vista", "Боа Виста" },
            { "timezone.excity.America/Catamarca", "Катамарка" },
            { "timezone.excity.America/Chihuahua", "Чихуахуа" },
            { "timezone.excity.America/Coyhaique", "Койайке" },
            { "timezone.excity.America/Fortaleza", "Форталеза" },
            { "timezone.excity.America/Glace_Bay", "Глейс Бей" },
            { "timezone.excity.America/Goose_Bay", "Гус Бей" },
            { "timezone.excity.America/Guatemala", "Гватемала" },
            { "timezone.excity.America/Guayaquil", "Гуайакил" },
            { "timezone.excity.America/Matamoros", "Матаморос" },
            { "timezone.excity.America/Menominee", "Меномини" },
            { "timezone.excity.America/Monterrey", "Монтерей" },
            { "timezone.excity.America/Sao_Paulo", "Сао Пауло" },
            { "timezone.excity.America/St_Thomas", "Сент-Томас" },
            { "timezone.excity.America/Vancouver", "Ванкувер" },
            { "timezone.excity.Antarctica/Mawson", "Моусон" },
            { "timezone.excity.Antarctica/Palmer", "Палмер" },
            { "timezone.excity.Antarctica/Vostok", "Восток" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Куала Лумпур" },
            { "timezone.excity.Asia/Novokuznetsk", "Новокузнецк" },
            { "timezone.excity.Europe/Bratislava", "Братислава" },
            { "timezone.excity.Europe/Copenhagen", "Копенгаген" },
            { "timezone.excity.Europe/Luxembourg", "Люксембург" },
            { "timezone.excity.Europe/San_Marino", "Сан Марино" },
            { "timezone.excity.Europe/Simferopol", "Симферополь" },
            { "timezone.excity.Pacific/Enderbury", "Кантон" },
            { "timezone.excity.Pacific/Galapagos", "Галапагос" },
            { "timezone.excity.Pacific/Kwajalein", "Куажалейн" },
            { "timezone.excity.Pacific/Marquesas", "Маркезас" },
            { "timezone.excity.Pacific/Pago_Pago", "Паго Паго" },
            { "timezone.excity.Pacific/Rarotonga", "Раготонга" },
            { "timezone.excity.Pacific/Tongatapu", "Тонгатапу" },
            { "timezone.excity.Africa/Addis_Ababa", "Аддис-Абеба" },
            { "timezone.excity.Africa/Brazzaville", "Браззавилл" },
            { "timezone.excity.Africa/Ouagadougou", "Уагадугу" },
            { "timezone.excity.America/Costa_Rica", "Коста-Рика" },
            { "timezone.excity.America/Grand_Turk", "Гранд Түрк" },
            { "timezone.excity.America/Guadeloupe", "Гваделупе" },
            { "timezone.excity.America/Hermosillo", "Эрмосилло" },
            { "timezone.excity.America/Kralendijk", "Кралендейк" },
            { "timezone.excity.America/Louisville", "Луизвилл" },
            { "timezone.excity.America/Martinique", "Мартиник" },
            { "timezone.excity.America/Metlakatla", "Метлакатла" },
            { "timezone.excity.America/Montevideo", "Монтевидео" },
            { "timezone.excity.America/Montserrat", "Монсерат" },
            { "timezone.excity.America/Paramaribo", "Парамарибо" },
            { "timezone.excity.America/Rio_Branco", "Рио Бранко" },
            { "timezone.excity.America/St_Vincent", "Сент-Винсент" },
            { "timezone.excity.America/Whitehorse", "Уайтхорс" },
            { "timezone.excity.Antarctica/McMurdo", "МакМёрдо" },
            { "timezone.excity.Antarctica/Rothera", "Ротера" },
            { "timezone.excity.Asia/Srednekolymsk", "Среднеколымск" },
            { "timezone.excity.Asia/Yekaterinburg", "Екатеринбург" },
            { "timezone.excity.Atlantic/Reykjavik", "Рейкьявик" },
            { "timezone.excity.Atlantic/St_Helena", "Сент Елена" },
            { "timezone.excity.Australia/Adelaide", "Аделаида" },
            { "timezone.excity.Australia/Brisbane", "Брисбен" },
            { "timezone.excity.Australia/Lindeman", "Линдеман" },
            { "timezone.excity.Europe/Isle_of_Man", "Мэн аралы" },
            { "timezone.excity.Europe/Kaliningrad", "Калининград" },
            { "timezone.excity.Pacific/Kiritimati", "Киритимати" },
            { "timezone.excity.Africa/Johannesburg", "Йоханнесбург" },
            { "timezone.excity.America/El_Salvador", "Эл Салвадор" },
            { "timezone.excity.America/Fort_Nelson", "Форт Нельсон" },
            { "timezone.excity.America/Los_Angeles", "Лос-Анжелес" },
            { "timezone.excity.America/Mexico_City", "Мехико шаары" },
            { "timezone.excity.America/Porto_Velho", "Порто Велио" },
            { "timezone.excity.America/Puerto_Rico", "Пуэрто-Рико" },
            { "timezone.excity.America/Tegucigalpa", "Тегусигальпа" },
            { "timezone.excity.Arctic/Longyearbyen", "Лонгйербиен" },
            { "timezone.excity.Atlantic/Cape_Verde", "Капе Верде" },
            { "timezone.excity.Australia/Lord_Howe", "Лорд Хау" },
            { "timezone.excity.Australia/Melbourne", "Мельбурн" },
            { "timezone.excity.Indian/Antananarivo", "Антананариво" },
            { "timezone.excity.Pacific/Guadalcanal", "Гуадалканал" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Дар эс Салаам" },
            { "timezone.excity.America/Blanc-Sablon", "Бланк-Саблон" },
            { "timezone.excity.America/Buenos_Aires", "Буэнос-Айрес" },
            { "timezone.excity.America/Campo_Grande", "Кампо Гранде" },
            { "timezone.excity.America/Danmarkshavn", "Данмарксхавн" },
            { "timezone.excity.America/Dawson_Creek", "Доусон Грек" },
            { "timezone.excity.America/Indiana/Knox", "Нокс, Индиана" },
            { "timezone.excity.America/Indianapolis", "Индианаполис" },
            { "timezone.excity.America/Punta_Arenas", "Пунта-Аренас" },
            { "timezone.excity.America/Rankin_Inlet", "Рэнкин Инлет" },
            { "timezone.excity.America/Scoresbysund", "Иттоккортоормиит" },
            { "timezone.excity.Antarctica/Macquarie", "Маккуори" },
            { "timezone.excity.Pacific/Bougainville", "Бугенвиль" },
            { "timezone.excity.Pacific/Port_Moresby", "Порт Моэрсби" },
            { "timezone.excity.America/Cambridge_Bay", "Кэмбриж Бей" },
            { "timezone.excity.America/Ciudad_Juarez", "Сьюдад-Хуарес" },
            { "timezone.excity.America/Coral_Harbour", "Атикокан" },
            { "timezone.excity.America/Indiana/Vevay", "Вивей, Индиана" },
            { "timezone.excity.America/Lower_Princes", "Лоуэр Принсес Куате" },
            { "timezone.excity.America/Port_of_Spain", "Порт оф Спейн" },
            { "timezone.excity.America/Santo_Domingo", "Санто Доминго" },
            { "timezone.excity.America/St_Barthelemy", "Сент-Бартелеми" },
            { "timezone.excity.America/Swift_Current", "Свифт Каррент" },
            { "timezone.excity.Australia/Broken_Hill", "Броукен Хил" },
            { "timezone.excity.America/Bahia_Banderas", "Баийа Бандерас" },
            { "timezone.excity.America/Port-au-Prince", "Порт-о-Пренс" },
            { "timezone.excity.Atlantic/South_Georgia", "Түштүк Жоржия" },
            { "timezone.excity.America/Argentina/Salta", "Салта" },
            { "timezone.excity.America/Indiana/Marengo", "Маренго, Индиана" },
            { "timezone.excity.America/Indiana/Winamac", "Уинамак, Индиана" },
            { "timezone.excity.America/Argentina/Tucuman", "Тукуман" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ушуайа" },
            { "timezone.excity.America/Indiana/Tell_City", "Телл Сити, Индиана" },
            { "timezone.excity.America/Indiana/Vincennes", "Винсен, Индиана" },
            { "timezone.excity.Antarctica/DumontDUrville", "Дюмон д-Урвил" },
            { "timezone.excity.America/Argentina/La_Rioja", "Ла-Риоха" },
            { "timezone.excity.America/Argentina/San_Juan", "Сан Хуан" },
            { "timezone.excity.America/Argentina/San_Luis", "Сан Луи" },
            { "timezone.excity.America/Indiana/Petersburg", "Питерсбург, Индиана" },
            { "timezone.excity.America/Kentucky/Monticello", "Монтичелло, Кентукки" },
            { "timezone.excity.America/North_Dakota/Beulah", "Беула, Түндүк Дакота" },
            { "timezone.excity.America/North_Dakota/Center", "Түндүк Дакотанын борбору" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Рио Галлегос" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Нью-Салем, Түндүк Дакота" },
        };
        return data;
    }
}
