// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies a system-defined tool for the model to use. <i>System-defined tools</i> are tools that are created and provided by the model provider.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct SystemTool {
    /// <p>The name of the system-defined tool that you want to call.</p>
    pub name: ::std::string::String,
}
impl SystemTool {
    /// <p>The name of the system-defined tool that you want to call.</p>
    pub fn name(&self) -> &str {
        use std::ops::Deref;
        self.name.deref()
    }
}
impl SystemTool {
    /// Creates a new builder-style object to manufacture [`SystemTool`](crate::types::SystemTool).
    pub fn builder() -> crate::types::builders::SystemToolBuilder {
        crate::types::builders::SystemToolBuilder::default()
    }
}

/// A builder for [`SystemTool`](crate::types::SystemTool).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct SystemToolBuilder {
    pub(crate) name: ::std::option::Option<::std::string::String>,
}
impl SystemToolBuilder {
    /// <p>The name of the system-defined tool that you want to call.</p>
    /// This field is required.
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the system-defined tool that you want to call.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The name of the system-defined tool that you want to call.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// Consumes the builder and constructs a [`SystemTool`](crate::types::SystemTool).
    /// This method will fail if any of the following fields are not set:
    /// - [`name`](crate::types::builders::SystemToolBuilder::name)
    pub fn build(self) -> ::std::result::Result<crate::types::SystemTool, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::SystemTool {
            name: self.name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "name",
                    "name was not specified but it is required when building SystemTool",
                )
            })?,
        })
    }
}
