// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains the content of a document.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub enum DocumentSource {
    /// <p>The raw bytes for the document. If you use an Amazon Web Services SDK, you don't need to encode the bytes in base64.</p>
    Bytes(::aws_smithy_types::Blob),
    /// <p>The structured content of the document source, which may include various content blocks such as text, images, or other document elements.</p>
    Content(::std::vec::Vec<crate::types::DocumentContentBlock>),
    /// <p>The location of a document object in an Amazon S3 bucket. To see which models support S3 uploads, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/conversation-inference-supported-models-features.html">Supported models and features for Converse</a>.</p>
    S3Location(crate::types::S3Location),
    /// <p>The text content of the document source.</p>
    Text(::std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl DocumentSource {
    /// Tries to convert the enum instance into [`Bytes`](crate::types::DocumentSource::Bytes), extracting the inner [`Blob`](::aws_smithy_types::Blob).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_bytes(&self) -> ::std::result::Result<&::aws_smithy_types::Blob, &Self> {
        if let DocumentSource::Bytes(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Bytes`](crate::types::DocumentSource::Bytes).
    pub fn is_bytes(&self) -> bool {
        self.as_bytes().is_ok()
    }
    /// Tries to convert the enum instance into [`Content`](crate::types::DocumentSource::Content), extracting the inner [`Vec`](::std::vec::Vec).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_content(&self) -> ::std::result::Result<&::std::vec::Vec<crate::types::DocumentContentBlock>, &Self> {
        if let DocumentSource::Content(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Content`](crate::types::DocumentSource::Content).
    pub fn is_content(&self) -> bool {
        self.as_content().is_ok()
    }
    /// Tries to convert the enum instance into [`S3Location`](crate::types::DocumentSource::S3Location), extracting the inner [`S3Location`](crate::types::S3Location).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_s3_location(&self) -> ::std::result::Result<&crate::types::S3Location, &Self> {
        if let DocumentSource::S3Location(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`S3Location`](crate::types::DocumentSource::S3Location).
    pub fn is_s3_location(&self) -> bool {
        self.as_s3_location().is_ok()
    }
    /// Tries to convert the enum instance into [`Text`](crate::types::DocumentSource::Text), extracting the inner [`String`](::std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_text(&self) -> ::std::result::Result<&::std::string::String, &Self> {
        if let DocumentSource::Text(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Text`](crate::types::DocumentSource::Text).
    pub fn is_text(&self) -> bool {
        self.as_text().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
