// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package timestreamwriteiface provides an interface to enable mocking the Amazon Timestream Write service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package timestreamwriteiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/timestreamwrite"
)

// TimestreamWriteAPI provides an interface to enable mocking the
// timestreamwrite.TimestreamWrite service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Timestream Write.
//	func myFunc(svc timestreamwriteiface.TimestreamWriteAPI) bool {
//	    // Make svc.CreateBatchLoadTask request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := timestreamwrite.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockTimestreamWriteClient struct {
//	    timestreamwriteiface.TimestreamWriteAPI
//	}
//	func (m *mockTimestreamWriteClient) CreateBatchLoadTask(input *timestreamwrite.CreateBatchLoadTaskInput) (*timestreamwrite.CreateBatchLoadTaskOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockTimestreamWriteClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type TimestreamWriteAPI interface {
	CreateBatchLoadTask(*timestreamwrite.CreateBatchLoadTaskInput) (*timestreamwrite.CreateBatchLoadTaskOutput, error)
	CreateBatchLoadTaskWithContext(aws.Context, *timestreamwrite.CreateBatchLoadTaskInput, ...request.Option) (*timestreamwrite.CreateBatchLoadTaskOutput, error)
	CreateBatchLoadTaskRequest(*timestreamwrite.CreateBatchLoadTaskInput) (*request.Request, *timestreamwrite.CreateBatchLoadTaskOutput)

	CreateDatabase(*timestreamwrite.CreateDatabaseInput) (*timestreamwrite.CreateDatabaseOutput, error)
	CreateDatabaseWithContext(aws.Context, *timestreamwrite.CreateDatabaseInput, ...request.Option) (*timestreamwrite.CreateDatabaseOutput, error)
	CreateDatabaseRequest(*timestreamwrite.CreateDatabaseInput) (*request.Request, *timestreamwrite.CreateDatabaseOutput)

	CreateTable(*timestreamwrite.CreateTableInput) (*timestreamwrite.CreateTableOutput, error)
	CreateTableWithContext(aws.Context, *timestreamwrite.CreateTableInput, ...request.Option) (*timestreamwrite.CreateTableOutput, error)
	CreateTableRequest(*timestreamwrite.CreateTableInput) (*request.Request, *timestreamwrite.CreateTableOutput)

	DeleteDatabase(*timestreamwrite.DeleteDatabaseInput) (*timestreamwrite.DeleteDatabaseOutput, error)
	DeleteDatabaseWithContext(aws.Context, *timestreamwrite.DeleteDatabaseInput, ...request.Option) (*timestreamwrite.DeleteDatabaseOutput, error)
	DeleteDatabaseRequest(*timestreamwrite.DeleteDatabaseInput) (*request.Request, *timestreamwrite.DeleteDatabaseOutput)

	DeleteTable(*timestreamwrite.DeleteTableInput) (*timestreamwrite.DeleteTableOutput, error)
	DeleteTableWithContext(aws.Context, *timestreamwrite.DeleteTableInput, ...request.Option) (*timestreamwrite.DeleteTableOutput, error)
	DeleteTableRequest(*timestreamwrite.DeleteTableInput) (*request.Request, *timestreamwrite.DeleteTableOutput)

	DescribeBatchLoadTask(*timestreamwrite.DescribeBatchLoadTaskInput) (*timestreamwrite.DescribeBatchLoadTaskOutput, error)
	DescribeBatchLoadTaskWithContext(aws.Context, *timestreamwrite.DescribeBatchLoadTaskInput, ...request.Option) (*timestreamwrite.DescribeBatchLoadTaskOutput, error)
	DescribeBatchLoadTaskRequest(*timestreamwrite.DescribeBatchLoadTaskInput) (*request.Request, *timestreamwrite.DescribeBatchLoadTaskOutput)

	DescribeDatabase(*timestreamwrite.DescribeDatabaseInput) (*timestreamwrite.DescribeDatabaseOutput, error)
	DescribeDatabaseWithContext(aws.Context, *timestreamwrite.DescribeDatabaseInput, ...request.Option) (*timestreamwrite.DescribeDatabaseOutput, error)
	DescribeDatabaseRequest(*timestreamwrite.DescribeDatabaseInput) (*request.Request, *timestreamwrite.DescribeDatabaseOutput)

	DescribeEndpoints(*timestreamwrite.DescribeEndpointsInput) (*timestreamwrite.DescribeEndpointsOutput, error)
	DescribeEndpointsWithContext(aws.Context, *timestreamwrite.DescribeEndpointsInput, ...request.Option) (*timestreamwrite.DescribeEndpointsOutput, error)
	DescribeEndpointsRequest(*timestreamwrite.DescribeEndpointsInput) (*request.Request, *timestreamwrite.DescribeEndpointsOutput)

	DescribeTable(*timestreamwrite.DescribeTableInput) (*timestreamwrite.DescribeTableOutput, error)
	DescribeTableWithContext(aws.Context, *timestreamwrite.DescribeTableInput, ...request.Option) (*timestreamwrite.DescribeTableOutput, error)
	DescribeTableRequest(*timestreamwrite.DescribeTableInput) (*request.Request, *timestreamwrite.DescribeTableOutput)

	ListBatchLoadTasks(*timestreamwrite.ListBatchLoadTasksInput) (*timestreamwrite.ListBatchLoadTasksOutput, error)
	ListBatchLoadTasksWithContext(aws.Context, *timestreamwrite.ListBatchLoadTasksInput, ...request.Option) (*timestreamwrite.ListBatchLoadTasksOutput, error)
	ListBatchLoadTasksRequest(*timestreamwrite.ListBatchLoadTasksInput) (*request.Request, *timestreamwrite.ListBatchLoadTasksOutput)

	ListBatchLoadTasksPages(*timestreamwrite.ListBatchLoadTasksInput, func(*timestreamwrite.ListBatchLoadTasksOutput, bool) bool) error
	ListBatchLoadTasksPagesWithContext(aws.Context, *timestreamwrite.ListBatchLoadTasksInput, func(*timestreamwrite.ListBatchLoadTasksOutput, bool) bool, ...request.Option) error

	ListDatabases(*timestreamwrite.ListDatabasesInput) (*timestreamwrite.ListDatabasesOutput, error)
	ListDatabasesWithContext(aws.Context, *timestreamwrite.ListDatabasesInput, ...request.Option) (*timestreamwrite.ListDatabasesOutput, error)
	ListDatabasesRequest(*timestreamwrite.ListDatabasesInput) (*request.Request, *timestreamwrite.ListDatabasesOutput)

	ListDatabasesPages(*timestreamwrite.ListDatabasesInput, func(*timestreamwrite.ListDatabasesOutput, bool) bool) error
	ListDatabasesPagesWithContext(aws.Context, *timestreamwrite.ListDatabasesInput, func(*timestreamwrite.ListDatabasesOutput, bool) bool, ...request.Option) error

	ListTables(*timestreamwrite.ListTablesInput) (*timestreamwrite.ListTablesOutput, error)
	ListTablesWithContext(aws.Context, *timestreamwrite.ListTablesInput, ...request.Option) (*timestreamwrite.ListTablesOutput, error)
	ListTablesRequest(*timestreamwrite.ListTablesInput) (*request.Request, *timestreamwrite.ListTablesOutput)

	ListTablesPages(*timestreamwrite.ListTablesInput, func(*timestreamwrite.ListTablesOutput, bool) bool) error
	ListTablesPagesWithContext(aws.Context, *timestreamwrite.ListTablesInput, func(*timestreamwrite.ListTablesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*timestreamwrite.ListTagsForResourceInput) (*timestreamwrite.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *timestreamwrite.ListTagsForResourceInput, ...request.Option) (*timestreamwrite.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*timestreamwrite.ListTagsForResourceInput) (*request.Request, *timestreamwrite.ListTagsForResourceOutput)

	ResumeBatchLoadTask(*timestreamwrite.ResumeBatchLoadTaskInput) (*timestreamwrite.ResumeBatchLoadTaskOutput, error)
	ResumeBatchLoadTaskWithContext(aws.Context, *timestreamwrite.ResumeBatchLoadTaskInput, ...request.Option) (*timestreamwrite.ResumeBatchLoadTaskOutput, error)
	ResumeBatchLoadTaskRequest(*timestreamwrite.ResumeBatchLoadTaskInput) (*request.Request, *timestreamwrite.ResumeBatchLoadTaskOutput)

	TagResource(*timestreamwrite.TagResourceInput) (*timestreamwrite.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *timestreamwrite.TagResourceInput, ...request.Option) (*timestreamwrite.TagResourceOutput, error)
	TagResourceRequest(*timestreamwrite.TagResourceInput) (*request.Request, *timestreamwrite.TagResourceOutput)

	UntagResource(*timestreamwrite.UntagResourceInput) (*timestreamwrite.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *timestreamwrite.UntagResourceInput, ...request.Option) (*timestreamwrite.UntagResourceOutput, error)
	UntagResourceRequest(*timestreamwrite.UntagResourceInput) (*request.Request, *timestreamwrite.UntagResourceOutput)

	UpdateDatabase(*timestreamwrite.UpdateDatabaseInput) (*timestreamwrite.UpdateDatabaseOutput, error)
	UpdateDatabaseWithContext(aws.Context, *timestreamwrite.UpdateDatabaseInput, ...request.Option) (*timestreamwrite.UpdateDatabaseOutput, error)
	UpdateDatabaseRequest(*timestreamwrite.UpdateDatabaseInput) (*request.Request, *timestreamwrite.UpdateDatabaseOutput)

	UpdateTable(*timestreamwrite.UpdateTableInput) (*timestreamwrite.UpdateTableOutput, error)
	UpdateTableWithContext(aws.Context, *timestreamwrite.UpdateTableInput, ...request.Option) (*timestreamwrite.UpdateTableOutput, error)
	UpdateTableRequest(*timestreamwrite.UpdateTableInput) (*request.Request, *timestreamwrite.UpdateTableOutput)

	WriteRecords(*timestreamwrite.WriteRecordsInput) (*timestreamwrite.WriteRecordsOutput, error)
	WriteRecordsWithContext(aws.Context, *timestreamwrite.WriteRecordsInput, ...request.Option) (*timestreamwrite.WriteRecordsOutput, error)
	WriteRecordsRequest(*timestreamwrite.WriteRecordsInput) (*request.Request, *timestreamwrite.WriteRecordsOutput)
}

var _ TimestreamWriteAPI = (*timestreamwrite.TimestreamWrite)(nil)
