﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-agent/model/CachePointBlock.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace BedrockAgent {
namespace Model {

CachePointBlock::CachePointBlock(JsonView jsonValue) { *this = jsonValue; }

CachePointBlock& CachePointBlock::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("type")) {
    m_type = CachePointTypeMapper::GetCachePointTypeForName(jsonValue.GetString("type"));
    m_typeHasBeenSet = true;
  }
  return *this;
}

JsonValue CachePointBlock::Jsonize() const {
  JsonValue payload;

  if (m_typeHasBeenSet) {
    payload.WithString("type", CachePointTypeMapper::GetNameForCachePointType(m_type));
  }

  return payload;
}

}  // namespace Model
}  // namespace BedrockAgent
}  // namespace Aws
