﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/athena/model/DataCatalogSummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Athena {
namespace Model {
class ListDataCatalogsResult {
 public:
  AWS_ATHENA_API ListDataCatalogsResult() = default;
  AWS_ATHENA_API ListDataCatalogsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ATHENA_API ListDataCatalogsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A summary list of data catalogs.</p>
   */
  inline const Aws::Vector<DataCatalogSummary>& GetDataCatalogsSummary() const { return m_dataCatalogsSummary; }
  template <typename DataCatalogsSummaryT = Aws::Vector<DataCatalogSummary>>
  void SetDataCatalogsSummary(DataCatalogsSummaryT&& value) {
    m_dataCatalogsSummaryHasBeenSet = true;
    m_dataCatalogsSummary = std::forward<DataCatalogsSummaryT>(value);
  }
  template <typename DataCatalogsSummaryT = Aws::Vector<DataCatalogSummary>>
  ListDataCatalogsResult& WithDataCatalogsSummary(DataCatalogsSummaryT&& value) {
    SetDataCatalogsSummary(std::forward<DataCatalogsSummaryT>(value));
    return *this;
  }
  template <typename DataCatalogsSummaryT = DataCatalogSummary>
  ListDataCatalogsResult& AddDataCatalogsSummary(DataCatalogsSummaryT&& value) {
    m_dataCatalogsSummaryHasBeenSet = true;
    m_dataCatalogsSummary.emplace_back(std::forward<DataCatalogsSummaryT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token generated by the Athena service that specifies where to continue
   * pagination if a previous request was truncated. To obtain the next set of pages,
   * pass in the NextToken from the response object of the previous page call.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListDataCatalogsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListDataCatalogsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<DataCatalogSummary> m_dataCatalogsSummary;
  bool m_dataCatalogsSummaryHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Athena
}  // namespace Aws
