﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/appfabric/model/IngestionState.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace AppFabric {
namespace Model {
namespace IngestionStateMapper {

static const int enabled_HASH = HashingUtils::HashString("enabled");
static const int disabled_HASH = HashingUtils::HashString("disabled");

IngestionState GetIngestionStateForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == enabled_HASH) {
    return IngestionState::enabled;
  } else if (hashCode == disabled_HASH) {
    return IngestionState::disabled;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<IngestionState>(hashCode);
  }

  return IngestionState::NOT_SET;
}

Aws::String GetNameForIngestionState(IngestionState enumValue) {
  switch (enumValue) {
    case IngestionState::NOT_SET:
      return {};
    case IngestionState::enabled:
      return "enabled";
    case IngestionState::disabled:
      return "disabled";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace IngestionStateMapper
}  // namespace Model
}  // namespace AppFabric
}  // namespace Aws
