--TEST--
bcsub() function with large numbers
--EXTENSIONS--
bcmath
--INI--
bcmath.scale=0
--FILE--
<?php
require(__DIR__ . "/run_bcmath_tests_function.inc");

$minuends = [
    "15151324141414.412312232141241",
    "-132132245132134.1515123765412",
    "141241241241241248267654747412",
    "-149143276547656984948124912",
    "0.1322135476547459213732911312",
    "-0.123912932193769965476541321",
];
$subtrahends = array_merge($minuends, [
    "0",
    "0.00",
    "-0",
    "-0.00",
    "15",
    "-15",
    "1",
    "-9",
    "14.14",
    "-16.60",
    "0.15",
    "-0.01",
]);

run_bcmath_tests($minuends, $subtrahends, "-", bcsub(...));

?>
--EXPECT--
Number "15151324141414.412312232141241" (scale 0)
15151324141414.412312232141241 - 15151324141414.412312232141241 = 0
15151324141414.412312232141241 - -132132245132134.1515123765412 = 147283569273548
15151324141414.412312232141241 - 141241241241241248267654747412 = -141241241241241233116330605997
15151324141414.412312232141241 - -149143276547656984948124912   = 149143276547672136272266326
15151324141414.412312232141241 - 0.1322135476547459213732911312 = 15151324141414
15151324141414.412312232141241 - -0.123912932193769965476541321 = 15151324141414
15151324141414.412312232141241 - 0                              = 15151324141414
15151324141414.412312232141241 - 0.00                           = 15151324141414
15151324141414.412312232141241 - -0                             = 15151324141414
15151324141414.412312232141241 - -0.00                          = 15151324141414
15151324141414.412312232141241 - 15                             = 15151324141399
15151324141414.412312232141241 - -15                            = 15151324141429
15151324141414.412312232141241 - 1                              = 15151324141413
15151324141414.412312232141241 - -9                             = 15151324141423
15151324141414.412312232141241 - 14.14                          = 15151324141400
15151324141414.412312232141241 - -16.60                         = 15151324141431
15151324141414.412312232141241 - 0.15                           = 15151324141414
15151324141414.412312232141241 - -0.01                          = 15151324141414

Number "-132132245132134.1515123765412" (scale 0)
-132132245132134.1515123765412 - 15151324141414.412312232141241 = -147283569273548
-132132245132134.1515123765412 - -132132245132134.1515123765412 = 0
-132132245132134.1515123765412 - 141241241241241248267654747412 = -141241241241241380399899879546
-132132245132134.1515123765412 - -149143276547656984948124912   = 149143276547524852702992777
-132132245132134.1515123765412 - 0.1322135476547459213732911312 = -132132245132134
-132132245132134.1515123765412 - -0.123912932193769965476541321 = -132132245132134
-132132245132134.1515123765412 - 0                              = -132132245132134
-132132245132134.1515123765412 - 0.00                           = -132132245132134
-132132245132134.1515123765412 - -0                             = -132132245132134
-132132245132134.1515123765412 - -0.00                          = -132132245132134
-132132245132134.1515123765412 - 15                             = -132132245132149
-132132245132134.1515123765412 - -15                            = -132132245132119
-132132245132134.1515123765412 - 1                              = -132132245132135
-132132245132134.1515123765412 - -9                             = -132132245132125
-132132245132134.1515123765412 - 14.14                          = -132132245132148
-132132245132134.1515123765412 - -16.60                         = -132132245132117
-132132245132134.1515123765412 - 0.15                           = -132132245132134
-132132245132134.1515123765412 - -0.01                          = -132132245132134

Number "141241241241241248267654747412" (scale 0)
141241241241241248267654747412 - 15151324141414.412312232141241 = 141241241241241233116330605997
141241241241241248267654747412 - -132132245132134.1515123765412 = 141241241241241380399899879546
141241241241241248267654747412 - 141241241241241248267654747412 = 0
141241241241241248267654747412 - -149143276547656984948124912   = 141390384517788905252602872324
141241241241241248267654747412 - 0.1322135476547459213732911312 = 141241241241241248267654747411
141241241241241248267654747412 - -0.123912932193769965476541321 = 141241241241241248267654747412
141241241241241248267654747412 - 0                              = 141241241241241248267654747412
141241241241241248267654747412 - 0.00                           = 141241241241241248267654747412
141241241241241248267654747412 - -0                             = 141241241241241248267654747412
141241241241241248267654747412 - -0.00                          = 141241241241241248267654747412
141241241241241248267654747412 - 15                             = 141241241241241248267654747397
141241241241241248267654747412 - -15                            = 141241241241241248267654747427
141241241241241248267654747412 - 1                              = 141241241241241248267654747411
141241241241241248267654747412 - -9                             = 141241241241241248267654747421
141241241241241248267654747412 - 14.14                          = 141241241241241248267654747397
141241241241241248267654747412 - -16.60                         = 141241241241241248267654747428
141241241241241248267654747412 - 0.15                           = 141241241241241248267654747411
141241241241241248267654747412 - -0.01                          = 141241241241241248267654747412

Number "-149143276547656984948124912" (scale 0)
-149143276547656984948124912 - 15151324141414.412312232141241 = -149143276547672136272266326
-149143276547656984948124912 - -132132245132134.1515123765412 = -149143276547524852702992777
-149143276547656984948124912 - 141241241241241248267654747412 = -141390384517788905252602872324
-149143276547656984948124912 - -149143276547656984948124912   = 0
-149143276547656984948124912 - 0.1322135476547459213732911312 = -149143276547656984948124912
-149143276547656984948124912 - -0.123912932193769965476541321 = -149143276547656984948124911
-149143276547656984948124912 - 0                              = -149143276547656984948124912
-149143276547656984948124912 - 0.00                           = -149143276547656984948124912
-149143276547656984948124912 - -0                             = -149143276547656984948124912
-149143276547656984948124912 - -0.00                          = -149143276547656984948124912
-149143276547656984948124912 - 15                             = -149143276547656984948124927
-149143276547656984948124912 - -15                            = -149143276547656984948124897
-149143276547656984948124912 - 1                              = -149143276547656984948124913
-149143276547656984948124912 - -9                             = -149143276547656984948124903
-149143276547656984948124912 - 14.14                          = -149143276547656984948124926
-149143276547656984948124912 - -16.60                         = -149143276547656984948124895
-149143276547656984948124912 - 0.15                           = -149143276547656984948124912
-149143276547656984948124912 - -0.01                          = -149143276547656984948124911

Number "0.1322135476547459213732911312" (scale 0)
0.1322135476547459213732911312 - 15151324141414.412312232141241 = -15151324141414
0.1322135476547459213732911312 - -132132245132134.1515123765412 = 132132245132134
0.1322135476547459213732911312 - 141241241241241248267654747412 = -141241241241241248267654747411
0.1322135476547459213732911312 - -149143276547656984948124912   = 149143276547656984948124912
0.1322135476547459213732911312 - 0.1322135476547459213732911312 = 0
0.1322135476547459213732911312 - -0.123912932193769965476541321 = 0
0.1322135476547459213732911312 - 0                              = 0
0.1322135476547459213732911312 - 0.00                           = 0
0.1322135476547459213732911312 - -0                             = 0
0.1322135476547459213732911312 - -0.00                          = 0
0.1322135476547459213732911312 - 15                             = -14
0.1322135476547459213732911312 - -15                            = 15
0.1322135476547459213732911312 - 1                              = 0
0.1322135476547459213732911312 - -9                             = 9
0.1322135476547459213732911312 - 14.14                          = -14
0.1322135476547459213732911312 - -16.60                         = 16
0.1322135476547459213732911312 - 0.15                           = 0
0.1322135476547459213732911312 - -0.01                          = 0

Number "-0.123912932193769965476541321" (scale 0)
-0.123912932193769965476541321 - 15151324141414.412312232141241 = -15151324141414
-0.123912932193769965476541321 - -132132245132134.1515123765412 = 132132245132134
-0.123912932193769965476541321 - 141241241241241248267654747412 = -141241241241241248267654747412
-0.123912932193769965476541321 - -149143276547656984948124912   = 149143276547656984948124911
-0.123912932193769965476541321 - 0.1322135476547459213732911312 = 0
-0.123912932193769965476541321 - -0.123912932193769965476541321 = 0
-0.123912932193769965476541321 - 0                              = 0
-0.123912932193769965476541321 - 0.00                           = 0
-0.123912932193769965476541321 - -0                             = 0
-0.123912932193769965476541321 - -0.00                          = 0
-0.123912932193769965476541321 - 15                             = -15
-0.123912932193769965476541321 - -15                            = 14
-0.123912932193769965476541321 - 1                              = -1
-0.123912932193769965476541321 - -9                             = 8
-0.123912932193769965476541321 - 14.14                          = -14
-0.123912932193769965476541321 - -16.60                         = 16
-0.123912932193769965476541321 - 0.15                           = 0
-0.123912932193769965476541321 - -0.01                          = 0

Number "15151324141414.412312232141241" (scale 10)
15151324141414.412312232141241 - 15151324141414.412312232141241 = 0.0000000000
15151324141414.412312232141241 - -132132245132134.1515123765412 = 147283569273548.5638246086
15151324141414.412312232141241 - 141241241241241248267654747412 = -141241241241241233116330605997.5876877678
15151324141414.412312232141241 - -149143276547656984948124912   = 149143276547672136272266326.4123122321
15151324141414.412312232141241 - 0.1322135476547459213732911312 = 15151324141414.2800986844
15151324141414.412312232141241 - -0.123912932193769965476541321 = 15151324141414.5362251643
15151324141414.412312232141241 - 0                              = 15151324141414.4123122321
15151324141414.412312232141241 - 0.00                           = 15151324141414.4123122321
15151324141414.412312232141241 - -0                             = 15151324141414.4123122321
15151324141414.412312232141241 - -0.00                          = 15151324141414.4123122321
15151324141414.412312232141241 - 15                             = 15151324141399.4123122321
15151324141414.412312232141241 - -15                            = 15151324141429.4123122321
15151324141414.412312232141241 - 1                              = 15151324141413.4123122321
15151324141414.412312232141241 - -9                             = 15151324141423.4123122321
15151324141414.412312232141241 - 14.14                          = 15151324141400.2723122321
15151324141414.412312232141241 - -16.60                         = 15151324141431.0123122321
15151324141414.412312232141241 - 0.15                           = 15151324141414.2623122321
15151324141414.412312232141241 - -0.01                          = 15151324141414.4223122321

Number "-132132245132134.1515123765412" (scale 10)
-132132245132134.1515123765412 - 15151324141414.412312232141241 = -147283569273548.5638246086
-132132245132134.1515123765412 - -132132245132134.1515123765412 = 0.0000000000
-132132245132134.1515123765412 - 141241241241241248267654747412 = -141241241241241380399899879546.1515123765
-132132245132134.1515123765412 - -149143276547656984948124912   = 149143276547524852702992777.8484876234
-132132245132134.1515123765412 - 0.1322135476547459213732911312 = -132132245132134.2837259241
-132132245132134.1515123765412 - -0.123912932193769965476541321 = -132132245132134.0275994443
-132132245132134.1515123765412 - 0                              = -132132245132134.1515123765
-132132245132134.1515123765412 - 0.00                           = -132132245132134.1515123765
-132132245132134.1515123765412 - -0                             = -132132245132134.1515123765
-132132245132134.1515123765412 - -0.00                          = -132132245132134.1515123765
-132132245132134.1515123765412 - 15                             = -132132245132149.1515123765
-132132245132134.1515123765412 - -15                            = -132132245132119.1515123765
-132132245132134.1515123765412 - 1                              = -132132245132135.1515123765
-132132245132134.1515123765412 - -9                             = -132132245132125.1515123765
-132132245132134.1515123765412 - 14.14                          = -132132245132148.2915123765
-132132245132134.1515123765412 - -16.60                         = -132132245132117.5515123765
-132132245132134.1515123765412 - 0.15                           = -132132245132134.3015123765
-132132245132134.1515123765412 - -0.01                          = -132132245132134.1415123765

Number "141241241241241248267654747412" (scale 10)
141241241241241248267654747412 - 15151324141414.412312232141241 = 141241241241241233116330605997.5876877678
141241241241241248267654747412 - -132132245132134.1515123765412 = 141241241241241380399899879546.1515123765
141241241241241248267654747412 - 141241241241241248267654747412 = 0.0000000000
141241241241241248267654747412 - -149143276547656984948124912   = 141390384517788905252602872324.0000000000
141241241241241248267654747412 - 0.1322135476547459213732911312 = 141241241241241248267654747411.8677864523
141241241241241248267654747412 - -0.123912932193769965476541321 = 141241241241241248267654747412.1239129321
141241241241241248267654747412 - 0                              = 141241241241241248267654747412.0000000000
141241241241241248267654747412 - 0.00                           = 141241241241241248267654747412.0000000000
141241241241241248267654747412 - -0                             = 141241241241241248267654747412.0000000000
141241241241241248267654747412 - -0.00                          = 141241241241241248267654747412.0000000000
141241241241241248267654747412 - 15                             = 141241241241241248267654747397.0000000000
141241241241241248267654747412 - -15                            = 141241241241241248267654747427.0000000000
141241241241241248267654747412 - 1                              = 141241241241241248267654747411.0000000000
141241241241241248267654747412 - -9                             = 141241241241241248267654747421.0000000000
141241241241241248267654747412 - 14.14                          = 141241241241241248267654747397.8600000000
141241241241241248267654747412 - -16.60                         = 141241241241241248267654747428.6000000000
141241241241241248267654747412 - 0.15                           = 141241241241241248267654747411.8500000000
141241241241241248267654747412 - -0.01                          = 141241241241241248267654747412.0100000000

Number "-149143276547656984948124912" (scale 10)
-149143276547656984948124912 - 15151324141414.412312232141241 = -149143276547672136272266326.4123122321
-149143276547656984948124912 - -132132245132134.1515123765412 = -149143276547524852702992777.8484876234
-149143276547656984948124912 - 141241241241241248267654747412 = -141390384517788905252602872324.0000000000
-149143276547656984948124912 - -149143276547656984948124912   = 0.0000000000
-149143276547656984948124912 - 0.1322135476547459213732911312 = -149143276547656984948124912.1322135476
-149143276547656984948124912 - -0.123912932193769965476541321 = -149143276547656984948124911.8760870678
-149143276547656984948124912 - 0                              = -149143276547656984948124912.0000000000
-149143276547656984948124912 - 0.00                           = -149143276547656984948124912.0000000000
-149143276547656984948124912 - -0                             = -149143276547656984948124912.0000000000
-149143276547656984948124912 - -0.00                          = -149143276547656984948124912.0000000000
-149143276547656984948124912 - 15                             = -149143276547656984948124927.0000000000
-149143276547656984948124912 - -15                            = -149143276547656984948124897.0000000000
-149143276547656984948124912 - 1                              = -149143276547656984948124913.0000000000
-149143276547656984948124912 - -9                             = -149143276547656984948124903.0000000000
-149143276547656984948124912 - 14.14                          = -149143276547656984948124926.1400000000
-149143276547656984948124912 - -16.60                         = -149143276547656984948124895.4000000000
-149143276547656984948124912 - 0.15                           = -149143276547656984948124912.1500000000
-149143276547656984948124912 - -0.01                          = -149143276547656984948124911.9900000000

Number "0.1322135476547459213732911312" (scale 10)
0.1322135476547459213732911312 - 15151324141414.412312232141241 = -15151324141414.2800986844
0.1322135476547459213732911312 - -132132245132134.1515123765412 = 132132245132134.2837259241
0.1322135476547459213732911312 - 141241241241241248267654747412 = -141241241241241248267654747411.8677864523
0.1322135476547459213732911312 - -149143276547656984948124912   = 149143276547656984948124912.1322135476
0.1322135476547459213732911312 - 0.1322135476547459213732911312 = 0.0000000000
0.1322135476547459213732911312 - -0.123912932193769965476541321 = 0.2561264798
0.1322135476547459213732911312 - 0                              = 0.1322135476
0.1322135476547459213732911312 - 0.00                           = 0.1322135476
0.1322135476547459213732911312 - -0                             = 0.1322135476
0.1322135476547459213732911312 - -0.00                          = 0.1322135476
0.1322135476547459213732911312 - 15                             = -14.8677864523
0.1322135476547459213732911312 - -15                            = 15.1322135476
0.1322135476547459213732911312 - 1                              = -0.8677864523
0.1322135476547459213732911312 - -9                             = 9.1322135476
0.1322135476547459213732911312 - 14.14                          = -14.0077864523
0.1322135476547459213732911312 - -16.60                         = 16.7322135476
0.1322135476547459213732911312 - 0.15                           = -0.0177864523
0.1322135476547459213732911312 - -0.01                          = 0.1422135476

Number "-0.123912932193769965476541321" (scale 10)
-0.123912932193769965476541321 - 15151324141414.412312232141241 = -15151324141414.5362251643
-0.123912932193769965476541321 - -132132245132134.1515123765412 = 132132245132134.0275994443
-0.123912932193769965476541321 - 141241241241241248267654747412 = -141241241241241248267654747412.1239129321
-0.123912932193769965476541321 - -149143276547656984948124912   = 149143276547656984948124911.8760870678
-0.123912932193769965476541321 - 0.1322135476547459213732911312 = -0.2561264798
-0.123912932193769965476541321 - -0.123912932193769965476541321 = 0.0000000000
-0.123912932193769965476541321 - 0                              = -0.1239129321
-0.123912932193769965476541321 - 0.00                           = -0.1239129321
-0.123912932193769965476541321 - -0                             = -0.1239129321
-0.123912932193769965476541321 - -0.00                          = -0.1239129321
-0.123912932193769965476541321 - 15                             = -15.1239129321
-0.123912932193769965476541321 - -15                            = 14.8760870678
-0.123912932193769965476541321 - 1                              = -1.1239129321
-0.123912932193769965476541321 - -9                             = 8.8760870678
-0.123912932193769965476541321 - 14.14                          = -14.2639129321
-0.123912932193769965476541321 - -16.60                         = 16.4760870678
-0.123912932193769965476541321 - 0.15                           = -0.2739129321
-0.123912932193769965476541321 - -0.01                          = -0.1139129321
