//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdragoperation?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSDragOperation(pub NSUInteger);
bitflags::bitflags! {
    impl NSDragOperation: NSUInteger {
        #[doc(alias = "NSDragOperationNone")]
        const None = 0;
        #[doc(alias = "NSDragOperationCopy")]
        const Copy = 1;
        #[doc(alias = "NSDragOperationLink")]
        const Link = 2;
        #[doc(alias = "NSDragOperationGeneric")]
        const Generic = 4;
        #[doc(alias = "NSDragOperationPrivate")]
        const Private = 8;
        #[doc(alias = "NSDragOperationMove")]
        const Move = 16;
        #[doc(alias = "NSDragOperationDelete")]
        const Delete = 32;
        #[doc(alias = "NSDragOperationEvery")]
        const Every = NSUIntegerMax as _;
        #[doc(alias = "NSDragOperationAll_Obsolete")]
#[deprecated]
        const All_Obsolete = 15;
        #[doc(alias = "NSDragOperationAll")]
#[deprecated]
        const All = NSDragOperation::All_Obsolete.0;
    }
}

unsafe impl Encode for NSDragOperation {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSDragOperation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdraggingformation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSDraggingFormation(pub NSInteger);
impl NSDraggingFormation {
    #[doc(alias = "NSDraggingFormationDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "NSDraggingFormationNone")]
    pub const None: Self = Self(1);
    #[doc(alias = "NSDraggingFormationPile")]
    pub const Pile: Self = Self(2);
    #[doc(alias = "NSDraggingFormationList")]
    pub const List: Self = Self(3);
    #[doc(alias = "NSDraggingFormationStack")]
    pub const Stack: Self = Self(4);
}

unsafe impl Encode for NSDraggingFormation {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSDraggingFormation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdraggingcontext?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSDraggingContext(pub NSInteger);
impl NSDraggingContext {
    #[doc(alias = "NSDraggingContextOutsideApplication")]
    pub const OutsideApplication: Self = Self(0);
    #[doc(alias = "NSDraggingContextWithinApplication")]
    pub const WithinApplication: Self = Self(1);
}

unsafe impl Encode for NSDraggingContext {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSDraggingContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdraggingitemenumerationoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSDraggingItemEnumerationOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSDraggingItemEnumerationOptions: NSUInteger {
        #[doc(alias = "NSDraggingItemEnumerationConcurrent")]
        const Concurrent = NSEnumerationOptions::Concurrent.0;
        #[doc(alias = "NSDraggingItemEnumerationClearNonenumeratedImages")]
        const ClearNonenumeratedImages = 1<<16;
    }
}

unsafe impl Encode for NSDraggingItemEnumerationOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSDraggingItemEnumerationOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsspringloadinghighlight?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSSpringLoadingHighlight(pub NSInteger);
impl NSSpringLoadingHighlight {
    #[doc(alias = "NSSpringLoadingHighlightNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "NSSpringLoadingHighlightStandard")]
    pub const Standard: Self = Self(1);
    #[doc(alias = "NSSpringLoadingHighlightEmphasized")]
    pub const Emphasized: Self = Self(2);
}

unsafe impl Encode for NSSpringLoadingHighlight {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSSpringLoadingHighlight {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdragginginfo?language=objc)
    pub unsafe trait NSDraggingInfo: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(feature = "NSResponder", feature = "NSWindow"))]
        #[unsafe(method(draggingDestinationWindow))]
        #[unsafe(method_family = none)]
        fn draggingDestinationWindow(&self) -> Option<Retained<NSWindow>>;

        #[unsafe(method(draggingSourceOperationMask))]
        #[unsafe(method_family = none)]
        fn draggingSourceOperationMask(&self) -> NSDragOperation;

        #[unsafe(method(draggingLocation))]
        #[unsafe(method_family = none)]
        fn draggingLocation(&self) -> NSPoint;

        #[unsafe(method(draggedImageLocation))]
        #[unsafe(method_family = none)]
        fn draggedImageLocation(&self) -> NSPoint;

        #[cfg(feature = "NSImage")]
        #[deprecated = "Use NSDraggingItem objects instead"]
        #[unsafe(method(draggedImage))]
        #[unsafe(method_family = none)]
        fn draggedImage(&self) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(draggingPasteboard))]
        #[unsafe(method_family = none)]
        fn draggingPasteboard(&self) -> Retained<NSPasteboard>;

        #[unsafe(method(draggingSource))]
        #[unsafe(method_family = none)]
        fn draggingSource(&self) -> Option<Retained<AnyObject>>;

        #[unsafe(method(draggingSequenceNumber))]
        #[unsafe(method_family = none)]
        fn draggingSequenceNumber(&self) -> NSInteger;

        #[unsafe(method(slideDraggedImageTo:))]
        #[unsafe(method_family = none)]
        fn slideDraggedImageTo(&self, screen_point: NSPoint);

        #[deprecated = "Use NSFilePromiseReceiver objects instead"]
        #[unsafe(method(namesOfPromisedFilesDroppedAtDestination:))]
        #[unsafe(method_family = none)]
        fn namesOfPromisedFilesDroppedAtDestination(
            &self,
            drop_destination: &NSURL,
        ) -> Option<Retained<NSArray<NSString>>>;

        #[unsafe(method(draggingFormation))]
        #[unsafe(method_family = none)]
        fn draggingFormation(&self) -> NSDraggingFormation;

        /// Setter for [`draggingFormation`][Self::draggingFormation].
        #[unsafe(method(setDraggingFormation:))]
        #[unsafe(method_family = none)]
        fn setDraggingFormation(&self, dragging_formation: NSDraggingFormation);

        #[unsafe(method(animatesToDestination))]
        #[unsafe(method_family = none)]
        fn animatesToDestination(&self) -> bool;

        /// Setter for [`animatesToDestination`][Self::animatesToDestination].
        #[unsafe(method(setAnimatesToDestination:))]
        #[unsafe(method_family = none)]
        fn setAnimatesToDestination(&self, animates_to_destination: bool);

        #[unsafe(method(numberOfValidItemsForDrop))]
        #[unsafe(method_family = none)]
        fn numberOfValidItemsForDrop(&self) -> NSInteger;

        /// Setter for [`numberOfValidItemsForDrop`][Self::numberOfValidItemsForDrop].
        #[unsafe(method(setNumberOfValidItemsForDrop:))]
        #[unsafe(method_family = none)]
        fn setNumberOfValidItemsForDrop(&self, number_of_valid_items_for_drop: NSInteger);

        #[cfg(all(
            feature = "NSDraggingItem",
            feature = "NSPasteboard",
            feature = "NSResponder",
            feature = "NSView",
            feature = "block2"
        ))]
        /// # Safety
        ///
        /// - `class_array` generic probably has further requirements.
        /// - `search_options` generic should be of the correct type.
        #[unsafe(method(enumerateDraggingItemsWithOptions:forView:classes:searchOptions:usingBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn enumerateDraggingItemsWithOptions_forView_classes_searchOptions_usingBlock(
            &self,
            enum_opts: NSDraggingItemEnumerationOptions,
            view: Option<&NSView>,
            class_array: &NSArray<AnyClass>,
            search_options: &NSDictionary<NSPasteboardReadingOptionKey, AnyObject>,
            block: &block2::DynBlock<dyn Fn(NonNull<NSDraggingItem>, NSInteger, NonNull<Bool>)>,
        );

        #[unsafe(method(springLoadingHighlight))]
        #[unsafe(method_family = none)]
        fn springLoadingHighlight(&self) -> NSSpringLoadingHighlight;

        #[unsafe(method(resetSpringLoading))]
        #[unsafe(method_family = none)]
        fn resetSpringLoading(&self);
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdraggingdestination?language=objc)
    pub unsafe trait NSDraggingDestination: NSObjectProtocol + MainThreadOnly {
        #[optional]
        #[unsafe(method(draggingEntered:))]
        #[unsafe(method_family = none)]
        fn draggingEntered(&self, sender: &ProtocolObject<dyn NSDraggingInfo>) -> NSDragOperation;

        #[optional]
        #[unsafe(method(draggingUpdated:))]
        #[unsafe(method_family = none)]
        fn draggingUpdated(&self, sender: &ProtocolObject<dyn NSDraggingInfo>) -> NSDragOperation;

        #[optional]
        #[unsafe(method(draggingExited:))]
        #[unsafe(method_family = none)]
        fn draggingExited(&self, sender: Option<&ProtocolObject<dyn NSDraggingInfo>>);

        #[optional]
        #[unsafe(method(prepareForDragOperation:))]
        #[unsafe(method_family = none)]
        fn prepareForDragOperation(&self, sender: &ProtocolObject<dyn NSDraggingInfo>) -> bool;

        #[optional]
        #[unsafe(method(performDragOperation:))]
        #[unsafe(method_family = none)]
        fn performDragOperation(&self, sender: &ProtocolObject<dyn NSDraggingInfo>) -> bool;

        #[optional]
        #[unsafe(method(concludeDragOperation:))]
        #[unsafe(method_family = none)]
        fn concludeDragOperation(&self, sender: Option<&ProtocolObject<dyn NSDraggingInfo>>);

        #[optional]
        #[unsafe(method(draggingEnded:))]
        #[unsafe(method_family = none)]
        fn draggingEnded(&self, sender: &ProtocolObject<dyn NSDraggingInfo>);

        #[optional]
        #[unsafe(method(wantsPeriodicDraggingUpdates))]
        #[unsafe(method_family = none)]
        fn wantsPeriodicDraggingUpdates(&self) -> bool;

        #[optional]
        #[unsafe(method(updateDraggingItemsForDrag:))]
        #[unsafe(method_family = none)]
        fn updateDraggingItemsForDrag(&self, sender: Option<&ProtocolObject<dyn NSDraggingInfo>>);
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsdraggingsource?language=objc)
    pub unsafe trait NSDraggingSource: NSObjectProtocol + MainThreadOnly {
        #[cfg(feature = "NSDraggingSession")]
        #[unsafe(method(draggingSession:sourceOperationMaskForDraggingContext:))]
        #[unsafe(method_family = none)]
        fn draggingSession_sourceOperationMaskForDraggingContext(
            &self,
            session: &NSDraggingSession,
            context: NSDraggingContext,
        ) -> NSDragOperation;

        #[cfg(feature = "NSDraggingSession")]
        #[optional]
        #[unsafe(method(draggingSession:willBeginAtPoint:))]
        #[unsafe(method_family = none)]
        fn draggingSession_willBeginAtPoint(
            &self,
            session: &NSDraggingSession,
            screen_point: NSPoint,
        );

        #[cfg(feature = "NSDraggingSession")]
        #[optional]
        #[unsafe(method(draggingSession:movedToPoint:))]
        #[unsafe(method_family = none)]
        fn draggingSession_movedToPoint(&self, session: &NSDraggingSession, screen_point: NSPoint);

        #[cfg(feature = "NSDraggingSession")]
        #[optional]
        #[unsafe(method(draggingSession:endedAtPoint:operation:))]
        #[unsafe(method_family = none)]
        fn draggingSession_endedAtPoint_operation(
            &self,
            session: &NSDraggingSession,
            screen_point: NSPoint,
            operation: NSDragOperation,
        );

        #[cfg(feature = "NSDraggingSession")]
        #[optional]
        #[unsafe(method(ignoreModifierKeysForDraggingSession:))]
        #[unsafe(method_family = none)]
        fn ignoreModifierKeysForDraggingSession(&self, session: &NSDraggingSession) -> bool;
    }
);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsspringloadingoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSSpringLoadingOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSSpringLoadingOptions: NSUInteger {
        #[doc(alias = "NSSpringLoadingDisabled")]
        const Disabled = 0;
        #[doc(alias = "NSSpringLoadingEnabled")]
        const Enabled = 1<<0;
        #[doc(alias = "NSSpringLoadingContinuousActivation")]
        const ContinuousActivation = 1<<1;
        #[doc(alias = "NSSpringLoadingNoHover")]
        const NoHover = 1<<3;
    }
}

unsafe impl Encode for NSSpringLoadingOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSSpringLoadingOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsspringloadingdestination?language=objc)
    pub unsafe trait NSSpringLoadingDestination: NSObjectProtocol + MainThreadOnly {
        #[unsafe(method(springLoadingActivated:draggingInfo:))]
        #[unsafe(method_family = none)]
        fn springLoadingActivated_draggingInfo(
            &self,
            activated: bool,
            dragging_info: &ProtocolObject<dyn NSDraggingInfo>,
        );

        #[unsafe(method(springLoadingHighlightChanged:))]
        #[unsafe(method_family = none)]
        fn springLoadingHighlightChanged(&self, dragging_info: &ProtocolObject<dyn NSDraggingInfo>);

        #[optional]
        #[unsafe(method(springLoadingEntered:))]
        #[unsafe(method_family = none)]
        fn springLoadingEntered(
            &self,
            dragging_info: &ProtocolObject<dyn NSDraggingInfo>,
        ) -> NSSpringLoadingOptions;

        #[optional]
        #[unsafe(method(springLoadingUpdated:))]
        #[unsafe(method_family = none)]
        fn springLoadingUpdated(
            &self,
            dragging_info: &ProtocolObject<dyn NSDraggingInfo>,
        ) -> NSSpringLoadingOptions;

        #[optional]
        #[unsafe(method(springLoadingExited:))]
        #[unsafe(method_family = none)]
        fn springLoadingExited(&self, dragging_info: &ProtocolObject<dyn NSDraggingInfo>);

        #[optional]
        #[unsafe(method(draggingEnded:))]
        #[unsafe(method_family = none)]
        fn draggingEnded(&self, dragging_info: &ProtocolObject<dyn NSDraggingInfo>);
    }
);
