// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func CopyOrigFunctionSlice(dest, src []*otlpprofiles.Function) []*otlpprofiles.Function {
	var newDest []*otlpprofiles.Function
	if cap(dest) < len(src) {
		newDest = make([]*otlpprofiles.Function, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigFunction()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigFunction(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigFunction()
		}
	}
	for i := range src {
		CopyOrigFunction(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestFunctionSlice() []*otlpprofiles.Function {
	orig := make([]*otlpprofiles.Function, 5)
	orig[0] = NewOrigFunction()
	orig[1] = GenTestOrigFunction()
	orig[2] = NewOrigFunction()
	orig[3] = GenTestOrigFunction()
	orig[4] = NewOrigFunction()
	return orig
}
