// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
)

type Slice struct {
	orig  *[]otlpcommon.AnyValue
	state *State
}

func GetOrigSlice(ms Slice) *[]otlpcommon.AnyValue {
	return ms.orig
}

func GetSliceState(ms Slice) *State {
	return ms.state
}

func NewSlice(orig *[]otlpcommon.AnyValue, state *State) Slice {
	return Slice{orig: orig, state: state}
}

func GenerateTestSlice() Slice {
	orig := GenerateOrigTestAnyValueSlice()
	return NewSlice(&orig, NewState())
}

func CopyOrigAnyValueSlice(dest, src []otlpcommon.AnyValue) []otlpcommon.AnyValue {
	var newDest []otlpcommon.AnyValue
	if cap(dest) < len(src) {
		newDest = make([]otlpcommon.AnyValue, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigAnyValue(&dest[i], false)
		}
	}
	for i := range src {
		CopyOrigAnyValue(&newDest[i], &src[i])
	}
	return newDest
}

func GenerateOrigTestAnyValueSlice() []otlpcommon.AnyValue {
	orig := make([]otlpcommon.AnyValue, 5)
	orig[1] = *GenTestOrigAnyValue()
	orig[3] = *GenTestOrigAnyValue()
	return orig
}
