/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable;

import java.util.Set;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.internal.databinding.identity.IdentitySet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ObservableTracker {
    private static ThreadLocal<IChangeListener> currentChangeListener = new ThreadLocal();
    private static ThreadLocal<IStaleListener> currentStaleListener = new ThreadLocal();
    private static ThreadLocal<Set<IObservable>> currentGetterCalledSet = new ThreadLocal();
    private static ThreadLocal<Set<IObservable>> currentObservableCreatedSet = new ThreadLocal();
    private static ThreadLocal<Integer> currentIgnoreCount = new ThreadLocal();

    public static IObservable[] runAndMonitor(Runnable runnable, IChangeListener changeListener, IStaleListener staleListener) {
        Set<IObservable> lastObservableSet = currentGetterCalledSet.get();
        IChangeListener lastChangeListener = currentChangeListener.get();
        IStaleListener lastStaleListener = currentStaleListener.get();
        Integer lastIgnore = currentIgnoreCount.get();
        IdentitySet observableSet = new IdentitySet();
        currentGetterCalledSet.set(observableSet);
        currentChangeListener.set(changeListener);
        currentStaleListener.set(staleListener);
        currentIgnoreCount.remove();
        try {
            runnable.run();
        }
        finally {
            currentGetterCalledSet.set(lastObservableSet);
            currentChangeListener.set(lastChangeListener);
            currentStaleListener.set(lastStaleListener);
            ObservableTracker.checkUnmatchedIgnore(runnable);
            currentIgnoreCount.set(lastIgnore);
        }
        return observableSet.toArray(new IObservable[observableSet.size()]);
    }

    public static IObservable[] runAndCollect(Runnable runnable) {
        Set<IObservable> lastObservableCreatedSet = currentObservableCreatedSet.get();
        Integer lastIgnore = currentIgnoreCount.get();
        IdentitySet observableSet = new IdentitySet();
        currentObservableCreatedSet.set(observableSet);
        currentIgnoreCount.remove();
        try {
            runnable.run();
        }
        finally {
            currentObservableCreatedSet.set(lastObservableCreatedSet);
            ObservableTracker.checkUnmatchedIgnore(runnable);
            currentIgnoreCount.set(lastIgnore);
        }
        return observableSet.toArray(new IObservable[observableSet.size()]);
    }

    private static void checkUnmatchedIgnore(Runnable runnable) {
        if (ObservableTracker.isIgnore()) {
            Policy.getLog().log((IStatus)new Status(4, "org.eclipse.core.databinding", "There were " + String.valueOf(currentIgnoreCount.get()) + " unmatched setIgnore(true) invocations in runnable " + String.valueOf(runnable)));
        }
    }

    public static void setIgnore(boolean ignore) {
        Integer lastCount = currentIgnoreCount.get();
        int newCount = (lastCount == null ? 0 : lastCount) + (ignore ? 1 : -1);
        if (newCount < 0) {
            throw new IllegalStateException("Ignore count is already zero");
        }
        if (newCount == 0) {
            currentIgnoreCount.remove();
        } else {
            currentIgnoreCount.set(newCount);
        }
    }

    public static void runAndIgnore(Runnable runnable) {
        ObservableTracker.setIgnore(true);
        try {
            runnable.run();
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    private static String toString(IObservable observable) {
        return observable.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(observable));
    }

    private static boolean isIgnore() {
        return currentIgnoreCount.get() != null;
    }

    public static void getterCalled(IObservable observable) {
        Realm realm;
        if (observable.isDisposed()) {
            Assert.isTrue((boolean)false, (String)("Getter called on disposed observable " + ObservableTracker.toString(observable)));
        }
        if (!(realm = observable.getRealm()).isCurrent()) {
            Assert.isTrue((boolean)false, (String)("Getter called outside realm of observable " + ObservableTracker.toString(observable)));
        }
        if (ObservableTracker.isIgnore()) {
            return;
        }
        Set<IObservable> getterCalledSet = currentGetterCalledSet.get();
        if (getterCalledSet != null && getterCalledSet.add(observable)) {
            IStaleListener staleListener;
            IChangeListener changeListener = currentChangeListener.get();
            if (changeListener != null) {
                observable.addChangeListener(changeListener);
            }
            if ((staleListener = currentStaleListener.get()) != null) {
                observable.addStaleListener(staleListener);
            }
        }
    }

    public static void observableCreated(IObservable observable) {
        if (ObservableTracker.isIgnore()) {
            return;
        }
        Set<IObservable> observableCreatedSet = currentObservableCreatedSet.get();
        if (observableCreatedSet != null) {
            observableCreatedSet.add(observable);
        }
    }
}

