package xspace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCustomerByPhone invokes the xspace.QueryCustomerByPhone API synchronously
// api document: https://help.aliyun.com/api/xspace/querycustomerbyphone.html
func (client *Client) QueryCustomerByPhone(request *QueryCustomerByPhoneRequest) (response *QueryCustomerByPhoneResponse, err error) {
	response = CreateQueryCustomerByPhoneResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCustomerByPhoneWithChan invokes the xspace.QueryCustomerByPhone API asynchronously
// api document: https://help.aliyun.com/api/xspace/querycustomerbyphone.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCustomerByPhoneWithChan(request *QueryCustomerByPhoneRequest) (<-chan *QueryCustomerByPhoneResponse, <-chan error) {
	responseChan := make(chan *QueryCustomerByPhoneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCustomerByPhone(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCustomerByPhoneWithCallback invokes the xspace.QueryCustomerByPhone API asynchronously
// api document: https://help.aliyun.com/api/xspace/querycustomerbyphone.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCustomerByPhoneWithCallback(request *QueryCustomerByPhoneRequest, callback func(response *QueryCustomerByPhoneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCustomerByPhoneResponse
		var err error
		defer close(result)
		response, err = client.QueryCustomerByPhone(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCustomerByPhoneRequest is the request struct for api QueryCustomerByPhone
type QueryCustomerByPhoneRequest struct {
	*requests.RoaRequest
	Phone string `position:"Query" name:"Phone"`
}

// QueryCustomerByPhoneResponse is the response struct for api QueryCustomerByPhone
type QueryCustomerByPhoneResponse struct {
	*responses.BaseResponse
	RequestId string                     `json:"RequestId" xml:"RequestId"`
	Success   bool                       `json:"Success" xml:"Success"`
	Code      string                     `json:"Code" xml:"Code"`
	Message   string                     `json:"Message" xml:"Message"`
	Data      DataInQueryCustomerByPhone `json:"Data" xml:"Data"`
}

// CreateQueryCustomerByPhoneRequest creates a request to invoke QueryCustomerByPhone API
func CreateQueryCustomerByPhoneRequest() (request *QueryCustomerByPhoneRequest) {
	request = &QueryCustomerByPhoneRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("xspace", "2017-07-20", "QueryCustomerByPhone", "/customerbyphone", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryCustomerByPhoneResponse creates a response to parse from QueryCustomerByPhone response
func CreateQueryCustomerByPhoneResponse() (response *QueryCustomerByPhoneResponse) {
	response = &QueryCustomerByPhoneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
