package uis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUisNetworkInterfaces invokes the uis.DescribeUisNetworkInterfaces API synchronously
// api document: https://help.aliyun.com/api/uis/describeuisnetworkinterfaces.html
func (client *Client) DescribeUisNetworkInterfaces(request *DescribeUisNetworkInterfacesRequest) (response *DescribeUisNetworkInterfacesResponse, err error) {
	response = CreateDescribeUisNetworkInterfacesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUisNetworkInterfacesWithChan invokes the uis.DescribeUisNetworkInterfaces API asynchronously
// api document: https://help.aliyun.com/api/uis/describeuisnetworkinterfaces.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUisNetworkInterfacesWithChan(request *DescribeUisNetworkInterfacesRequest) (<-chan *DescribeUisNetworkInterfacesResponse, <-chan error) {
	responseChan := make(chan *DescribeUisNetworkInterfacesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUisNetworkInterfaces(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUisNetworkInterfacesWithCallback invokes the uis.DescribeUisNetworkInterfaces API asynchronously
// api document: https://help.aliyun.com/api/uis/describeuisnetworkinterfaces.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUisNetworkInterfacesWithCallback(request *DescribeUisNetworkInterfacesRequest, callback func(response *DescribeUisNetworkInterfacesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUisNetworkInterfacesResponse
		var err error
		defer close(result)
		response, err = client.DescribeUisNetworkInterfaces(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUisNetworkInterfacesRequest is the request struct for api DescribeUisNetworkInterfaces
type DescribeUisNetworkInterfacesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	UisNodeId            string           `position:"Query" name:"UisNodeId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	UisEniId             string           `position:"Query" name:"UisEniId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeUisNetworkInterfacesResponse is the response struct for api DescribeUisNetworkInterfaces
type DescribeUisNetworkInterfacesResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	TotalCount        int               `json:"TotalCount" xml:"TotalCount"`
	PageNumber        int               `json:"PageNumber" xml:"PageNumber"`
	PageSize          int               `json:"PageSize" xml:"PageSize"`
	NetworkInterfaces NetworkInterfaces `json:"NetworkInterfaces" xml:"NetworkInterfaces"`
}

// CreateDescribeUisNetworkInterfacesRequest creates a request to invoke DescribeUisNetworkInterfaces API
func CreateDescribeUisNetworkInterfacesRequest() (request *DescribeUisNetworkInterfacesRequest) {
	request = &DescribeUisNetworkInterfacesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Uis", "2018-08-21", "DescribeUisNetworkInterfaces", "uis", "openAPI")
	return
}

// CreateDescribeUisNetworkInterfacesResponse creates a response to parse from DescribeUisNetworkInterfaces response
func CreateDescribeUisNetworkInterfacesResponse() (response *DescribeUisNetworkInterfacesResponse) {
	response = &DescribeUisNetworkInterfacesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
