package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCustomer invokes the scsp.UpdateCustomer API synchronously
func (client *Client) UpdateCustomer(request *UpdateCustomerRequest) (response *UpdateCustomerResponse, err error) {
	response = CreateUpdateCustomerResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCustomerWithChan invokes the scsp.UpdateCustomer API asynchronously
func (client *Client) UpdateCustomerWithChan(request *UpdateCustomerRequest) (<-chan *UpdateCustomerResponse, <-chan error) {
	responseChan := make(chan *UpdateCustomerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCustomer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCustomerWithCallback invokes the scsp.UpdateCustomer API asynchronously
func (client *Client) UpdateCustomerWithCallback(request *UpdateCustomerRequest, callback func(response *UpdateCustomerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCustomerResponse
		var err error
		defer close(result)
		response, err = client.UpdateCustomer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCustomerRequest is the request struct for api UpdateCustomer
type UpdateCustomerRequest struct {
	*requests.RpcRequest
	Industry    string           `position:"Query"`
	OuterIdType requests.Integer `position:"Query"`
	Dingding    string           `position:"Query"`
	BizType     string           `position:"Query"`
	TypeCode    string           `position:"Query"`
	InstanceId  string           `position:"Query"`
	Contacter   string           `position:"Query"`
	ProdLineId  requests.Integer `position:"Query"`
	Phone       string           `position:"Query"`
	Name        string           `position:"Query"`
	CustomerId  requests.Integer `position:"Query"`
	ManagerName string           `position:"Query"`
	OuterId     string           `position:"Query"`
	Position    string           `position:"Query"`
	Email       string           `position:"Query"`
}

// UpdateCustomerResponse is the response struct for api UpdateCustomer
type UpdateCustomerResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      int64  `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateCustomerRequest creates a request to invoke UpdateCustomer API
func CreateUpdateCustomerRequest() (request *UpdateCustomerRequest) {
	request = &UpdateCustomerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "UpdateCustomer", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateCustomerResponse creates a response to parse from UpdateCustomer response
func CreateUpdateCustomerResponse() (response *UpdateCustomerResponse) {
	response = &UpdateCustomerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
