package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpgradeDBVersion invokes the gpdb.UpgradeDBVersion API synchronously
func (client *Client) UpgradeDBVersion(request *UpgradeDBVersionRequest) (response *UpgradeDBVersionResponse, err error) {
	response = CreateUpgradeDBVersionResponse()
	err = client.DoAction(request, response)
	return
}

// UpgradeDBVersionWithChan invokes the gpdb.UpgradeDBVersion API asynchronously
func (client *Client) UpgradeDBVersionWithChan(request *UpgradeDBVersionRequest) (<-chan *UpgradeDBVersionResponse, <-chan error) {
	responseChan := make(chan *UpgradeDBVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpgradeDBVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpgradeDBVersionWithCallback invokes the gpdb.UpgradeDBVersion API asynchronously
func (client *Client) UpgradeDBVersionWithCallback(request *UpgradeDBVersionRequest, callback func(response *UpgradeDBVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpgradeDBVersionResponse
		var err error
		defer close(result)
		response, err = client.UpgradeDBVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpgradeDBVersionRequest is the request struct for api UpgradeDBVersion
type UpgradeDBVersionRequest struct {
	*requests.RpcRequest
	SwitchTimeMode string           `position:"Query" name:"SwitchTimeMode"`
	DBInstanceId   string           `position:"Query" name:"DBInstanceId"`
	SwitchTime     string           `position:"Query" name:"SwitchTime"`
	MajorVersion   string           `position:"Query" name:"MajorVersion"`
	MinorVersion   string           `position:"Query" name:"MinorVersion"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
}

// UpgradeDBVersionResponse is the response struct for api UpgradeDBVersion
type UpgradeDBVersionResponse struct {
	*responses.BaseResponse
	TaskId         string `json:"TaskId" xml:"TaskId"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	DBInstanceId   string `json:"DBInstanceId" xml:"DBInstanceId"`
	DBInstanceName string `json:"DBInstanceName" xml:"DBInstanceName"`
}

// CreateUpgradeDBVersionRequest creates a request to invoke UpgradeDBVersion API
func CreateUpgradeDBVersionRequest() (request *UpgradeDBVersionRequest) {
	request = &UpgradeDBVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "UpgradeDBVersion", "", "")
	request.Method = requests.POST
	return
}

// CreateUpgradeDBVersionResponse creates a response to parse from UpgradeDBVersion response
func CreateUpgradeDBVersionResponse() (response *UpgradeDBVersionResponse) {
	response = &UpgradeDBVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
