package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBandwidthPackages invokes the ga.ListBandwidthPackages API synchronously
func (client *Client) ListBandwidthPackages(request *ListBandwidthPackagesRequest) (response *ListBandwidthPackagesResponse, err error) {
	response = CreateListBandwidthPackagesResponse()
	err = client.DoAction(request, response)
	return
}

// ListBandwidthPackagesWithChan invokes the ga.ListBandwidthPackages API asynchronously
func (client *Client) ListBandwidthPackagesWithChan(request *ListBandwidthPackagesRequest) (<-chan *ListBandwidthPackagesResponse, <-chan error) {
	responseChan := make(chan *ListBandwidthPackagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBandwidthPackages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBandwidthPackagesWithCallback invokes the ga.ListBandwidthPackages API asynchronously
func (client *Client) ListBandwidthPackagesWithCallback(request *ListBandwidthPackagesRequest, callback func(response *ListBandwidthPackagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBandwidthPackagesResponse
		var err error
		defer close(result)
		response, err = client.ListBandwidthPackages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBandwidthPackagesRequest is the request struct for api ListBandwidthPackages
type ListBandwidthPackagesRequest struct {
	*requests.RpcRequest
	BandwidthPackageId string           `position:"Query" name:"BandwidthPackageId"`
	Type               string           `position:"Query" name:"Type"`
	PageNumber         requests.Integer `position:"Query" name:"PageNumber"`
	PageSize           requests.Integer `position:"Query" name:"PageSize"`
	State              string           `position:"Query" name:"State"`
}

// ListBandwidthPackagesResponse is the response struct for api ListBandwidthPackages
type ListBandwidthPackagesResponse struct {
	*responses.BaseResponse
	TotalCount        int                `json:"TotalCount" xml:"TotalCount"`
	RequestId         string             `json:"RequestId" xml:"RequestId"`
	PageSize          int                `json:"PageSize" xml:"PageSize"`
	PageNumber        int                `json:"PageNumber" xml:"PageNumber"`
	BandwidthPackages []BandwidthPackage `json:"BandwidthPackages" xml:"BandwidthPackages"`
}

// CreateListBandwidthPackagesRequest creates a request to invoke ListBandwidthPackages API
func CreateListBandwidthPackagesRequest() (request *ListBandwidthPackagesRequest) {
	request = &ListBandwidthPackagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "ListBandwidthPackages", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListBandwidthPackagesResponse creates a response to parse from ListBandwidthPackages response
func CreateListBandwidthPackagesResponse() (response *ListBandwidthPackagesResponse) {
	response = &ListBandwidthPackagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
