package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRepositoryProtectedBranch invokes the codeup.CreateRepositoryProtectedBranch API synchronously
func (client *Client) CreateRepositoryProtectedBranch(request *CreateRepositoryProtectedBranchRequest) (response *CreateRepositoryProtectedBranchResponse, err error) {
	response = CreateCreateRepositoryProtectedBranchResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRepositoryProtectedBranchWithChan invokes the codeup.CreateRepositoryProtectedBranch API asynchronously
func (client *Client) CreateRepositoryProtectedBranchWithChan(request *CreateRepositoryProtectedBranchRequest) (<-chan *CreateRepositoryProtectedBranchResponse, <-chan error) {
	responseChan := make(chan *CreateRepositoryProtectedBranchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRepositoryProtectedBranch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRepositoryProtectedBranchWithCallback invokes the codeup.CreateRepositoryProtectedBranch API asynchronously
func (client *Client) CreateRepositoryProtectedBranchWithCallback(request *CreateRepositoryProtectedBranchRequest, callback func(response *CreateRepositoryProtectedBranchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRepositoryProtectedBranchResponse
		var err error
		defer close(result)
		response, err = client.CreateRepositoryProtectedBranch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRepositoryProtectedBranchRequest is the request struct for api CreateRepositoryProtectedBranch
type CreateRepositoryProtectedBranchRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// CreateRepositoryProtectedBranchResponse is the response struct for api CreateRepositoryProtectedBranch
type CreateRepositoryProtectedBranchResponse struct {
	*responses.BaseResponse
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateCreateRepositoryProtectedBranchRequest creates a request to invoke CreateRepositoryProtectedBranch API
func CreateCreateRepositoryProtectedBranchRequest() (request *CreateRepositoryProtectedBranchRequest) {
	request = &CreateRepositoryProtectedBranchRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "CreateRepositoryProtectedBranch", "/api/v4/projects/[ProjectId]/repository/protect_branches", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateRepositoryProtectedBranchResponse creates a response to parse from CreateRepositoryProtectedBranch response
func CreateCreateRepositoryProtectedBranchResponse() (response *CreateRepositoryProtectedBranchResponse) {
	response = &CreateRepositoryProtectedBranchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
