package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDnsGtmMonitorAvailableConfig invokes the alidns.DescribeDnsGtmMonitorAvailableConfig API synchronously
func (client *Client) DescribeDnsGtmMonitorAvailableConfig(request *DescribeDnsGtmMonitorAvailableConfigRequest) (response *DescribeDnsGtmMonitorAvailableConfigResponse, err error) {
	response = CreateDescribeDnsGtmMonitorAvailableConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDnsGtmMonitorAvailableConfigWithChan invokes the alidns.DescribeDnsGtmMonitorAvailableConfig API asynchronously
func (client *Client) DescribeDnsGtmMonitorAvailableConfigWithChan(request *DescribeDnsGtmMonitorAvailableConfigRequest) (<-chan *DescribeDnsGtmMonitorAvailableConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeDnsGtmMonitorAvailableConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDnsGtmMonitorAvailableConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDnsGtmMonitorAvailableConfigWithCallback invokes the alidns.DescribeDnsGtmMonitorAvailableConfig API asynchronously
func (client *Client) DescribeDnsGtmMonitorAvailableConfigWithCallback(request *DescribeDnsGtmMonitorAvailableConfigRequest, callback func(response *DescribeDnsGtmMonitorAvailableConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDnsGtmMonitorAvailableConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeDnsGtmMonitorAvailableConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDnsGtmMonitorAvailableConfigRequest is the request struct for api DescribeDnsGtmMonitorAvailableConfig
type DescribeDnsGtmMonitorAvailableConfigRequest struct {
	*requests.RpcRequest
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeDnsGtmMonitorAvailableConfigResponse is the response struct for api DescribeDnsGtmMonitorAvailableConfig
type DescribeDnsGtmMonitorAvailableConfigResponse struct {
	*responses.BaseResponse
	RequestId              string                 `json:"RequestId" xml:"RequestId"`
	Ipv4IspCityNodes       Ipv4IspCityNodes       `json:"Ipv4IspCityNodes" xml:"Ipv4IspCityNodes"`
	DomainIpv4IspCityNodes DomainIpv4IspCityNodes `json:"DomainIpv4IspCityNodes" xml:"DomainIpv4IspCityNodes"`
	DomainIpv6IspCityNodes DomainIpv6IspCityNodes `json:"DomainIpv6IspCityNodes" xml:"DomainIpv6IspCityNodes"`
	Ipv6IspCityNodes       Ipv6IspCityNodes       `json:"Ipv6IspCityNodes" xml:"Ipv6IspCityNodes"`
}

// CreateDescribeDnsGtmMonitorAvailableConfigRequest creates a request to invoke DescribeDnsGtmMonitorAvailableConfig API
func CreateDescribeDnsGtmMonitorAvailableConfigRequest() (request *DescribeDnsGtmMonitorAvailableConfigRequest) {
	request = &DescribeDnsGtmMonitorAvailableConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDnsGtmMonitorAvailableConfig", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDnsGtmMonitorAvailableConfigResponse creates a response to parse from DescribeDnsGtmMonitorAvailableConfig response
func CreateDescribeDnsGtmMonitorAvailableConfigResponse() (response *DescribeDnsGtmMonitorAvailableConfigResponse) {
	response = &DescribeDnsGtmMonitorAvailableConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
