// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies whether Amazon S3 replicates delete markers. If you specify a <code>Filter</code> in your replication configuration, you must also include a <code>DeleteMarkerReplication</code> element. If your <code>Filter</code> includes a <code>Tag</code> element, the <code>DeleteMarkerReplication</code> <code>Status</code> must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config">Basic Rule Configuration</a>.</p>
/// <p>For more information about delete marker replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html">Basic Rule Configuration</a>.</p><note>
/// <p>If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations">Backward Compatibility</a>.</p>
/// </note>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DeleteMarkerReplication {
    /// <p>Indicates whether to replicate delete markers.</p><note>
    /// <p>Indicates whether to replicate delete markers.</p>
    /// </note>
    pub status: ::std::option::Option<crate::types::DeleteMarkerReplicationStatus>,
}
impl DeleteMarkerReplication {
    /// <p>Indicates whether to replicate delete markers.</p><note>
    /// <p>Indicates whether to replicate delete markers.</p>
    /// </note>
    pub fn status(&self) -> ::std::option::Option<&crate::types::DeleteMarkerReplicationStatus> {
        self.status.as_ref()
    }
}
impl DeleteMarkerReplication {
    /// Creates a new builder-style object to manufacture [`DeleteMarkerReplication`](crate::types::DeleteMarkerReplication).
    pub fn builder() -> crate::types::builders::DeleteMarkerReplicationBuilder {
        crate::types::builders::DeleteMarkerReplicationBuilder::default()
    }
}

/// A builder for [`DeleteMarkerReplication`](crate::types::DeleteMarkerReplication).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct DeleteMarkerReplicationBuilder {
    pub(crate) status: ::std::option::Option<crate::types::DeleteMarkerReplicationStatus>,
}
impl DeleteMarkerReplicationBuilder {
    /// <p>Indicates whether to replicate delete markers.</p><note>
    /// <p>Indicates whether to replicate delete markers.</p>
    /// </note>
    pub fn status(mut self, input: crate::types::DeleteMarkerReplicationStatus) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether to replicate delete markers.</p><note>
    /// <p>Indicates whether to replicate delete markers.</p>
    /// </note>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::DeleteMarkerReplicationStatus>) -> Self {
        self.status = input;
        self
    }
    /// <p>Indicates whether to replicate delete markers.</p><note>
    /// <p>Indicates whether to replicate delete markers.</p>
    /// </note>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::DeleteMarkerReplicationStatus> {
        &self.status
    }
    /// Consumes the builder and constructs a [`DeleteMarkerReplication`](crate::types::DeleteMarkerReplication).
    pub fn build(self) -> crate::types::DeleteMarkerReplication {
        crate::types::DeleteMarkerReplication { status: self.status }
    }
}
