/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.comp.CompilationService;
import com.sun.tools.sjavac.options.Options;
import com.sun.tools.sjavac.pubapi.PubApi;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CompileProperties
implements Transformer {
    String extra;
    private static final String FORMAT = "{0}public final class {1} extends {2} '{'\n    protected final Object[][] getContents() '{'\n        return new Object[][] '{'\n{3}        };\n    }\n}\n";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    @Override
    public void setExtra(String string) {
        this.extra = string;
    }

    @Override
    public void setExtra(Options options) {
    }

    @Override
    public boolean transform(CompilationService compilationService, Map<String, Set<URI>> map, Set<URI> set, Map<String, Set<String>> map2, URI uRI, Map<String, Set<URI>> map3, Map<String, Map<String, Set<String>>> map4, Map<String, Map<String, Set<String>>> map5, Map<String, PubApi> map6, Map<String, PubApi> map7, int n, boolean bl, int n2) {
        boolean bl2 = true;
        for (String string : map.keySet()) {
            String string2 = Util.toFileSystemPath(string);
            for (URI uRI2 : map.get(string)) {
                File file = new File(uRI2);
                boolean bl3 = this.compile(string, string2, file, new File(uRI), n, map3);
                if (bl3) continue;
                bl2 = false;
            }
        }
        return bl2;
    }

    boolean compile(String string, String string2, File file, File file2, int n, Map<String, Set<URI>> map) {
        String string3;
        Object object2;
        String string4 = "java.util.ListResourceBundle";
        if (this.extra != null) {
            string4 = this.extra;
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
        }
        catch (IOException iOException) {
            Log.error("Error reading file " + file.getPath());
            return false;
        }
        int n2 = file.getName().lastIndexOf(".");
        String string5 = file.getName().substring(0, n2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : properties.keySet()) {
            arrayList.add((String)object2);
        }
        Collections.sort(arrayList);
        Iterator<Object> iterator = arrayList.iterator();
        object2 = new StringBuilder();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            ((StringBuilder)object2).append("            { \"" + CompileProperties.escape(string3) + "\", \"" + CompileProperties.escape((String)properties.get(string3)) + "\" },\n");
        }
        string3 = file2.getPath() + File.separator + string2 + File.separator + string5 + ".java";
        File file3 = new File(string3);
        if (!file3.getParentFile().isDirectory() && !file3.getParentFile().mkdirs()) {
            Log.error("Could not create the directory " + file3.getParentFile().getPath());
            return false;
        }
        Set<URI> set = map.get(string);
        if (set == null) {
            set = new HashSet<URI>();
            map.put(string, set);
        }
        set.add(file3.toURI());
        if (file3.exists() && file3.lastModified() > file.lastModified()) {
            return true;
        }
        String string6 = "package " + string2.replace(File.separatorChar, '.') + ";\n\n";
        Log.info("Compiling property file " + string2 + File.separator + file.getName());
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file3)));){
            MessageFormat messageFormat = new MessageFormat(FORMAT);
            bufferedWriter.write(messageFormat.format(new Object[]{string6, string5, string4, object2}));
        }
        catch (IOException iOException) {
            Log.error("Could not write file " + file3.getPath());
            return false;
        }
        return true;
    }

    public static String escape(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n * 2);
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuilder.append('\\');
                    stringBuilder.append('\\');
                    continue block7;
                }
                case '\t': {
                    stringBuilder.append('\\');
                    stringBuilder.append('t');
                    continue block7;
                }
                case '\n': {
                    stringBuilder.append('\\');
                    stringBuilder.append('n');
                    continue block7;
                }
                case '\r': {
                    stringBuilder.append('\\');
                    stringBuilder.append('r');
                    continue block7;
                }
                case '\f': {
                    stringBuilder.append('\\');
                    stringBuilder.append('f');
                    continue block7;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringBuilder.append('\\');
                        stringBuilder.append('u');
                        stringBuilder.append(CompileProperties.toHex(c >> 12 & 0xF));
                        stringBuilder.append(CompileProperties.toHex(c >> 8 & 0xF));
                        stringBuilder.append(CompileProperties.toHex(c >> 4 & 0xF));
                        stringBuilder.append(CompileProperties.toHex(c & 0xF));
                        continue block7;
                    }
                    if (c == '\"') {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static char toHex(int n) {
        return hexDigit[n & 0xF];
    }
}

