/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.util.AbstractDiagnosticFormatter;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.Options;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import javax.tools.JavaFileObject;

public class BasicDiagnosticFormatter
extends AbstractDiagnosticFormatter {
    public BasicDiagnosticFormatter(Options options, JavacMessages javacMessages) {
        super(javacMessages, new BasicConfiguration(options));
    }

    public BasicDiagnosticFormatter(JavacMessages javacMessages) {
        super(javacMessages, new BasicConfiguration());
    }

    @Override
    public String formatDiagnostic(JCDiagnostic jCDiagnostic, Locale locale) {
        if (locale == null) {
            locale = this.messages.getCurrentLocale();
        }
        String string = this.selectFormat(jCDiagnostic);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl = false;
            if (c == '%' && i < string.length() - 1) {
                bl = true;
                c = string.charAt(++i);
            }
            stringBuilder.append(bl ? this.formatMeta(c, jCDiagnostic, locale) : String.valueOf(c));
        }
        if (this.depth == 0) {
            return this.addSourceLineIfNeeded(jCDiagnostic, stringBuilder.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public String formatMessage(JCDiagnostic jCDiagnostic, Locale locale) {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        Collection<String> collection = this.formatArguments(jCDiagnostic, locale);
        String string = this.localize(locale, jCDiagnostic.getCode(), collection.toArray());
        String[] stringArray = string.split("\n");
        if (stringArray.length == 0) {
            stringArray = new String[]{""};
        }
        if (((AbstractCollection)((Object)this.getConfiguration().getVisible())).contains((Object)DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY)) {
            stringBuilder.append(this.indent(stringArray[0], n += this.getConfiguration().getIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY)));
        }
        if (stringArray.length > 1 && ((AbstractCollection)((Object)this.getConfiguration().getVisible())).contains((Object)DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS)) {
            n += this.getConfiguration().getIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append("\n" + this.indent(stringArray[i], n));
            }
        }
        if (jCDiagnostic.isMultiline() && ((AbstractCollection)((Object)this.getConfiguration().getVisible())).contains((Object)DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS)) {
            n += this.getConfiguration().getIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS);
            for (String string2 : this.formatSubdiagnostics(jCDiagnostic, locale)) {
                stringBuilder.append("\n" + this.indent(string2, n));
            }
        }
        return stringBuilder.toString();
    }

    protected String addSourceLineIfNeeded(JCDiagnostic jCDiagnostic, String string) {
        boolean bl;
        if (!this.displaySource(jCDiagnostic)) {
            return string;
        }
        BasicConfiguration basicConfiguration = this.getConfiguration();
        int n = basicConfiguration.getIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE);
        String string2 = "\n" + this.formatSourceLine(jCDiagnostic, n);
        boolean bl2 = bl = !string.contains("\n");
        if (bl || this.getConfiguration().getSourcePosition() == BasicConfiguration.SourcePosition.BOTTOM) {
            return string + string2;
        }
        return string.replaceFirst("\n", Matcher.quoteReplacement(string2) + "\n");
    }

    protected String formatMeta(char c, JCDiagnostic jCDiagnostic, Locale locale) {
        switch (c) {
            case 'b': {
                return this.formatSource(jCDiagnostic, false, locale);
            }
            case 'e': {
                return this.formatPosition(jCDiagnostic, DiagnosticFormatter.PositionKind.END, locale);
            }
            case 'f': {
                return this.formatSource(jCDiagnostic, true, locale);
            }
            case 'l': {
                return this.formatPosition(jCDiagnostic, DiagnosticFormatter.PositionKind.LINE, locale);
            }
            case 'c': {
                return this.formatPosition(jCDiagnostic, DiagnosticFormatter.PositionKind.COLUMN, locale);
            }
            case 'o': {
                return this.formatPosition(jCDiagnostic, DiagnosticFormatter.PositionKind.OFFSET, locale);
            }
            case 'p': {
                return this.formatKind(jCDiagnostic, locale);
            }
            case 's': {
                return this.formatPosition(jCDiagnostic, DiagnosticFormatter.PositionKind.START, locale);
            }
            case 't': {
                boolean bl;
                switch (jCDiagnostic.getType()) {
                    case FRAGMENT: {
                        bl = false;
                        break;
                    }
                    case ERROR: {
                        bl = jCDiagnostic.getIntPosition() == -1;
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    return this.formatKind(jCDiagnostic, locale);
                }
                return "";
            }
            case 'm': {
                return this.formatMessage(jCDiagnostic, locale);
            }
            case 'L': {
                return this.formatLintCategory(jCDiagnostic, locale);
            }
            case '_': {
                return " ";
            }
            case '%': {
                return "%";
            }
        }
        return String.valueOf(c);
    }

    private String selectFormat(JCDiagnostic jCDiagnostic) {
        DiagnosticSource diagnosticSource = jCDiagnostic.getDiagnosticSource();
        String string = this.getConfiguration().getFormat(BasicConfiguration.BasicFormatKind.DEFAULT_NO_POS_FORMAT);
        if (diagnosticSource != null && diagnosticSource != DiagnosticSource.NO_SOURCE) {
            if (jCDiagnostic.getIntPosition() != -1) {
                string = this.getConfiguration().getFormat(BasicConfiguration.BasicFormatKind.DEFAULT_POS_FORMAT);
            } else if (diagnosticSource.getFile() != null && diagnosticSource.getFile().getKind() == JavaFileObject.Kind.CLASS) {
                string = this.getConfiguration().getFormat(BasicConfiguration.BasicFormatKind.DEFAULT_CLASS_FORMAT);
            }
        }
        return string;
    }

    @Override
    public BasicConfiguration getConfiguration() {
        return (BasicConfiguration)super.getConfiguration();
    }

    public static class BasicConfiguration
    extends AbstractDiagnosticFormatter.SimpleConfiguration {
        protected Map<DiagnosticFormatter.Configuration.DiagnosticPart, Integer> indentationLevels;
        protected Map<BasicFormatKind, String> availableFormats;
        protected SourcePosition sourcePosition;

        public BasicConfiguration(Options options) {
            super(options, EnumSet.of(DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY, DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS, DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS, DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE));
            String string;
            this.initFormat();
            this.initIndentation();
            if (options.isSet("diags.legacy")) {
                this.initOldFormat();
            }
            if ((string = options.get("diags.layout")) != null) {
                if (string.equals("OLD")) {
                    this.initOldFormat();
                } else {
                    this.initFormats(string);
                }
            }
            String string2 = null;
            string2 = options.get("diags.sourcePosition");
            if (string2 != null && string2.equals("bottom")) {
                this.setSourcePosition(SourcePosition.BOTTOM);
            } else {
                this.setSourcePosition(SourcePosition.AFTER_SUMMARY);
            }
            String string3 = options.get("diags.indent");
            if (string3 != null) {
                String[] stringArray = string3.split("\\|");
                try {
                    switch (stringArray.length) {
                        case 5: {
                            this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.JLS, Integer.parseInt(stringArray[4]));
                        }
                        case 4: {
                            this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS, Integer.parseInt(stringArray[3]));
                        }
                        case 3: {
                            this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE, Integer.parseInt(stringArray[2]));
                        }
                        case 2: {
                            this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS, Integer.parseInt(stringArray[1]));
                        }
                    }
                    this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY, Integer.parseInt(stringArray[0]));
                }
                catch (NumberFormatException numberFormatException) {
                    this.initIndentation();
                }
            }
        }

        public BasicConfiguration() {
            super(EnumSet.of(DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY, DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS, DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS, DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE));
            this.initFormat();
            this.initIndentation();
        }

        private void initFormat() {
            this.initFormats("%f:%l:%_%p%L%m", "%p%L%m", "%f:%_%p%L%m");
        }

        private void initOldFormat() {
            this.initFormats("%f:%l:%_%t%L%m", "%p%L%m", "%f:%_%t%L%m");
        }

        private void initFormats(String string, String string2, String string3) {
            this.availableFormats = new EnumMap<BasicFormatKind, String>(BasicFormatKind.class);
            this.setFormat(BasicFormatKind.DEFAULT_POS_FORMAT, string);
            this.setFormat(BasicFormatKind.DEFAULT_NO_POS_FORMAT, string2);
            this.setFormat(BasicFormatKind.DEFAULT_CLASS_FORMAT, string3);
        }

        private void initFormats(String string) {
            String[] stringArray = string.split("\\|");
            switch (stringArray.length) {
                case 3: {
                    this.setFormat(BasicFormatKind.DEFAULT_CLASS_FORMAT, stringArray[2]);
                }
                case 2: {
                    this.setFormat(BasicFormatKind.DEFAULT_NO_POS_FORMAT, stringArray[1]);
                }
            }
            this.setFormat(BasicFormatKind.DEFAULT_POS_FORMAT, stringArray[0]);
        }

        private void initIndentation() {
            this.indentationLevels = new HashMap<DiagnosticFormatter.Configuration.DiagnosticPart, Integer>();
            this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY, 0);
            this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS, 2);
            this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS, 4);
            this.setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart.SOURCE, 0);
        }

        public int getIndentation(DiagnosticFormatter.Configuration.DiagnosticPart diagnosticPart) {
            return this.indentationLevels.get((Object)diagnosticPart);
        }

        public void setIndentation(DiagnosticFormatter.Configuration.DiagnosticPart diagnosticPart, int n) {
            this.indentationLevels.put(diagnosticPart, n);
        }

        public void setSourcePosition(SourcePosition sourcePosition) {
            this.sourcePosition = sourcePosition;
        }

        public SourcePosition getSourcePosition() {
            return this.sourcePosition;
        }

        public void setFormat(BasicFormatKind basicFormatKind, String string) {
            this.availableFormats.put(basicFormatKind, string);
        }

        public String getFormat(BasicFormatKind basicFormatKind) {
            return this.availableFormats.get((Object)basicFormatKind);
        }

        public static enum BasicFormatKind {
            DEFAULT_POS_FORMAT,
            DEFAULT_NO_POS_FORMAT,
            DEFAULT_CLASS_FORMAT;

        }

        public static enum SourcePosition {
            BOTTOM,
            AFTER_SUMMARY;

        }
    }
}

