/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.DocTreeMaker;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.text.BreakIterator;
import java.util.HashMap;
import java.util.Map;

public class DocCommentParser {
    final ParserFactory fac;
    final DiagnosticSource diagSource;
    final Tokens.Comment comment;
    final DocTreeMaker m;
    final Names names;
    BreakIterator sentenceBreaker;
    protected char[] buf;
    protected int bp;
    protected int buflen;
    protected char ch;
    int textStart = -1;
    int lastNonWhite = -1;
    boolean newline = true;
    Map<Name, TagParser> tagParsers;

    public DocCommentParser(ParserFactory parserFactory, DiagnosticSource diagnosticSource, Tokens.Comment comment) {
        this.fac = parserFactory;
        this.diagSource = diagnosticSource;
        this.comment = comment;
        this.names = parserFactory.names;
        this.m = parserFactory.docTreeMaker;
        this.initTagParsers();
    }

    public DocCommentParser(ParserFactory parserFactory) {
        this(parserFactory, null, null);
    }

    public DCTree.DCDocComment parse() {
        String string = this.comment.getText();
        this.buf = new char[string.length() + 1];
        string.getChars(0, string.length(), this.buf, 0);
        this.buf[this.buf.length - 1] = 26;
        this.buflen = this.buf.length - 1;
        this.bp = -1;
        this.nextChar();
        List<DCTree> list = this.blockContent();
        List<DCTree> list2 = this.blockTags();
        int n = !list.isEmpty() ? ((DCTree)list.head).pos : (!list2.isEmpty() ? ((DCTree)list2.head).pos : -1);
        DCTree.DCDocComment dCDocComment = this.m.at(n).newDocCommentTree(this.comment, list, list2);
        return dCDocComment;
    }

    void nextChar() {
        this.ch = this.buf[this.bp < this.buflen ? (this.bp = this.bp + 1) : this.buflen];
        switch (this.ch) {
            case '\n': 
            case '\f': 
            case '\r': {
                this.newline = true;
            }
        }
    }

    protected List<DCTree> blockContent() {
        ListBuffer<DCTree> listBuffer = new ListBuffer<DCTree>();
        this.textStart = -1;
        block9: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    this.nextChar();
                    continue block9;
                }
                case '&': {
                    this.entity(listBuffer);
                    continue block9;
                }
                case '<': {
                    this.newline = false;
                    this.addPendingText(listBuffer, this.bp - 1);
                    listBuffer.add(this.html());
                    if (this.textStart != -1) continue block9;
                    this.textStart = this.bp;
                    this.lastNonWhite = -1;
                    continue block9;
                }
                case '>': {
                    this.newline = false;
                    this.addPendingText(listBuffer, this.bp - 1);
                    listBuffer.add(this.m.at(this.bp).newErroneousTree(this.newString(this.bp, this.bp + 1), this.diagSource, "dc.bad.gt", new Object[0]));
                    this.nextChar();
                    if (this.textStart != -1) continue block9;
                    this.textStart = this.bp;
                    this.lastNonWhite = -1;
                    continue block9;
                }
                case '{': {
                    this.inlineTag(listBuffer);
                    continue block9;
                }
                case '@': {
                    if (this.newline) {
                        this.addPendingText(listBuffer, this.lastNonWhite);
                        break block9;
                    }
                }
                default: {
                    this.newline = false;
                    if (this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.lastNonWhite = this.bp;
                    this.nextChar();
                    continue block9;
                }
            }
        }
        if (this.lastNonWhite != -1) {
            this.addPendingText(listBuffer, this.lastNonWhite);
        }
        return listBuffer.toList();
    }

    protected List<DCTree> blockTags() {
        ListBuffer<DCTree> listBuffer = new ListBuffer<DCTree>();
        while (this.ch == '@') {
            listBuffer.add(this.blockTag());
        }
        return listBuffer.toList();
    }

    protected DCTree blockTag() {
        int n = this.bp;
        try {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readTagName();
                TagParser tagParser = this.tagParsers.get(name);
                if (tagParser == null) {
                    List<DCTree> list = this.blockContent();
                    return this.m.at(n).newUnknownBlockTagTree((javax.lang.model.element.Name)name, list);
                }
                switch (tagParser.getKind()) {
                    case BLOCK: {
                        return tagParser.parse(n);
                    }
                    case INLINE: {
                        return this.erroneous("dc.bad.inline.tag", n);
                    }
                }
            }
            this.blockContent();
            return this.erroneous("dc.no.tag.name", n);
        }
        catch (ParseException parseException) {
            this.blockContent();
            return this.erroneous(parseException.getMessage(), n);
        }
    }

    protected void inlineTag(ListBuffer<DCTree> listBuffer) {
        this.newline = false;
        this.nextChar();
        if (this.ch == '@') {
            this.addPendingText(listBuffer, this.bp - 2);
            listBuffer.add(this.inlineTag());
            this.textStart = this.bp;
            this.lastNonWhite = -1;
        } else {
            if (this.textStart == -1) {
                this.textStart = this.bp - 1;
            }
            this.lastNonWhite = this.bp;
        }
    }

    protected DCTree inlineTag() {
        int n = this.bp - 1;
        try {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readTagName();
                TagParser tagParser = this.tagParsers.get(name);
                if (tagParser == null) {
                    this.skipWhitespace();
                    DCTree dCTree = this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                    if (dCTree != null) {
                        this.nextChar();
                        return ((DCTree.DCEndPosTree)((Object)this.m.at(n).newUnknownInlineTagTree((javax.lang.model.element.Name)name, List.of(dCTree)))).setEndPos(this.bp);
                    }
                } else {
                    if (!tagParser.retainWhiteSpace) {
                        this.skipWhitespace();
                    }
                    if (tagParser.getKind() == TagParser.Kind.INLINE) {
                        DCTree.DCEndPosTree dCEndPosTree = (DCTree.DCEndPosTree)tagParser.parse(n);
                        if (dCEndPosTree != null) {
                            return dCEndPosTree.setEndPos(this.bp);
                        }
                    } else {
                        this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                        this.nextChar();
                    }
                }
            }
            return this.erroneous("dc.no.tag.name", n);
        }
        catch (ParseException parseException) {
            return this.erroneous(parseException.getMessage(), n);
        }
    }

    private DCTree inlineText(WhitespaceRetentionPolicy whitespaceRetentionPolicy) throws ParseException {
        switch (whitespaceRetentionPolicy) {
            case REMOVE_ALL: {
                this.skipWhitespace();
                break;
            }
            case REMOVE_FIRST_SPACE: {
                if (this.ch != ' ') break;
                this.nextChar();
                break;
            }
        }
        int n = this.bp;
        int n2 = 1;
        block11: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '{': {
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    ++n2;
                    break;
                }
                case '}': {
                    if (--n2 == 0) {
                        return this.m.at(n).newTextTree(this.newString(n, this.bp));
                    }
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    break;
                }
                case '@': {
                    if (this.newline) break block11;
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    break;
                }
                default: {
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                }
            }
            this.nextChar();
        }
        throw new ParseException("dc.unterminated.inline.tag");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DCTree.DCReference reference(boolean bl) throws ParseException {
        List<JCTree> list;
        Name name;
        JCTree jCTree;
        int n = this.bp;
        int n2 = 0;
        block11: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    if (n2 != 0) break;
                    break block11;
                }
                case '(': 
                case '<': {
                    this.newline = false;
                    ++n2;
                    break;
                }
                case ')': 
                case '>': {
                    this.newline = false;
                    --n2;
                    break;
                }
                case '}': {
                    if (this.bp == n) {
                        return null;
                    }
                    this.newline = false;
                    break block11;
                }
                case '@': {
                    if (this.newline) break block11;
                }
                default: {
                    this.newline = false;
                }
            }
            this.nextChar();
        }
        if (n2 != 0) {
            throw new ParseException("dc.unterminated.signature");
        }
        String string = this.newString(n, this.bp);
        Log.DeferredDiagnosticHandler deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.fac.log);
        try {
            int n3 = string.indexOf("#");
            int n4 = string.indexOf("(", n3 + 1);
            if (n3 == -1) {
                if (n4 == -1) {
                    jCTree = this.parseType(string);
                    name = null;
                } else {
                    jCTree = null;
                    name = this.parseMember(string.substring(0, n4));
                }
            } else {
                jCTree = n3 == 0 ? null : this.parseType(string.substring(0, n3));
                name = n4 == -1 ? this.parseMember(string.substring(n3 + 1)) : this.parseMember(string.substring(n3 + 1, n4));
            }
            if (n4 < 0) {
                list = null;
            } else {
                int n5 = string.indexOf(")", n4);
                if (n5 != string.length() - 1) {
                    throw new ParseException("dc.ref.bad.parens");
                }
                list = this.parseParams(string.substring(n4 + 1, n5));
            }
            if (!deferredDiagnosticHandler.getDiagnostics().isEmpty()) {
                throw new ParseException("dc.ref.syntax.error");
            }
        }
        finally {
            this.fac.log.popDiagnosticHandler(deferredDiagnosticHandler);
        }
        return (DCTree.DCReference)this.m.at(n).newReferenceTree(string, jCTree, name, list).setEndPos(this.bp);
    }

    JCTree parseType(String string) throws ParseException {
        JavacParser javacParser = this.fac.newParser(string, false, false, false);
        JCTree.JCExpression jCExpression = javacParser.parseType();
        if (javacParser.token().kind != Tokens.TokenKind.EOF) {
            throw new ParseException("dc.ref.unexpected.input");
        }
        return jCExpression;
    }

    Name parseMember(String string) throws ParseException {
        JavacParser javacParser = this.fac.newParser(string, false, false, false);
        Name name = javacParser.ident();
        if (javacParser.token().kind != Tokens.TokenKind.EOF) {
            throw new ParseException("dc.ref.unexpected.input");
        }
        return name;
    }

    List<JCTree> parseParams(String string) throws ParseException {
        if (string.trim().isEmpty()) {
            return List.nil();
        }
        JavacParser javacParser = this.fac.newParser(string.replace("...", "[]"), false, false, false);
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        listBuffer.add(javacParser.parseType());
        if (javacParser.token().kind == Tokens.TokenKind.IDENTIFIER) {
            javacParser.nextToken();
        }
        while (javacParser.token().kind == Tokens.TokenKind.COMMA) {
            javacParser.nextToken();
            listBuffer.add(javacParser.parseType());
            if (javacParser.token().kind != Tokens.TokenKind.IDENTIFIER) continue;
            javacParser.nextToken();
        }
        if (javacParser.token().kind != Tokens.TokenKind.EOF) {
            throw new ParseException("dc.ref.unexpected.input");
        }
        return listBuffer.toList();
    }

    protected DCTree.DCIdentifier identifier() throws ParseException {
        this.skipWhitespace();
        int n = this.bp;
        if (this.isJavaIdentifierStart(this.ch)) {
            Name name = this.readJavaIdentifier();
            return this.m.at(n).newIdentifierTree(name);
        }
        throw new ParseException("dc.identifier.expected");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected DCTree.DCText quotedString() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '\"': {
                    this.nextChar();
                    return this.m.at(n).newTextTree(this.newString(n, this.bp));
                }
                case '@': {
                    if (!this.newline) break;
                    return null;
                }
            }
            this.nextChar();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected DCTree.DCText inlineWord() {
        int n = this.bp;
        int n2 = 0;
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': {
                    this.newline = true;
                }
                case '\t': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return this.m.at(n).newTextTree(this.newString(n, this.bp));
                }
                case '@': {
                    if (this.newline) {
                        return null;
                    }
                }
                case '{': {
                    ++n2;
                    break;
                }
                case '}': {
                    if (n2 == 0) return this.m.at(n).newTextTree(this.newString(n, this.bp));
                    if (--n2 != 0) break;
                    return this.m.at(n).newTextTree(this.newString(n, this.bp));
                }
            }
            this.newline = false;
            this.nextChar();
        }
        return null;
    }

    private List<DCTree> inlineContent() {
        ListBuffer<DCTree> listBuffer = new ListBuffer<DCTree>();
        this.skipWhitespace();
        int n = this.bp;
        int n2 = 1;
        this.textStart = -1;
        block9: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    this.nextChar();
                    continue block9;
                }
                case '&': {
                    this.entity(listBuffer);
                    continue block9;
                }
                case '<': {
                    this.newline = false;
                    this.addPendingText(listBuffer, this.bp - 1);
                    listBuffer.add(this.html());
                    continue block9;
                }
                case '{': {
                    if (this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.newline = false;
                    ++n2;
                    this.nextChar();
                    continue block9;
                }
                case '}': {
                    this.newline = false;
                    if (--n2 == 0) {
                        this.addPendingText(listBuffer, this.bp - 1);
                        this.nextChar();
                        return listBuffer.toList();
                    }
                    this.nextChar();
                    continue block9;
                }
                case '@': {
                    if (this.newline) break block9;
                }
                default: {
                    if (this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.nextChar();
                    continue block9;
                }
            }
        }
        return List.of(this.erroneous("dc.unterminated.inline.tag", n));
    }

    protected void entity(ListBuffer<DCTree> listBuffer) {
        this.newline = false;
        this.addPendingText(listBuffer, this.bp - 1);
        listBuffer.add(this.entity());
        if (this.textStart == -1) {
            this.textStart = this.bp;
            this.lastNonWhite = -1;
        }
    }

    protected DCTree entity() {
        int n = this.bp;
        this.nextChar();
        Name name = null;
        if (this.ch == '#') {
            int n2 = this.bp;
            this.nextChar();
            if (this.isDecimalDigit(this.ch)) {
                this.nextChar();
                while (this.isDecimalDigit(this.ch)) {
                    this.nextChar();
                }
                name = this.names.fromChars(this.buf, n2, this.bp - n2);
            } else if (this.ch == 'x' || this.ch == 'X') {
                this.nextChar();
                if (this.isHexDigit(this.ch)) {
                    this.nextChar();
                    while (this.isHexDigit(this.ch)) {
                        this.nextChar();
                    }
                    name = this.names.fromChars(this.buf, n2, this.bp - n2);
                }
            }
        } else if (this.isIdentifierStart(this.ch)) {
            name = this.readIdentifier();
        }
        if (name == null) {
            return this.erroneous("dc.bad.entity", n);
        }
        if (this.ch != ';') {
            return this.erroneous("dc.missing.semicolon", n);
        }
        this.nextChar();
        return this.m.at(n).newEntityTree(name);
    }

    protected DCTree html() {
        int n = this.bp;
        this.nextChar();
        if (this.isIdentifierStart(this.ch)) {
            Name name = this.readIdentifier();
            List<DCTree> list = this.htmlAttrs();
            if (list != null) {
                boolean bl = false;
                if (this.ch == '/') {
                    this.nextChar();
                    bl = true;
                }
                if (this.ch == '>') {
                    this.nextChar();
                    Object t = ((DCTree.DCEndPosTree)((Object)this.m.at(n).newStartElementTree((javax.lang.model.element.Name)name, list, bl))).setEndPos(this.bp);
                    return t;
                }
            }
        } else if (this.ch == '/') {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readIdentifier();
                this.skipWhitespace();
                if (this.ch == '>') {
                    this.nextChar();
                    return this.m.at(n).newEndElementTree(name);
                }
            }
        } else if (this.ch == '!') {
            this.nextChar();
            if (this.ch == '-') {
                this.nextChar();
                if (this.ch == '-') {
                    this.nextChar();
                    while (this.bp < this.buflen) {
                        int n2 = 0;
                        while (this.ch == '-') {
                            ++n2;
                            this.nextChar();
                        }
                        if (n2 >= 2 && this.ch == '>') {
                            this.nextChar();
                            return this.m.at(n).newCommentTree(this.newString(n, this.bp));
                        }
                        this.nextChar();
                    }
                }
            }
        }
        this.bp = n + 1;
        this.ch = this.buf[this.bp];
        return this.erroneous("dc.malformed.html", n);
    }

    protected List<DCTree> htmlAttrs() {
        ListBuffer<Object> listBuffer = new ListBuffer<Object>();
        this.skipWhitespace();
        block0: while (this.isIdentifierStart(this.ch)) {
            Object object;
            int n = this.bp;
            Name name = this.readAttributeName();
            this.skipWhitespace();
            List list = null;
            AttributeTree.ValueKind valueKind = AttributeTree.ValueKind.EMPTY;
            if (this.ch == '=') {
                object = new ListBuffer();
                this.nextChar();
                this.skipWhitespace();
                if (this.ch == '\'' || this.ch == '\"') {
                    valueKind = this.ch == '\'' ? AttributeTree.ValueKind.SINGLE : AttributeTree.ValueKind.DOUBLE;
                    char c = this.ch;
                    this.nextChar();
                    this.textStart = this.bp;
                    while (this.bp < this.buflen && this.ch != c) {
                        if (this.newline && this.ch == '@') {
                            listBuffer.add(this.erroneous("dc.unterminated.string", n));
                            break block0;
                        }
                        this.attrValueChar((ListBuffer<DCTree>)object);
                    }
                    this.addPendingText((ListBuffer<DCTree>)object, this.bp - 1);
                    this.nextChar();
                } else {
                    valueKind = AttributeTree.ValueKind.UNQUOTED;
                    this.textStart = this.bp;
                    while (this.bp < this.buflen && !this.isUnquotedAttrValueTerminator(this.ch)) {
                        this.attrValueChar((ListBuffer<DCTree>)object);
                    }
                    this.addPendingText((ListBuffer<DCTree>)object, this.bp - 1);
                }
                this.skipWhitespace();
                list = ((ListBuffer)object).toList();
            }
            object = this.m.at(n).newAttributeTree((javax.lang.model.element.Name)name, valueKind, (java.util.List)list);
            listBuffer.add(object);
        }
        return listBuffer.toList();
    }

    protected void attrValueChar(ListBuffer<DCTree> listBuffer) {
        switch (this.ch) {
            case '&': {
                this.entity(listBuffer);
                break;
            }
            case '{': {
                this.inlineTag(listBuffer);
                break;
            }
            default: {
                this.nextChar();
            }
        }
    }

    protected void addPendingText(ListBuffer<DCTree> listBuffer, int n) {
        if (this.textStart != -1) {
            if (this.textStart <= n) {
                listBuffer.add(this.m.at(this.textStart).newTextTree(this.newString(this.textStart, n + 1)));
            }
            this.textStart = -1;
        }
    }

    protected DCTree.DCErroneous erroneous(String string, int n) {
        int n2;
        block4: for (n2 = this.bp - 1; n2 > n; --n2) {
            switch (this.buf[n2]) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    continue block4;
                }
            }
        }
        this.textStart = -1;
        return this.m.at(n).newErroneousTree(this.newString(n, n2 + 1), this.diagSource, string, new Object[0]);
    }

    protected boolean isIdentifierStart(char c) {
        return Character.isUnicodeIdentifierStart(c);
    }

    protected Name readIdentifier() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isUnicodeIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, n, this.bp - n);
    }

    protected Name readAttributeName() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '-')) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, n, this.bp - n);
    }

    protected Name readTagName() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '.' || this.ch == '-' || this.ch == ':')) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, n, this.bp - n);
    }

    protected boolean isJavaIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    protected Name readJavaIdentifier() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isJavaIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, n, this.bp - n);
    }

    protected boolean isDecimalDigit(char c) {
        return '0' <= c && c <= '9';
    }

    protected boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    protected boolean isUnquotedAttrValueTerminator(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\"': 
            case '\'': 
            case '<': 
            case '=': 
            case '>': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    protected boolean isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    protected void skipWhitespace() {
        while (this.isWhitespace(this.ch)) {
            this.nextChar();
        }
    }

    String newString(int n, int n2) {
        return new String(this.buf, n, n2 - n);
    }

    private void initTagParsers() {
        TagParser[] tagParserArray = new TagParser[]{new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.AUTHOR){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newAuthorTree(list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.CODE, true){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree dCTree = DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_FIRST_SPACE);
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(n).newCodeTree((DCTree.DCText)dCTree);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.DEPRECATED){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newDeprecatedTree(list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.DOC_ROOT){

            @Override
            public DCTree parse(int n) throws ParseException {
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(n).newDocRootTree();
                }
                DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                DocCommentParser.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.EXCEPTION){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference dCReference = DocCommentParser.this.reference(false);
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newExceptionTree((ReferenceTree)dCReference, list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.HIDDEN){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newHiddenTree(list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.INDEX){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCText dCText;
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    throw new ParseException("dc.no.content");
                }
                DCTree.DCText dCText2 = dCText = DocCommentParser.this.ch == '\"' ? DocCommentParser.this.quotedString() : DocCommentParser.this.inlineWord();
                if (dCText == null) {
                    throw new ParseException("dc.no.content");
                }
                DocCommentParser.this.skipWhitespace();
                List list = List.nil();
                if (DocCommentParser.this.ch != '}') {
                    list = DocCommentParser.this.inlineContent();
                } else {
                    DocCommentParser.this.nextChar();
                }
                return DocCommentParser.this.m.at(n).newIndexTree((DocTree)dCText, (java.util.List)list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.INHERIT_DOC){

            @Override
            public DCTree parse(int n) throws ParseException {
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(n).newInheritDocTree();
                }
                DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                DocCommentParser.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LINK){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCReference dCReference = DocCommentParser.this.reference(true);
                List list = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(n).newLinkTree((ReferenceTree)dCReference, (java.util.List)list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LINK_PLAIN){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCReference dCReference = DocCommentParser.this.reference(true);
                List list = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(n).newLinkPlainTree((ReferenceTree)dCReference, (java.util.List)list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LITERAL, true){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree dCTree = DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_FIRST_SPACE);
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(n).newLiteralTree((DCTree.DCText)dCTree);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.PARAM){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                boolean bl = false;
                if (DocCommentParser.this.ch == '<') {
                    bl = true;
                    DocCommentParser.this.nextChar();
                }
                DCTree.DCIdentifier dCIdentifier = DocCommentParser.this.identifier();
                if (bl) {
                    if (DocCommentParser.this.ch != '>') {
                        throw new ParseException("dc.gt.expected");
                    }
                    DocCommentParser.this.nextChar();
                }
                DocCommentParser.this.skipWhitespace();
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newParamTree(bl, (IdentifierTree)dCIdentifier, list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.PROVIDES){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference dCReference = DocCommentParser.this.reference(true);
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newProvidesTree((ReferenceTree)dCReference, list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.RETURN){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newReturnTree(list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SEE){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                switch (DocCommentParser.this.ch) {
                    case '\"': {
                        DCTree.DCText dCText = DocCommentParser.this.quotedString();
                        if (dCText == null) break;
                        DocCommentParser.this.skipWhitespace();
                        if (DocCommentParser.this.ch != '@' && (DocCommentParser.this.ch != '\u001a' || DocCommentParser.this.bp != DocCommentParser.this.buf.length - 1)) break;
                        return DocCommentParser.this.m.at(n).newSeeTree(List.of(dCText));
                    }
                    case '<': {
                        List<DCTree> list = DocCommentParser.this.blockContent();
                        if (list == null) break;
                        return DocCommentParser.this.m.at(n).newSeeTree(list);
                    }
                    case '@': {
                        if (!DocCommentParser.this.newline) break;
                        throw new ParseException("dc.no.content");
                    }
                    case '\u001a': {
                        if (DocCommentParser.this.bp != DocCommentParser.this.buf.length - 1) break;
                        throw new ParseException("dc.no.content");
                    }
                    default: {
                        if (!DocCommentParser.this.isJavaIdentifierStart(DocCommentParser.this.ch) && DocCommentParser.this.ch != '#') break;
                        DCTree.DCReference dCReference = DocCommentParser.this.reference(true);
                        List<DCTree> list = DocCommentParser.this.blockContent();
                        return DocCommentParser.this.m.at(n).newSeeTree(list.prepend(dCReference));
                    }
                }
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL_DATA){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newSerialDataTree(list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL_FIELD){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCIdentifier dCIdentifier = DocCommentParser.this.identifier();
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference dCReference = DocCommentParser.this.reference(false);
                List<DCTree> list = null;
                if (DocCommentParser.this.isWhitespace(DocCommentParser.this.ch)) {
                    DocCommentParser.this.skipWhitespace();
                    list = DocCommentParser.this.blockContent();
                }
                return DocCommentParser.this.m.at(n).newSerialFieldTree((IdentifierTree)dCIdentifier, (ReferenceTree)dCReference, list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newSerialTree(list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SINCE){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newSinceTree(list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.THROWS){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference dCReference = DocCommentParser.this.reference(false);
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newThrowsTree((ReferenceTree)dCReference, list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.USES){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference dCReference = DocCommentParser.this.reference(true);
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newUsesTree((ReferenceTree)dCReference, list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.VALUE){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCReference dCReference = DocCommentParser.this.reference(true);
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(n).newValueTree(dCReference);
                }
                DocCommentParser.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.VERSION){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newVersionTree(list);
            }
        }};
        this.tagParsers = new HashMap<Name, TagParser>();
        for (TagParser tagParser : tagParserArray) {
            this.tagParsers.put(this.names.fromString(tagParser.getTreeKind().tagName), tagParser);
        }
    }

    static abstract class TagParser {
        final Kind kind;
        final DocTree.Kind treeKind;
        final boolean retainWhiteSpace;

        TagParser(Kind kind, DocTree.Kind kind2) {
            this.kind = kind;
            this.treeKind = kind2;
            this.retainWhiteSpace = false;
        }

        TagParser(Kind kind, DocTree.Kind kind2, boolean bl) {
            this.kind = kind;
            this.treeKind = kind2;
            this.retainWhiteSpace = bl;
        }

        Kind getKind() {
            return this.kind;
        }

        DocTree.Kind getTreeKind() {
            return this.treeKind;
        }

        abstract DCTree parse(int var1) throws ParseException;

        static enum Kind {
            INLINE,
            BLOCK;

        }
    }

    private static enum WhitespaceRetentionPolicy {
        RETAIN_ALL,
        REMOVE_FIRST_SPACE,
        REMOVE_ALL;

    }

    static class ParseException
    extends Exception {
        private static final long serialVersionUID = 0L;

        ParseException(String string) {
            super(string);
        }
    }
}

