import re
from .config import SettingsList, write_content_to_file, find_start_end_indexes
from .update_autogenerated_functions import add_autogenerated_functions


def generate():
    from .config import DUCKDB_AUTOGENERATED_SETTINGS_FILE

    print(f"Updating {DUCKDB_AUTOGENERATED_SETTINGS_FILE}")
    new_autogenerated_content, generated = add_autogenerated_functions(DUCKDB_AUTOGENERATED_SETTINGS_FILE)
    write_content_to_file(new_autogenerated_content, DUCKDB_AUTOGENERATED_SETTINGS_FILE)

    # NOTE: for debugging purposes
    # print(f"The total number of settings is {len(SettingsList)}, and {generated} settings are added in {DUCKDB_AUTOGENERATED_SETTINGS_FILE} and, {added_custom} new and {existing_custom} existing added in {DUCKDB_CUSTOM_DEFINED_SETTINGS_FILE}")


if __name__ == '__main__':
    raise ValueError("Please use 'generate_settings.py' instead of running the individual script(s)")
