/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.ops4j.io;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import shaded.org.ops4j.io.Lister;
import shaded.org.ops4j.lang.NullArgumentException;

public class DirectoryLister
implements Lister {
    private final File m_dir;
    private final Pattern[] m_includes;
    private final Pattern[] m_excludes;

    public DirectoryLister(File dir, Pattern filter) {
        NullArgumentException.validateNotNull(dir, "Directory");
        NullArgumentException.validateNotNull(filter, "Filter");
        this.m_dir = dir;
        this.m_includes = new Pattern[]{filter};
        this.m_excludes = new Pattern[0];
    }

    public DirectoryLister(File dir, Pattern[] includes, Pattern[] excludes) {
        NullArgumentException.validateNotNull(dir, "Directory");
        NullArgumentException.validateNotNull(includes, "Include filters");
        NullArgumentException.validateNotNull(includes, "Exclude filters");
        this.m_dir = dir;
        this.m_includes = includes;
        this.m_excludes = excludes;
    }

    @Override
    public List<URL> list() throws MalformedURLException {
        ArrayList<URL> content = new ArrayList<URL>();
        List<String> fileNames = this.listFiles(this.m_dir, "");
        for (String fileName : fileNames) {
            File fileToAdd;
            if (!this.matchesIncludes(fileName) || this.matchesExcludes(fileName) || (fileToAdd = new File(this.m_dir, fileName)).isHidden() || fileName.startsWith(".")) continue;
            content.add(fileToAdd.toURI().toURL());
        }
        return content;
    }

    private boolean matchesIncludes(String fileName) {
        if (this.m_includes.length == 0) {
            return true;
        }
        for (Pattern include : this.m_includes) {
            if (!include.matcher(fileName).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean matchesExcludes(String fileName) {
        for (Pattern include : this.m_excludes) {
            if (!include.matcher(fileName).matches()) continue;
            return true;
        }
        return false;
    }

    private List<String> listFiles(File dir, String parentName) {
        ArrayList<String> fileNames = new ArrayList<String>();
        File[] files = null;
        if (dir.canRead()) {
            files = dir.listFiles();
        }
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    fileNames.addAll(this.listFiles(file, parentName + file.getName() + "/"));
                    continue;
                }
                fileNames.add(parentName + file.getName());
            }
        }
        return fileNames;
    }
}

