/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.composite;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.handler.ActionHandler;
import org.openhab.core.automation.internal.composite.AbstractCompositeModuleHandler;
import org.openhab.core.automation.type.CompositeActionType;
import org.openhab.core.automation.type.Output;
import org.openhab.core.automation.util.ReferenceResolver;

@NonNullByDefault
public class CompositeActionHandler
extends AbstractCompositeModuleHandler<Action, CompositeActionType, ActionHandler>
implements ActionHandler {
    public static final String REFERENCE = "reference";
    private final Map<String, Output> compositeOutputs;

    public CompositeActionHandler(Action action, CompositeActionType mt, LinkedHashMap<Action, @Nullable ActionHandler> mapModuleToHandler, String ruleUID) {
        super(action, mt, mapModuleToHandler);
        this.compositeOutputs = this.getCompositeOutputMap(((CompositeActionType)this.moduleType).getOutputs());
    }

    @Override
    public @Nullable Map<String, @Nullable Object> execute(Map<String, Object> context) {
        HashMap<String, @Nullable Object> result = new HashMap<String, Object>();
        List<Action> children = this.getChildren();
        Map<String, Object> compositeContext = this.getCompositeContext(context);
        for (Action child : children) {
            Map<String, Object> childResults;
            ActionHandler childHandler = (ActionHandler)this.moduleHandlerMap.get(child);
            Map<String, Object> childContext = Collections.unmodifiableMap(this.getChildContext(child, compositeContext));
            Map<String, Object> map = childResults = childHandler == null ? null : childHandler.execute(childContext);
            if (childResults == null) continue;
            for (Map.Entry<String, Object> childResult : childResults.entrySet()) {
                String childOuputName = child.getId() + "." + childResult.getKey();
                Output output = this.compositeOutputs.get(childOuputName);
                if (output == null) continue;
                String childOuputRef = output.getReference();
                if (childOuputRef != null && childOuputRef.length() > childOuputName.length()) {
                    childOuputRef = childOuputRef.substring(childOuputName.length());
                    result.put(output.getName(), ReferenceResolver.resolveComplexDataReference(childResult.getValue(), childOuputRef));
                    continue;
                }
                result.put(output.getName(), childResult.getValue());
            }
        }
        return !result.isEmpty() ? result : null;
    }

    protected Map<String, Output> getCompositeOutputMap(List<Output> outputs) {
        HashMap<String, Output> result = new HashMap<String, Output>(11);
        for (Output output : outputs) {
            String refs = output.getReference();
            if (refs == null) continue;
            StringTokenizer st = new StringTokenizer(refs, ",");
            while (st.hasMoreTokens()) {
                int j;
                String ref = st.nextToken().trim();
                int i = ref.indexOf(46);
                if (i != -1 && (j = ReferenceResolver.getNextRefToken(ref, i + 1)) != -1) {
                    ref = ref.substring(0, j);
                }
                result.put(ref, output);
            }
        }
        return result;
    }

    @Override
    protected List<Action> getChildren() {
        return ((CompositeActionType)this.moduleType).getChildren();
    }
}

