#ifndef STRINGS_LOCALIZATION_H
#define STRINGS_LOCALIZATION_H

#include "SGPFile.h"
#include "stracciatella.h"
#include <string_theory/string>
#include <array>
#include <cstdint>
#include <memory>


namespace L10n
{
// Get the file suffix (-eng, -pl, etc.) for a GameVersion.
// @param combineRusAndRusGold
//          True: return "-rus" for both russian and russian gold 
//          False: return "-rus" or "-rusgold"
char const * GetSuffix(VanillaVersion, bool combineRusAndRusGold);

constexpr std::size_t WeaponType_SIZE = 9;
constexpr std::size_t TeamTurnString_SIZE = 5;
constexpr std::size_t Message_SIZE = 59;
constexpr std::size_t sTimeStrings_SIZE = 6;
constexpr std::size_t pAssignmentStrings_SIZE = 35;
constexpr std::size_t pMilitiaString_SIZE = 3;
constexpr std::size_t pMilitiaButtonString_SIZE = 2;
constexpr std::size_t pConditionStrings_SIZE = 9;
constexpr std::size_t pEpcMenuStrings_SIZE = 5;
constexpr std::size_t pLongAssignmentStrings_SIZE = 35;
constexpr std::size_t pContractStrings_SIZE = 7;
constexpr std::size_t pPOWStrings_SIZE = 2;
constexpr std::size_t pInvPanelTitleStrings_SIZE = 3;
constexpr std::size_t pShortAttributeStrings_SIZE = 10;
constexpr std::size_t pUpperLeftMapScreenStrings_SIZE = 4;
constexpr std::size_t pTrainingStrings_SIZE = 4;
constexpr std::size_t pAssignMenuStrings_SIZE = 7;
constexpr std::size_t pRemoveMercStrings_SIZE = 2;
constexpr std::size_t pAttributeMenuStrings_SIZE = 10;
constexpr std::size_t pTrainingMenuStrings_SIZE = 5;
constexpr std::size_t pSquadMenuStrings_SIZE = 21;
constexpr std::size_t pPersonnelScreenStrings_SIZE = 14;
constexpr std::size_t gzMercSkillText_SIZE = 17;
constexpr std::size_t pTacticalPopupButtonStrings_SIZE = 19;
constexpr std::size_t pDoorTrapStrings_SIZE = 5;
constexpr std::size_t pMapScreenMouseRegionHelpText_SIZE = 6;
constexpr std::size_t pNoiseVolStr_SIZE = 4;
constexpr std::size_t pNoiseTypeStr_SIZE = 12;
constexpr std::size_t pDirectionStr_SIZE = 8;
constexpr std::size_t gpStrategicString_SIZE = 69;
constexpr std::size_t sKeyDescriptionStrings_SIZE = 2;
constexpr std::size_t gWeaponStatsDesc_SIZE = 7;
constexpr std::size_t gzMoneyAmounts_SIZE = 6;
constexpr std::size_t zVehicleName_SIZE = 6;
constexpr std::size_t const_SIZE = 137;
constexpr std::size_t pExitingSectorHelpText_SIZE = 14;
constexpr std::size_t pRepairStrings_SIZE = 4;
constexpr std::size_t sPreStatBuildString_SIZE = 6;
constexpr std::size_t sStatGainStrings_SIZE = 11;
constexpr std::size_t pHelicopterEtaStrings_SIZE = 10;
constexpr std::size_t gsTimeStrings_SIZE = 4;
constexpr std::size_t sFacilitiesStrings_SIZE = 7;
constexpr std::size_t pMapPopUpInventoryText_SIZE = 2;
constexpr std::size_t pwTownInfoStrings_SIZE = 7;
constexpr std::size_t pwMineStrings_SIZE = 14;
constexpr std::size_t pwMiscSectorStrings_SIZE = 7;
constexpr std::size_t pMapInventoryErrorString_SIZE = 5;
constexpr std::size_t pMapInventoryStrings_SIZE = 2;
constexpr std::size_t pMovementMenuStrings_SIZE = 4;
constexpr std::size_t pUpdateMercStrings_SIZE = 6;
constexpr std::size_t pMapScreenBorderButtonHelpText_SIZE = 6;
constexpr std::size_t pMapScreenBottomFastHelp_SIZE = 8;
constexpr std::size_t pSenderNameList_SIZE = 51;
constexpr std::size_t pDeleteMailStrings_SIZE = 2;
constexpr std::size_t pEmailHeaders_SIZE = 3;
constexpr std::size_t pFinanceSummary_SIZE = 12;
constexpr std::size_t pFinanceHeaders_SIZE = 7;
constexpr std::size_t pTransactionText_SIZE = 28;
constexpr std::size_t pSkyriderText_SIZE = 3;
constexpr std::size_t pMoralStrings_SIZE = 6;
constexpr std::size_t pMapScreenStatusStrings_SIZE = 5;
constexpr std::size_t pMapScreenPrevNextCharButtonHelpText_SIZE = 2;
constexpr std::size_t pShortVehicleStrings_SIZE = 6;
constexpr std::size_t pVehicleStrings_SIZE = 6;
constexpr std::size_t pTrashItemText_SIZE = 2;
constexpr std::size_t pMapErrorString_SIZE = 50;
constexpr std::size_t pMapPlotStrings_SIZE = 5;
constexpr std::size_t pBullseyeStrings_SIZE = 5;
constexpr std::size_t pMiscMapScreenMouseRegionHelpText_SIZE = 3;
constexpr std::size_t pImpPopUpStrings_SIZE = 7;
constexpr std::size_t pImpButtonText_SIZE = 27;
constexpr std::size_t pExtraIMPStrings_SIZE = 4;
constexpr std::size_t gzIMPSkillTraitsText_SIZE = 16;
constexpr std::size_t pFilesSenderList_SIZE = 7;
constexpr std::size_t pHistoryHeaders_SIZE = 5;
constexpr std::size_t pHistoryStrings_SIZE = 78;
constexpr std::size_t pLaptopIcons_SIZE = 8;
constexpr std::size_t pBookMarkStrings_SIZE = 8;
constexpr std::size_t pDownloadString_SIZE = 2;
constexpr std::size_t gsAtmStartButtonText_SIZE = 3;
constexpr std::size_t pWebPagesTitles_SIZE = 35;
constexpr std::size_t pShowBookmarkString_SIZE = 2;
constexpr std::size_t pLaptopTitles_SIZE = 5;
constexpr std::size_t pPersonnelDepartedStateStrings_SIZE = 5;
constexpr std::size_t pPersonelTeamStrings_SIZE = 8;
constexpr std::size_t pPersonnelCurrentTeamStatsStrings_SIZE = 3;
constexpr std::size_t pPersonnelTeamStatsStrings_SIZE = 11;
constexpr std::size_t pMapVertIndex_SIZE = 17;
constexpr std::size_t pMapHortIndex_SIZE = 17;
constexpr std::size_t pMapDepthIndex_SIZE = 4;
constexpr std::size_t pUpdatePanelButtons_SIZE = 2;
constexpr std::size_t LargeTacticalStr_SIZE = 4;
constexpr std::size_t InsContractText_SIZE = 4;
constexpr std::size_t InsInfoText_SIZE = 2;
constexpr std::size_t MercAccountText_SIZE = 9;
constexpr std::size_t MercInfo_SIZE = 11;
constexpr std::size_t MercNoAccountText_SIZE = 3;
constexpr std::size_t MercHomePageText_SIZE = 5;
constexpr std::size_t sFuneralString_SIZE = 12;
constexpr std::size_t sFloristText_SIZE = 14;
constexpr std::size_t sOrderFormText_SIZE = 22;
constexpr std::size_t sFloristGalleryText_SIZE = 5;
constexpr std::size_t sFloristCards_SIZE = 2;
constexpr std::size_t BobbyROrderFormText_SIZE = 26;
constexpr std::size_t BobbyRText_SIZE = 26;
constexpr std::size_t BobbyRaysFrontText_SIZE = 9;
constexpr std::size_t AimSortText_SIZE = 5;
constexpr std::size_t AimPolicyText_SIZE = 6;
constexpr std::size_t AimMemberText_SIZE = 4;
constexpr std::size_t CharacterInfo_SIZE = 12;
constexpr std::size_t VideoConfercingText_SIZE = 15;
constexpr std::size_t AimPopUpText_SIZE = 9;
constexpr std::size_t AimHistoryText_SIZE = 5;
constexpr std::size_t AimFiText_SIZE = 14;
constexpr std::size_t AimAlumniText_SIZE = 5;
constexpr std::size_t AimScreenText_SIZE = 8;
constexpr std::size_t AimBottomMenuText_SIZE = 6;
constexpr std::size_t SKI_SIZE = 14;
constexpr std::size_t SkiMessageBoxText_SIZE = 7;
constexpr std::size_t zOptionsText_SIZE = 9;
constexpr std::size_t zSaveLoadText_SIZE = 24;
constexpr std::size_t zMarksMapScreenText_SIZE = 23;
constexpr std::size_t pMilitiaConfirmStrings_SIZE = 10;
constexpr std::size_t gpDemoString_SIZE = 41;
constexpr std::size_t gpDemoIntroString_SIZE = 6;
constexpr std::size_t gzMoneyWithdrawMessageText_SIZE = 2;
constexpr std::size_t zOptionsToggleText_SIZE = 20;
constexpr std::size_t gzGIOScreenText_SIZE = 17;
constexpr std::size_t pPausedGameText_SIZE = 3;
constexpr std::size_t pMessageStrings_SIZE = 68;
constexpr std::size_t pDoctorWarningString_SIZE = 2;
constexpr std::size_t pMilitiaButtonsHelpText_SIZE = 4;
constexpr std::size_t gzLaptopHelpText_SIZE = 16;
constexpr std::size_t gzNonPersistantPBIText_SIZE = 10;
constexpr std::size_t gzMiscString_SIZE = 5;
constexpr std::size_t pNewNoiseStr_SIZE = 11;
constexpr std::size_t wMapScreenSortButtonHelpText_SIZE = 6;
constexpr std::size_t BrokenLinkText_SIZE = 2;
constexpr std::size_t gzBobbyRShipmentText_SIZE = 4;
constexpr std::size_t gzCreditNames_SIZE = 15;
constexpr std::size_t gzCreditNameTitle_SIZE = 15;
constexpr std::size_t gzCreditNameFunny_SIZE = 15;
constexpr std::size_t sRepairsDoneString_SIZE = 4;
constexpr std::size_t zGioDifConfirmText_SIZE = 3;
constexpr std::size_t gzLateLocalizedString_SIZE = 58;
constexpr std::size_t zOptionsScreenHelpText_SIZE = 20;
constexpr std::size_t ItemPickupHelpPopup_SIZE = 5;
constexpr std::size_t TacticalStr_SIZE = 137;
constexpr std::size_t zDealerStrings_SIZE = 4;
constexpr std::size_t zTalkMenuStrings_SIZE = 6;
constexpr std::size_t gMoneyStatsDesc_SIZE = 8;
constexpr std::size_t zHealthStr_SIZE = 7;
constexpr std::size_t SKI_Text_SIZE = 14;
constexpr std::size_t str_stat_list_SIZE = 11;
constexpr std::size_t str_aim_sort_list_SIZE = 8;
constexpr std::size_t zNewTacticalMessages_SIZE = 7;
constexpr std::size_t gs_dead_is_dead_mode_tab_name_SIZE = 2;

#define STRARRAY(arrayName) std::array<ST::string , arrayName##_SIZE> arrayName

struct L10n_t
{
	L10n_t(SGPFile * translationFile);

	STRARRAY(WeaponType);
	STRARRAY(Message);
	STRARRAY(TeamTurnString);
	STRARRAY(pAssignMenuStrings);
	STRARRAY(pTrainingStrings);
	STRARRAY(pTrainingMenuStrings);
	STRARRAY(pAttributeMenuStrings);
	STRARRAY(pVehicleStrings);
	STRARRAY(pShortAttributeStrings);
	STRARRAY(pContractStrings);
	STRARRAY(pAssignmentStrings);
	STRARRAY(pConditionStrings);
	STRARRAY(pPersonnelScreenStrings);
	STRARRAY(pUpperLeftMapScreenStrings);
	STRARRAY(pTacticalPopupButtonStrings);
	STRARRAY(pSquadMenuStrings);
	STRARRAY(pDoorTrapStrings);
	STRARRAY(pLongAssignmentStrings);
	STRARRAY(pMapScreenMouseRegionHelpText);
	STRARRAY(pNoiseVolStr);
	STRARRAY(pNoiseTypeStr);
	STRARRAY(pDirectionStr);
	STRARRAY(pRemoveMercStrings);
	STRARRAY(sTimeStrings);
	STRARRAY(pInvPanelTitleStrings);
	STRARRAY(pPOWStrings);
	STRARRAY(pMilitiaString);
	STRARRAY(pMilitiaButtonString);
	STRARRAY(pEpcMenuStrings);
	STRARRAY(pRepairStrings);
	STRARRAY(sPreStatBuildString);
	STRARRAY(sStatGainStrings);
	STRARRAY(pHelicopterEtaStrings);
	ST::string sMapLevelString;
	ST::string gsLoyalString;
	ST::string gsUndergroundString;
	STRARRAY(gsTimeStrings);
	STRARRAY(sFacilitiesStrings);
	STRARRAY(pMapPopUpInventoryText);
	STRARRAY(pwTownInfoStrings);
	STRARRAY(pwMineStrings);
	STRARRAY(pwMiscSectorStrings);
	STRARRAY(pMapInventoryErrorString);
	STRARRAY(pMapInventoryStrings);
	STRARRAY(pMovementMenuStrings);
	STRARRAY(pUpdateMercStrings);
	STRARRAY(pMapScreenBorderButtonHelpText);
	STRARRAY(pMapScreenBottomFastHelp);
	ST::string pMapScreenBottomText;
	ST::string pMercDeadString;
	STRARRAY(pSenderNameList);
	ST::string pNewMailStrings;
	STRARRAY(pDeleteMailStrings);
	STRARRAY(pEmailHeaders);
	ST::string pEmailTitleText;
	ST::string pFinanceTitle;
	STRARRAY(pFinanceSummary);
	STRARRAY(pFinanceHeaders);
	STRARRAY(pTransactionText);
	STRARRAY(pMoralStrings);
	STRARRAY(pSkyriderText);
	ST::string str_left_equipment;
	STRARRAY(pMapScreenStatusStrings);
	STRARRAY(pMapScreenPrevNextCharButtonHelpText);
	ST::string pEtaString;
	STRARRAY(pShortVehicleStrings);
	STRARRAY(pTrashItemText);
	STRARRAY(pMapErrorString);
	STRARRAY(pMapPlotStrings);
	STRARRAY(pBullseyeStrings);
	STRARRAY(pMiscMapScreenMouseRegionHelpText);
	ST::string str_he_leaves_where_drop_equipment;
	ST::string str_she_leaves_where_drop_equipment;
	ST::string str_he_leaves_drops_equipment;
	ST::string str_she_leaves_drops_equipment;
	STRARRAY(pImpPopUpStrings);
	STRARRAY(pImpButtonText);
	STRARRAY(pExtraIMPStrings);
	ST::string pFilesTitle;
	STRARRAY(pFilesSenderList);
	ST::string pHistoryLocations;
	STRARRAY(pHistoryStrings);
	STRARRAY(pHistoryHeaders);
	ST::string pHistoryTitle;
	STRARRAY(pShowBookmarkString);
	STRARRAY(pWebPagesTitles);
	ST::string pWebTitle;
	ST::string pPersonnelString;
	ST::string pErrorStrings;
	STRARRAY(pDownloadString);
	STRARRAY(pBookMarkStrings);
	STRARRAY(pLaptopIcons);
	STRARRAY(gsAtmStartButtonText);
	STRARRAY(pPersonnelTeamStatsStrings);
	STRARRAY(pPersonnelCurrentTeamStatsStrings);
	STRARRAY(pPersonelTeamStrings);
	STRARRAY(pPersonnelDepartedStateStrings);
	STRARRAY(pMapHortIndex);
	STRARRAY(pMapVertIndex);
	STRARRAY(pMapDepthIndex);
	STRARRAY(pLaptopTitles);
	ST::string pDayStrings;
	STRARRAY(pMilitiaConfirmStrings);
	ST::string pSkillAtZeroWarning;
	ST::string pIMPBeginScreenStrings;
	ST::string pIMPFinishButtonText;
	ST::string pIMPFinishStrings;
	ST::string pIMPVoicesStrings;
	ST::string pPersTitleText;
	STRARRAY(pPausedGameText);
	STRARRAY(zOptionsToggleText);
	STRARRAY(zOptionsScreenHelpText);
	STRARRAY(pDoctorWarningString);
	STRARRAY(pMilitiaButtonsHelpText);
	ST::string pMapScreenJustStartedHelpText;
	ST::string pLandMarkInSectorString;
	STRARRAY(gzMercSkillText);
	STRARRAY(gzNonPersistantPBIText);
	STRARRAY(gzMiscString);
	STRARRAY(wMapScreenSortButtonHelpText);
	STRARRAY(pNewNoiseStr);
	STRARRAY(gzLateLocalizedString);
	ST::string pAntiHackerString;
	STRARRAY(pMessageStrings);
	STRARRAY(ItemPickupHelpPopup);
	STRARRAY(TacticalStr);
	STRARRAY(LargeTacticalStr);
	ST::string zDialogActions;
	STRARRAY(zDealerStrings);
	STRARRAY(zTalkMenuStrings);
	STRARRAY(gzMoneyAmounts);
	ST::string gzProsLabel;
	ST::string gzConsLabel;
	STRARRAY(gMoneyStatsDesc);
	STRARRAY(gWeaponStatsDesc);
	STRARRAY(sKeyDescriptionStrings);
	STRARRAY(zHealthStr);
	STRARRAY(zVehicleName);
	STRARRAY(pExitingSectorHelpText);
	STRARRAY(InsContractText);
	STRARRAY(InsInfoText);
	STRARRAY(MercAccountText);
	STRARRAY(MercInfo);
	STRARRAY(MercNoAccountText);
	STRARRAY(MercHomePageText);
	STRARRAY(sFuneralString);
	STRARRAY(sFloristText);
	STRARRAY(sOrderFormText);
	STRARRAY(sFloristGalleryText);
	STRARRAY(sFloristCards);
	STRARRAY(BobbyROrderFormText);
	STRARRAY(BobbyRText);
	ST::string str_bobbyr_guns_num_guns_that_use_ammo;
	STRARRAY(BobbyRaysFrontText);
	STRARRAY(AimSortText);
	ST::string str_aim_sort_price;
	ST::string str_aim_sort_experience;
	ST::string str_aim_sort_marksmanship;
	ST::string str_aim_sort_medical;
	ST::string str_aim_sort_explosives;
	ST::string str_aim_sort_mechanical;
	ST::string str_aim_sort_ascending;
	ST::string str_aim_sort_descending;
	STRARRAY(AimPolicyText);
	STRARRAY(AimMemberText);
	STRARRAY(CharacterInfo);
	STRARRAY(VideoConfercingText);
	STRARRAY(AimPopUpText);
	ST::string AimLinkText;
	STRARRAY(AimHistoryText);
	STRARRAY(AimFiText);
	STRARRAY(AimAlumniText);
	STRARRAY(AimScreenText);
	STRARRAY(AimBottomMenuText);
	STRARRAY(zMarksMapScreenText);
	STRARRAY(gpStrategicString);
	ST::string gpGameClockString;
	STRARRAY(SKI_Text);
	STRARRAY(SkiMessageBoxText);
	STRARRAY(zSaveLoadText);
	STRARRAY(zOptionsText);
	STRARRAY(gzGIOScreenText);
	ST::string gzHelpScreenText;
	STRARRAY(gzLaptopHelpText);
	STRARRAY(gzMoneyWithdrawMessageText);
	ST::string gzCopyrightText;
	STRARRAY(BrokenLinkText);
	STRARRAY(gzBobbyRShipmentText);
	STRARRAY(zGioDifConfirmText);
	STRARRAY(gzCreditNames);
	STRARRAY(gzCreditNameTitle);
	STRARRAY(gzCreditNameFunny);
	ST::string pContractButtonString;
	ST::string gzIntroScreen;
	STRARRAY(pUpdatePanelButtons);
	STRARRAY(sRepairsDoneString);
	ST::string str_ceramic_plates_smashed;
	ST::string str_arrival_rerouted;

	ST::string str_stat_health;
	ST::string str_stat_agility;
	ST::string str_stat_dexterity;
	ST::string str_stat_strength;
	ST::string str_stat_leadership;
	ST::string str_stat_wisdom;
	ST::string str_stat_exp_level;
	ST::string str_stat_marksmanship;
	ST::string str_stat_mechanical;
	ST::string str_stat_explosive;
	ST::string str_stat_medical;

	STRARRAY(str_stat_list);
	STRARRAY(str_aim_sort_list);

	STRARRAY(zNewTacticalMessages);
	ST::string str_iron_man_mode_warning;
	ST::string str_dead_is_dead_mode_warning;
	ST::string str_dead_is_dead_mode_enter_name;
	STRARRAY(gs_dead_is_dead_mode_tab_name);

	STRARRAY(gzIMPSkillTraitsText);
};
#undef STRARRAY

} // namespace

/** Current language resources. */
inline std::unique_ptr<L10n::L10n_t const> g_langRes;

#endif