/*
 * 86Box    A hypervisor and IBM PC system emulator that specializes in
 *          running old operating systems and software designed for IBM
 *          PC systems and compatibles from 1981 through fairly recent
 *          system designs based on the PCI bus.
 *
 *          This file is part of the 86Box distribution.
 *
 *          Palette definitions for the PGC core.
 *
 * Authors: Fred N. van Kempen, <decwiz@yahoo.com>
 *          John Elliott, <jce@seasip.info>
 *
 *          Copyright 2019 Fred N. van Kempen.
 *          Copyright 2019 John Elliott.
 */
#ifndef VID_PGC_PALETTE_H
#define VID_PGC_PALETTE_H

/* Palette 0: Default */
{
    makecol(0x00, 0x00, 0x00),
    makecol(0x11, 0x11, 0x11),
    makecol(0x22, 0x22, 0x22),
    makecol(0x33, 0x33, 0x33),
    makecol(0x44, 0x44, 0x44),
    makecol(0x55, 0x55, 0x55),
    makecol(0x66, 0x66, 0x66),
    makecol(0x77, 0x77, 0x77),
    makecol(0x88, 0x88, 0x88),
    makecol(0x99, 0x99, 0x99),
    makecol(0xaa, 0xaa, 0xaa),
    makecol(0xbb, 0xbb, 0xbb),
    makecol(0xcc, 0xcc, 0xcc),
    makecol(0xdd, 0xdd, 0xdd),
    makecol(0xee, 0xee, 0xee),
    makecol(0xff, 0xff, 0xff),
    makecol(0x00, 0x00, 0x00),
    makecol(0x00, 0x22, 0x00),
    makecol(0x00, 0x44, 0x00),
    makecol(0x00, 0x66, 0x00),
    makecol(0x00, 0x88, 0x00),
    makecol(0x00, 0xaa, 0x00),
    makecol(0x00, 0xcc, 0x00),
    makecol(0x00, 0xee, 0x00),
    makecol(0x00, 0xff, 0x00),
    makecol(0x22, 0xff, 0x22),
    makecol(0x44, 0xff, 0x44),
    makecol(0x66, 0xff, 0x66),
    makecol(0x88, 0xff, 0x88),
    makecol(0xaa, 0xff, 0xaa),
    makecol(0xcc, 0xff, 0xcc),
    makecol(0xee, 0xff, 0xee),
    makecol(0x00, 0x00, 0x00),
    makecol(0x00, 0x22, 0x11),
    makecol(0x00, 0x44, 0x22),
    makecol(0x00, 0x66, 0x33),
    makecol(0x00, 0x88, 0x44),
    makecol(0x00, 0xaa, 0x55),
    makecol(0x00, 0xcc, 0x66),
    makecol(0x00, 0xee, 0x77),
    makecol(0x00, 0xff, 0x88),
    makecol(0x22, 0xff, 0x99),
    makecol(0x44, 0xff, 0xaa),
    makecol(0x66, 0xff, 0xbb),
    makecol(0x88, 0xff, 0xcc),
    makecol(0xaa, 0xff, 0xdd),
    makecol(0xcc, 0xff, 0xee),
    makecol(0xee, 0xff, 0xff),
    makecol(0x00, 0x00, 0x00),
    makecol(0x00, 0x22, 0x22),
    makecol(0x00, 0x44, 0x44),
    makecol(0x00, 0x66, 0x66),
    makecol(0x00, 0x88, 0x88),
    makecol(0x00, 0xaa, 0xaa),
    makecol(0x00, 0xcc, 0xcc),
    makecol(0x00, 0xee, 0xee),
    makecol(0x00, 0xff, 0xff),
    makecol(0x22, 0xff, 0xff),
    makecol(0x44, 0xff, 0xff),
    makecol(0x66, 0xff, 0xff),
    makecol(0x88, 0xff, 0xff),
    makecol(0xaa, 0xff, 0xff),
    makecol(0xcc, 0xff, 0xff),
    makecol(0xee, 0xff, 0xff),
    makecol(0x00, 0x00, 0x00),
    makecol(0x00, 0x11, 0x22),
    makecol(0x00, 0x22, 0x44),
    makecol(0x00, 0x33, 0x66),
    makecol(0x00, 0x44, 0x88),
    makecol(0x00, 0x55, 0xaa),
    makecol(0x00, 0x66, 0xcc),
    makecol(0x00, 0x77, 0xee),
    makecol(0x00, 0x88, 0xff),
    makecol(0x22, 0x99, 0xff),
    makecol(0x44, 0xaa, 0xff),
    makecol(0x66, 0xbb, 0xff),
    makecol(0x88, 0xcc, 0xff),
    makecol(0xaa, 0xdd, 0xff),
    makecol(0xcc, 0xee, 0xff),
    makecol(0xee, 0xff, 0xff),
    makecol(0x00, 0x00, 0x00),
    makecol(0x00, 0x00, 0x22),
    makecol(0x00, 0x00, 0x44),
    makecol(0x00, 0x00, 0x66),
    makecol(0x00, 0x00, 0x88),
    makecol(0x00, 0x00, 0xaa),
    makecol(0x00, 0x00, 0xcc),
    makecol(0x00, 0x00, 0xee),
    makecol(0x00, 0x00, 0xff),
    makecol(0x22, 0x22, 0xff),
    makecol(0x44, 0x44, 0xff),
    makecol(0x66, 0x66, 0xff),
    makecol(0x88, 0x88, 0xff),
    makecol(0xaa, 0xaa, 0xff),
    makecol(0xcc, 0xcc, 0xff),
    makecol(0xee, 0xee, 0xff),
    makecol(0x00, 0x00, 0x00),
    makecol(0x11, 0x00, 0x22),
    makecol(0x22, 0x00, 0x44),
    makecol(0x33, 0x00, 0x66),
    makecol(0x44, 0x00, 0x88),
    makecol(0x55, 0x00, 0xaa),
    makecol(0x66, 0x00, 0xcc),
    makecol(0x77, 0x00, 0xee),
    makecol(0x88, 0x00, 0xff),
    makecol(0x99, 0x22, 0xff),
    makecol(0xaa, 0x44, 0xff),
    makecol(0xbb, 0x66, 0xff),
    makecol(0xcc, 0x88, 0xff),
    makecol(0xdd, 0xaa, 0xff),
    makecol(0xee, 0xcc, 0xff),
    makecol(0xff, 0xee, 0xff),
    makecol(0x00, 0x00, 0x00),
    makecol(0x22, 0x00, 0x22),
    makecol(0x44, 0x00, 0x44),
    makecol(0x66, 0x00, 0x66),
    makecol(0x88, 0x00, 0x88),
    makecol(0xaa, 0x00, 0xaa),
    makecol(0xcc, 0x00, 0xcc),
    makecol(0xee, 0x00, 0xee),
    makecol(0xff, 0x00, 0xff),
    makecol(0xff, 0x22, 0xff),
    makecol(0xff, 0x44, 0xff),
    makecol(0xff, 0x66, 0xff),
    makecol(0xff, 0x88, 0xff),
    makecol(0xff, 0xaa, 0xff),
    makecol(0xff, 0xcc, 0xff),
    makecol(0xff, 0xee, 0xff),
    makecol(0x00, 0x00, 0x00),
    makecol(0x22, 0x00, 0x11),
    makecol(0x44, 0x00, 0x22),
    makecol(0x66, 0x00, 0x33),
    makecol(0x88, 0x00, 0x44),
    makecol(0xaa, 0x00, 0x55),
    makecol(0xcc, 0x00, 0x66),
    makecol(0xee, 0x00, 0x77),
    makecol(0xff, 0x00, 0x88),
    makecol(0xff, 0x22, 0x99),
    makecol(0xff, 0x44, 0xaa),
    makecol(0xff, 0x66, 0xbb),
    makecol(0xff, 0x88, 0xcc),
    makecol(0xff, 0xaa, 0xdd),
    makecol(0xff, 0xcc, 0xee),
    makecol(0xff, 0xee, 0xff),
    makecol(0x00, 0x00, 0x00),
    makecol(0x22, 0x00, 0x00),
    makecol(0x44, 0x00, 0x00),
    makecol(0x66, 0x00, 0x00),
    makecol(0x88, 0x00, 0x00),
    makecol(0xaa, 0x00, 0x00),
    makecol(0xcc, 0x00, 0x00),
    makecol(0xee, 0x00, 0x00),
    makecol(0xff, 0x00, 0x00),
    makecol(0xff, 0x22, 0x22),
    makecol(0xff, 0x44, 0x44),
    makecol(0xff, 0x66, 0x66),
    makecol(0xff, 0x88, 0x88),
    makecol(0xff, 0xaa, 0xaa),
    makecol(0xff, 0xcc, 0xcc),
    makecol(0xff, 0xee, 0xee),
    makecol(0x00, 0x00, 0x00),
    makecol(0x22, 0x11, 0x00),
    makecol(0x44, 0x22, 0x00),
    makecol(0x66, 0x33, 0x00),
    makecol(0x88, 0x44, 0x00),
    makecol(0xaa, 0x55, 0x00),
    makecol(0xcc, 0x66, 0x00),
    makecol(0xee, 0x77, 0x00),
    makecol(0xff, 0x88, 0x00),
    makecol(0xff, 0x99, 0x22),
    makecol(0xff, 0xaa, 0x44),
    makecol(0xff, 0xbb, 0x66),
    makecol(0xff, 0xcc, 0x88),
    makecol(0xff, 0xdd, 0xaa),
    makecol(0xff, 0xee, 0xcc),
    makecol(0xff, 0xff, 0xee),
    makecol(0x00, 0x00, 0x00),
    makecol(0x22, 0x22, 0x00),
    makecol(0x44, 0x44, 0x00),
    makecol(0x66, 0x66, 0x00),
    makecol(0x88, 0x88, 0x00),
    makecol(0xaa, 0xaa, 0x00),
    makecol(0xcc, 0xcc, 0x00),
    makecol(0xee, 0xee, 0x00),
    makecol(0xff, 0xff, 0x00),
    makecol(0xff, 0xff, 0x22),
    makecol(0xff, 0xff, 0x44),
    makecol(0xff, 0xff, 0x66),
    makecol(0xff, 0xff, 0x88),
    makecol(0xff, 0xff, 0xaa),
    makecol(0xff, 0xff, 0xcc),
    makecol(0xff, 0xff, 0xee),
    makecol(0x00, 0x00, 0x00),
    makecol(0x11, 0x22, 0x00),
    makecol(0x22, 0x44, 0x00),
    makecol(0x33, 0x66, 0x00),
    makecol(0x44, 0x88, 0x00),
    makecol(0x55, 0xaa, 0x00),
    makecol(0x66, 0xcc, 0x00),
    makecol(0x77, 0xee, 0x00),
    makecol(0x88, 0xff, 0x00),
    makecol(0x99, 0xff, 0x22),
    makecol(0xaa, 0xff, 0x44),
    makecol(0xbb, 0xff, 0x66),
    makecol(0xcc, 0xff, 0x88),
    makecol(0xdd, 0xff, 0xaa),
    makecol(0xee, 0xff, 0xcc),
    makecol(0xff, 0xff, 0xee),
    makecol(0x00, 0x00, 0x00),
    makecol(0x00, 0x11, 0x00),
    makecol(0x11, 0x33, 0x11),
    makecol(0x11, 0x44, 0x11),
    makecol(0x22, 0x66, 0x22),
    makecol(0x22, 0x77, 0x22),
    makecol(0x33, 0x99, 0x33),
    makecol(0x33, 0xaa, 0x33),
    makecol(0x44, 0xcc, 0x44),
    makecol(0x55, 0xcc, 0x55),
    makecol(0x77, 0xdd, 0x77),
    makecol(0x88, 0xdd, 0x88),
    makecol(0xaa, 0xee, 0xaa),
    makecol(0xbb, 0xee, 0xbb),
    makecol(0xdd, 0xff, 0xdd),
    makecol(0xee, 0xff, 0xee),
    makecol(0x00, 0x00, 0x00),
    makecol(0x11, 0x00, 0x00),
    makecol(0x33, 0x11, 0x11),
    makecol(0x44, 0x11, 0x11),
    makecol(0x66, 0x22, 0x22),
    makecol(0x77, 0x22, 0x22),
    makecol(0x99, 0x33, 0x33),
    makecol(0xaa, 0x33, 0x33),
    makecol(0xcc, 0x44, 0x44),
    makecol(0xcc, 0x55, 0x55),
    makecol(0xdd, 0x77, 0x77),
    makecol(0xdd, 0x88, 0x88),
    makecol(0xee, 0xaa, 0xaa),
    makecol(0xee, 0xbb, 0xbb),
    makecol(0xff, 0xdd, 0xdd),
    makecol(0xff, 0xee, 0xee),
    makecol(0x00, 0x00, 0x00),
    makecol(0x00, 0x00, 0x11),
    makecol(0x11, 0x11, 0x33),
    makecol(0x11, 0x11, 0x44),
    makecol(0x22, 0x22, 0x66),
    makecol(0x22, 0x22, 0x77),
    makecol(0x33, 0x33, 0x99),
    makecol(0x33, 0x33, 0xaa),
    makecol(0x44, 0x44, 0xcc),
    makecol(0x55, 0x55, 0xcc),
    makecol(0x77, 0x77, 0xdd),
    makecol(0x88, 0x88, 0xdd),
    makecol(0xaa, 0xaa, 0xee),
    makecol(0xbb, 0xbb, 0xee),
    makecol(0xdd, 0xdd, 0xff),
    makecol(0xee, 0xee, 0xff),
},
    /* Palette 1: 16-colour palette */
    {
        makecol(0x88, 0x66, 0xdd),
        makecol(0x00, 0x00, 0x00),
        makecol(0x44, 0x77, 0x22),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x99, 0xee, 0x66),
        makecol(0x77, 0x77, 0x77),
        makecol(0xff, 0xff, 0xff),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x44, 0x77, 0x22),
        makecol(0x44, 0x77, 0x22),
        makecol(0x44, 0x77, 0x22),
        makecol(0x44, 0x77, 0x22),
        makecol(0x44, 0x77, 0x22),
        makecol(0x44, 0x77, 0x22),
        makecol(0x44, 0x77, 0x22),
        makecol(0x44, 0x77, 0x22),
        makecol(0x44, 0x77, 0x22),
        makecol(0x44, 0x77, 0x22),
        makecol(0x44, 0x77, 0x22),
        makecol(0x44, 0x77, 0x22),
        makecol(0x44, 0x77, 0x22),
        makecol(0x44, 0x77, 0x22),
        makecol(0x44, 0x77, 0x22),
        makecol(0x44, 0x77, 0x22),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x77, 0xaa, 0x44),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x77),
        makecol(0x77, 0x00, 0x77),
        makecol(0x77, 0x00, 0x77),
        makecol(0x77, 0x00, 0x77),
        makecol(0x77, 0x00, 0x77),
        makecol(0x77, 0x00, 0x77),
        makecol(0x77, 0x00, 0x77),
        makecol(0x77, 0x00, 0x77),
        makecol(0x77, 0x00, 0x77),
        makecol(0x77, 0x00, 0x77),
        makecol(0x77, 0x00, 0x77),
        makecol(0x77, 0x00, 0x77),
        makecol(0x77, 0x00, 0x77),
        makecol(0x77, 0x00, 0x77),
        makecol(0x77, 0x00, 0x77),
        makecol(0x77, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x77),
        makecol(0x99, 0xee, 0x66),
        makecol(0x99, 0xee, 0x66),
        makecol(0x99, 0xee, 0x66),
        makecol(0x99, 0xee, 0x66),
        makecol(0x99, 0xee, 0x66),
        makecol(0x99, 0xee, 0x66),
        makecol(0x99, 0xee, 0x66),
        makecol(0x99, 0xee, 0x66),
        makecol(0x99, 0xee, 0x66),
        makecol(0x99, 0xee, 0x66),
        makecol(0x99, 0xee, 0x66),
        makecol(0x99, 0xee, 0x66),
        makecol(0x99, 0xee, 0x66),
        makecol(0x99, 0xee, 0x66),
        makecol(0x99, 0xee, 0x66),
        makecol(0x99, 0xee, 0x66),
        makecol(0x77, 0x77, 0x77),
        makecol(0x77, 0x77, 0x77),
        makecol(0x77, 0x77, 0x77),
        makecol(0x77, 0x77, 0x77),
        makecol(0x77, 0x77, 0x77),
        makecol(0x77, 0x77, 0x77),
        makecol(0x77, 0x77, 0x77),
        makecol(0x77, 0x77, 0x77),
        makecol(0x77, 0x77, 0x77),
        makecol(0x77, 0x77, 0x77),
        makecol(0x77, 0x77, 0x77),
        makecol(0x77, 0x77, 0x77),
        makecol(0x77, 0x77, 0x77),
        makecol(0x77, 0x77, 0x77),
        makecol(0x77, 0x77, 0x77),
        makecol(0x77, 0x77, 0x77),
        makecol(0xff, 0xff, 0xff),
        makecol(0xff, 0xff, 0xff),
        makecol(0xff, 0xff, 0xff),
        makecol(0xff, 0xff, 0xff),
        makecol(0xff, 0xff, 0xff),
        makecol(0xff, 0xff, 0xff),
        makecol(0xff, 0xff, 0xff),
        makecol(0xff, 0xff, 0xff),
        makecol(0xff, 0xff, 0xff),
        makecol(0xff, 0xff, 0xff),
        makecol(0xff, 0xff, 0xff),
        makecol(0xff, 0xff, 0xff),
        makecol(0xff, 0xff, 0xff),
        makecol(0xff, 0xff, 0xff),
        makecol(0xff, 0xff, 0xff),
        makecol(0xff, 0xff, 0xff),
    },
    /* Palette 2: 2-3-3 truecolour */
    {
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x33),
        makecol(0x00, 0x00, 0x55),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x99),
        makecol(0x00, 0x00, 0xbb),
        makecol(0x00, 0x00, 0xdd),
        makecol(0x00, 0x00, 0xff),
        makecol(0x33, 0x00, 0x00),
        makecol(0x33, 0x00, 0x33),
        makecol(0x33, 0x00, 0x55),
        makecol(0x33, 0x00, 0x77),
        makecol(0x33, 0x00, 0x99),
        makecol(0x33, 0x00, 0xbb),
        makecol(0x33, 0x00, 0xdd),
        makecol(0x33, 0x00, 0xff),
        makecol(0x55, 0x00, 0x00),
        makecol(0x55, 0x00, 0x33),
        makecol(0x55, 0x00, 0x55),
        makecol(0x55, 0x00, 0x77),
        makecol(0x55, 0x00, 0x99),
        makecol(0x55, 0x00, 0xbb),
        makecol(0x55, 0x00, 0xdd),
        makecol(0x55, 0x00, 0xff),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x33),
        makecol(0x77, 0x00, 0x55),
        makecol(0x77, 0x00, 0x77),
        makecol(0x77, 0x00, 0x99),
        makecol(0x77, 0x00, 0xbb),
        makecol(0x77, 0x00, 0xdd),
        makecol(0x77, 0x00, 0xff),
        makecol(0x99, 0x00, 0x00),
        makecol(0x99, 0x00, 0x33),
        makecol(0x99, 0x00, 0x55),
        makecol(0x99, 0x00, 0x77),
        makecol(0x99, 0x00, 0x99),
        makecol(0x99, 0x00, 0xbb),
        makecol(0x99, 0x00, 0xdd),
        makecol(0x99, 0x00, 0xff),
        makecol(0xbb, 0x00, 0x00),
        makecol(0xbb, 0x00, 0x33),
        makecol(0xbb, 0x00, 0x55),
        makecol(0xbb, 0x00, 0x77),
        makecol(0xbb, 0x00, 0x99),
        makecol(0xbb, 0x00, 0xbb),
        makecol(0xbb, 0x00, 0xdd),
        makecol(0xbb, 0x00, 0xff),
        makecol(0xdd, 0x00, 0x00),
        makecol(0xdd, 0x00, 0x33),
        makecol(0xdd, 0x00, 0x55),
        makecol(0xdd, 0x00, 0x77),
        makecol(0xdd, 0x00, 0x99),
        makecol(0xdd, 0x00, 0xbb),
        makecol(0xdd, 0x00, 0xdd),
        makecol(0xdd, 0x00, 0xff),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x33),
        makecol(0xff, 0x00, 0x55),
        makecol(0xff, 0x00, 0x77),
        makecol(0xff, 0x00, 0x99),
        makecol(0xff, 0x00, 0xbb),
        makecol(0xff, 0x00, 0xdd),
        makecol(0xff, 0x00, 0xff),
        makecol(0x00, 0x55, 0x00),
        makecol(0x00, 0x55, 0x33),
        makecol(0x00, 0x55, 0x55),
        makecol(0x00, 0x55, 0x77),
        makecol(0x00, 0x55, 0x99),
        makecol(0x00, 0x55, 0xbb),
        makecol(0x00, 0x55, 0xdd),
        makecol(0x00, 0x55, 0xff),
        makecol(0x33, 0x55, 0x00),
        makecol(0x33, 0x55, 0x33),
        makecol(0x33, 0x55, 0x55),
        makecol(0x33, 0x55, 0x77),
        makecol(0x33, 0x55, 0x99),
        makecol(0x33, 0x55, 0xbb),
        makecol(0x33, 0x55, 0xdd),
        makecol(0x33, 0x55, 0xff),
        makecol(0x55, 0x55, 0x00),
        makecol(0x55, 0x55, 0x33),
        makecol(0x55, 0x55, 0x55),
        makecol(0x55, 0x55, 0x77),
        makecol(0x55, 0x55, 0x99),
        makecol(0x55, 0x55, 0xbb),
        makecol(0x55, 0x55, 0xdd),
        makecol(0x55, 0x55, 0xff),
        makecol(0x77, 0x55, 0x00),
        makecol(0x77, 0x55, 0x33),
        makecol(0x77, 0x55, 0x55),
        makecol(0x77, 0x55, 0x77),
        makecol(0x77, 0x55, 0x99),
        makecol(0x77, 0x55, 0xbb),
        makecol(0x77, 0x55, 0xdd),
        makecol(0x77, 0x55, 0xff),
        makecol(0x99, 0x55, 0x00),
        makecol(0x99, 0x55, 0x33),
        makecol(0x99, 0x55, 0x55),
        makecol(0x99, 0x55, 0x77),
        makecol(0x99, 0x55, 0x99),
        makecol(0x99, 0x55, 0xbb),
        makecol(0x99, 0x55, 0xdd),
        makecol(0x99, 0x55, 0xff),
        makecol(0xbb, 0x55, 0x00),
        makecol(0xbb, 0x55, 0x33),
        makecol(0xbb, 0x55, 0x55),
        makecol(0xbb, 0x55, 0x77),
        makecol(0xbb, 0x55, 0x99),
        makecol(0xbb, 0x55, 0xbb),
        makecol(0xbb, 0x55, 0xdd),
        makecol(0xbb, 0x55, 0xff),
        makecol(0xdd, 0x55, 0x00),
        makecol(0xdd, 0x55, 0x33),
        makecol(0xdd, 0x55, 0x55),
        makecol(0xdd, 0x55, 0x77),
        makecol(0xdd, 0x55, 0x99),
        makecol(0xdd, 0x55, 0xbb),
        makecol(0xdd, 0x55, 0xdd),
        makecol(0xdd, 0x55, 0xff),
        makecol(0xff, 0x55, 0x00),
        makecol(0xff, 0x55, 0x33),
        makecol(0xff, 0x55, 0x55),
        makecol(0xff, 0x55, 0x77),
        makecol(0xff, 0x55, 0x99),
        makecol(0xff, 0x55, 0xbb),
        makecol(0xff, 0x55, 0xdd),
        makecol(0xff, 0x55, 0xff),
        makecol(0x00, 0xaa, 0x00),
        makecol(0x00, 0xaa, 0x33),
        makecol(0x00, 0xaa, 0x55),
        makecol(0x00, 0xaa, 0x77),
        makecol(0x00, 0xaa, 0x99),
        makecol(0x00, 0xaa, 0xbb),
        makecol(0x00, 0xaa, 0xdd),
        makecol(0x00, 0xaa, 0xff),
        makecol(0x33, 0xaa, 0x00),
        makecol(0x33, 0xaa, 0x33),
        makecol(0x33, 0xaa, 0x55),
        makecol(0x33, 0xaa, 0x77),
        makecol(0x33, 0xaa, 0x99),
        makecol(0x33, 0xaa, 0xbb),
        makecol(0x33, 0xaa, 0xdd),
        makecol(0x33, 0xaa, 0xff),
        makecol(0x55, 0xaa, 0x00),
        makecol(0x55, 0xaa, 0x33),
        makecol(0x55, 0xaa, 0x55),
        makecol(0x55, 0xaa, 0x77),
        makecol(0x55, 0xaa, 0x99),
        makecol(0x55, 0xaa, 0xbb),
        makecol(0x55, 0xaa, 0xdd),
        makecol(0x55, 0xaa, 0xff),
        makecol(0x77, 0xaa, 0x00),
        makecol(0x77, 0xaa, 0x33),
        makecol(0x77, 0xaa, 0x55),
        makecol(0x77, 0xaa, 0x77),
        makecol(0x77, 0xaa, 0x99),
        makecol(0x77, 0xaa, 0xbb),
        makecol(0x77, 0xaa, 0xdd),
        makecol(0x77, 0xaa, 0xff),
        makecol(0x99, 0xaa, 0x00),
        makecol(0x99, 0xaa, 0x33),
        makecol(0x99, 0xaa, 0x55),
        makecol(0x99, 0xaa, 0x77),
        makecol(0x99, 0xaa, 0x99),
        makecol(0x99, 0xaa, 0xbb),
        makecol(0x99, 0xaa, 0xdd),
        makecol(0x99, 0xaa, 0xff),
        makecol(0xbb, 0xaa, 0x00),
        makecol(0xbb, 0xaa, 0x33),
        makecol(0xbb, 0xaa, 0x55),
        makecol(0xbb, 0xaa, 0x77),
        makecol(0xbb, 0xaa, 0x99),
        makecol(0xbb, 0xaa, 0xbb),
        makecol(0xbb, 0xaa, 0xdd),
        makecol(0xbb, 0xaa, 0xff),
        makecol(0xdd, 0xaa, 0x00),
        makecol(0xdd, 0xaa, 0x33),
        makecol(0xdd, 0xaa, 0x55),
        makecol(0xdd, 0xaa, 0x77),
        makecol(0xdd, 0xaa, 0x99),
        makecol(0xdd, 0xaa, 0xbb),
        makecol(0xdd, 0xaa, 0xdd),
        makecol(0xdd, 0xaa, 0xff),
        makecol(0xff, 0xaa, 0x00),
        makecol(0xff, 0xaa, 0x33),
        makecol(0xff, 0xaa, 0x55),
        makecol(0xff, 0xaa, 0x77),
        makecol(0xff, 0xaa, 0x99),
        makecol(0xff, 0xaa, 0xbb),
        makecol(0xff, 0xaa, 0xdd),
        makecol(0xff, 0xaa, 0xee),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x33),
        makecol(0x00, 0xff, 0x55),
        makecol(0x00, 0xff, 0x77),
        makecol(0x00, 0xff, 0x99),
        makecol(0x00, 0xff, 0xbb),
        makecol(0x00, 0xff, 0xdd),
        makecol(0x00, 0xff, 0xff),
        makecol(0x33, 0xff, 0x00),
        makecol(0x33, 0xff, 0x33),
        makecol(0x33, 0xff, 0x55),
        makecol(0x33, 0xff, 0x77),
        makecol(0x33, 0xff, 0x99),
        makecol(0x33, 0xff, 0xbb),
        makecol(0x33, 0xff, 0xdd),
        makecol(0x33, 0xff, 0xff),
        makecol(0x55, 0xff, 0x00),
        makecol(0x55, 0xff, 0x33),
        makecol(0x55, 0xff, 0x55),
        makecol(0x55, 0xff, 0x77),
        makecol(0x55, 0xff, 0x99),
        makecol(0x55, 0xff, 0xbb),
        makecol(0x55, 0xff, 0xdd),
        makecol(0x55, 0xff, 0xff),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x33),
        makecol(0x77, 0xff, 0x55),
        makecol(0x77, 0xff, 0x77),
        makecol(0x77, 0xff, 0x99),
        makecol(0x77, 0xff, 0xbb),
        makecol(0x77, 0xff, 0xdd),
        makecol(0x77, 0xff, 0xff),
        makecol(0x99, 0xff, 0x00),
        makecol(0x99, 0xff, 0x33),
        makecol(0x99, 0xff, 0x55),
        makecol(0x99, 0xff, 0x77),
        makecol(0x99, 0xff, 0x99),
        makecol(0x99, 0xff, 0xbb),
        makecol(0x99, 0xff, 0xdd),
        makecol(0x99, 0xff, 0xff),
        makecol(0xbb, 0xff, 0x00),
        makecol(0xbb, 0xff, 0x33),
        makecol(0xbb, 0xff, 0x55),
        makecol(0xbb, 0xff, 0x77),
        makecol(0xbb, 0xff, 0x99),
        makecol(0xbb, 0xff, 0xbb),
        makecol(0xbb, 0xff, 0xdd),
        makecol(0xbb, 0xff, 0xff),
        makecol(0xdd, 0xff, 0x00),
        makecol(0xdd, 0xff, 0x33),
        makecol(0xdd, 0xff, 0x55),
        makecol(0xdd, 0xff, 0x77),
        makecol(0xdd, 0xff, 0x99),
        makecol(0xdd, 0xff, 0xbb),
        makecol(0xdd, 0xff, 0xdd),
        makecol(0xdd, 0xff, 0xff),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x33),
        makecol(0xff, 0xff, 0x55),
        makecol(0xff, 0xff, 0x77),
        makecol(0xff, 0xff, 0x99),
        makecol(0xff, 0xff, 0xbb),
        makecol(0xff, 0xff, 0xdd),
        makecol(0xff, 0xff, 0xff),
    },
    /* Palette 3: 3-2-3 truecolour */
    {
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x33),
        makecol(0x00, 0x00, 0x55),
        makecol(0x00, 0x00, 0x77),
        makecol(0x00, 0x00, 0x99),
        makecol(0x00, 0x00, 0xbb),
        makecol(0x00, 0x00, 0xdd),
        makecol(0x00, 0x00, 0xff),
        makecol(0x55, 0x00, 0x00),
        makecol(0x55, 0x00, 0x33),
        makecol(0x55, 0x00, 0x55),
        makecol(0x55, 0x00, 0x77),
        makecol(0x55, 0x00, 0x99),
        makecol(0x55, 0x00, 0xbb),
        makecol(0x55, 0x00, 0xdd),
        makecol(0x55, 0x00, 0xff),
        makecol(0xaa, 0x00, 0x00),
        makecol(0xaa, 0x00, 0x33),
        makecol(0xaa, 0x00, 0x55),
        makecol(0xaa, 0x00, 0x77),
        makecol(0xaa, 0x00, 0x99),
        makecol(0xaa, 0x00, 0xbb),
        makecol(0xaa, 0x00, 0xdd),
        makecol(0xaa, 0x00, 0xff),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x33),
        makecol(0xff, 0x00, 0x55),
        makecol(0xff, 0x00, 0x77),
        makecol(0xff, 0x00, 0x99),
        makecol(0xff, 0x00, 0xbb),
        makecol(0xff, 0x00, 0xdd),
        makecol(0xff, 0x00, 0xff),
        makecol(0x00, 0x33, 0x00),
        makecol(0x00, 0x33, 0x33),
        makecol(0x00, 0x33, 0x55),
        makecol(0x00, 0x33, 0x77),
        makecol(0x00, 0x33, 0x99),
        makecol(0x00, 0x33, 0xbb),
        makecol(0x00, 0x33, 0xdd),
        makecol(0x00, 0x33, 0xff),
        makecol(0x55, 0x33, 0x00),
        makecol(0x55, 0x33, 0x33),
        makecol(0x55, 0x33, 0x55),
        makecol(0x55, 0x33, 0x77),
        makecol(0x55, 0x33, 0x99),
        makecol(0x55, 0x33, 0xbb),
        makecol(0x55, 0x33, 0xdd),
        makecol(0x55, 0x33, 0xff),
        makecol(0xaa, 0x33, 0x00),
        makecol(0xaa, 0x33, 0x33),
        makecol(0xaa, 0x33, 0x55),
        makecol(0xaa, 0x33, 0x77),
        makecol(0xaa, 0x33, 0x99),
        makecol(0xaa, 0x33, 0xbb),
        makecol(0xaa, 0x33, 0xdd),
        makecol(0xaa, 0x33, 0xff),
        makecol(0xff, 0x33, 0x00),
        makecol(0xff, 0x33, 0x33),
        makecol(0xff, 0x33, 0x55),
        makecol(0xff, 0x33, 0x77),
        makecol(0xff, 0x33, 0x99),
        makecol(0xff, 0x33, 0xbb),
        makecol(0xff, 0x33, 0xdd),
        makecol(0xff, 0x33, 0xff),
        makecol(0x00, 0x55, 0x00),
        makecol(0x00, 0x55, 0x33),
        makecol(0x00, 0x55, 0x55),
        makecol(0x00, 0x55, 0x77),
        makecol(0x00, 0x55, 0x99),
        makecol(0x00, 0x55, 0xbb),
        makecol(0x00, 0x55, 0xdd),
        makecol(0x00, 0x55, 0xff),
        makecol(0x55, 0x55, 0x00),
        makecol(0x55, 0x55, 0x33),
        makecol(0x55, 0x55, 0x55),
        makecol(0x55, 0x55, 0x77),
        makecol(0x55, 0x55, 0x99),
        makecol(0x55, 0x55, 0xbb),
        makecol(0x55, 0x55, 0xdd),
        makecol(0x55, 0x55, 0xff),
        makecol(0xaa, 0x55, 0x00),
        makecol(0xaa, 0x55, 0x33),
        makecol(0xaa, 0x55, 0x55),
        makecol(0xaa, 0x55, 0x77),
        makecol(0xaa, 0x55, 0x99),
        makecol(0xaa, 0x55, 0xbb),
        makecol(0xaa, 0x55, 0xdd),
        makecol(0xaa, 0x55, 0xff),
        makecol(0xff, 0x55, 0x00),
        makecol(0xff, 0x55, 0x33),
        makecol(0xff, 0x55, 0x55),
        makecol(0xff, 0x55, 0x77),
        makecol(0xff, 0x55, 0x99),
        makecol(0xff, 0x55, 0xbb),
        makecol(0xff, 0x55, 0xdd),
        makecol(0xff, 0x55, 0xff),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x33),
        makecol(0x00, 0x77, 0x55),
        makecol(0x00, 0x77, 0x77),
        makecol(0x00, 0x77, 0x99),
        makecol(0x00, 0x77, 0xbb),
        makecol(0x00, 0x77, 0xdd),
        makecol(0x00, 0x77, 0xff),
        makecol(0x55, 0x77, 0x00),
        makecol(0x55, 0x77, 0x33),
        makecol(0x55, 0x77, 0x55),
        makecol(0x55, 0x77, 0x77),
        makecol(0x55, 0x77, 0x99),
        makecol(0x55, 0x77, 0xbb),
        makecol(0x55, 0x77, 0xdd),
        makecol(0x55, 0x77, 0xff),
        makecol(0xaa, 0x77, 0x00),
        makecol(0xaa, 0x77, 0x33),
        makecol(0xaa, 0x77, 0x55),
        makecol(0xaa, 0x77, 0x77),
        makecol(0xaa, 0x77, 0x99),
        makecol(0xaa, 0x77, 0xbb),
        makecol(0xaa, 0x77, 0xdd),
        makecol(0xaa, 0x77, 0xff),
        makecol(0xff, 0x77, 0x00),
        makecol(0xff, 0x77, 0x33),
        makecol(0xff, 0x77, 0x55),
        makecol(0xff, 0x77, 0x77),
        makecol(0xff, 0x77, 0x99),
        makecol(0xff, 0x77, 0xbb),
        makecol(0xff, 0x77, 0xdd),
        makecol(0xff, 0x77, 0xff),
        makecol(0x00, 0x99, 0x00),
        makecol(0x00, 0x99, 0x33),
        makecol(0x00, 0x99, 0x55),
        makecol(0x00, 0x99, 0x77),
        makecol(0x00, 0x99, 0x99),
        makecol(0x00, 0x99, 0xbb),
        makecol(0x00, 0x99, 0xdd),
        makecol(0x00, 0x99, 0xff),
        makecol(0x55, 0x99, 0x00),
        makecol(0x55, 0x99, 0x33),
        makecol(0x55, 0x99, 0x55),
        makecol(0x55, 0x99, 0x77),
        makecol(0x55, 0x99, 0x99),
        makecol(0x55, 0x99, 0xbb),
        makecol(0x55, 0x99, 0xdd),
        makecol(0x55, 0x99, 0xff),
        makecol(0xaa, 0x99, 0x00),
        makecol(0xaa, 0x99, 0x33),
        makecol(0xaa, 0x99, 0x55),
        makecol(0xaa, 0x99, 0x77),
        makecol(0xaa, 0x99, 0x99),
        makecol(0xaa, 0x99, 0xbb),
        makecol(0xaa, 0x99, 0xdd),
        makecol(0xaa, 0x99, 0xff),
        makecol(0xff, 0x99, 0x00),
        makecol(0xff, 0x99, 0x33),
        makecol(0xff, 0x99, 0x55),
        makecol(0xff, 0x99, 0x77),
        makecol(0xff, 0x99, 0x99),
        makecol(0xff, 0x99, 0xbb),
        makecol(0xff, 0x99, 0xdd),
        makecol(0xff, 0x99, 0xff),
        makecol(0x00, 0xbb, 0x00),
        makecol(0x00, 0xbb, 0x33),
        makecol(0x00, 0xbb, 0x55),
        makecol(0x00, 0xbb, 0x77),
        makecol(0x00, 0xbb, 0x99),
        makecol(0x00, 0xbb, 0xbb),
        makecol(0x00, 0xbb, 0xdd),
        makecol(0x00, 0xbb, 0xff),
        makecol(0x55, 0xbb, 0x00),
        makecol(0x55, 0xbb, 0x33),
        makecol(0x55, 0xbb, 0x55),
        makecol(0x55, 0xbb, 0x77),
        makecol(0x55, 0xbb, 0x99),
        makecol(0x55, 0xbb, 0xbb),
        makecol(0x55, 0xbb, 0xdd),
        makecol(0x55, 0xbb, 0xff),
        makecol(0xaa, 0xbb, 0x00),
        makecol(0xaa, 0xbb, 0x33),
        makecol(0xaa, 0xbb, 0x55),
        makecol(0xaa, 0xbb, 0x77),
        makecol(0xaa, 0xbb, 0x99),
        makecol(0xaa, 0xbb, 0xbb),
        makecol(0xaa, 0xbb, 0xdd),
        makecol(0xaa, 0xbb, 0xff),
        makecol(0xff, 0xbb, 0x00),
        makecol(0xff, 0xbb, 0x33),
        makecol(0xff, 0xbb, 0x55),
        makecol(0xff, 0xbb, 0x77),
        makecol(0xff, 0xbb, 0x99),
        makecol(0xff, 0xbb, 0xbb),
        makecol(0xff, 0xbb, 0xdd),
        makecol(0xff, 0xbb, 0xff),
        makecol(0x00, 0xdd, 0x00),
        makecol(0x00, 0xdd, 0x33),
        makecol(0x00, 0xdd, 0x55),
        makecol(0x00, 0xdd, 0x77),
        makecol(0x00, 0xdd, 0x99),
        makecol(0x00, 0xdd, 0xbb),
        makecol(0x00, 0xdd, 0xdd),
        makecol(0x00, 0xdd, 0xff),
        makecol(0x55, 0xdd, 0x00),
        makecol(0x55, 0xdd, 0x33),
        makecol(0x55, 0xdd, 0x55),
        makecol(0x55, 0xdd, 0x77),
        makecol(0x55, 0xdd, 0x99),
        makecol(0x55, 0xdd, 0xbb),
        makecol(0x55, 0xdd, 0xdd),
        makecol(0x55, 0xdd, 0xff),
        makecol(0xaa, 0xdd, 0x00),
        makecol(0xaa, 0xdd, 0x33),
        makecol(0xaa, 0xdd, 0x55),
        makecol(0xaa, 0xdd, 0x77),
        makecol(0xaa, 0xdd, 0x99),
        makecol(0xaa, 0xdd, 0xbb),
        makecol(0xaa, 0xdd, 0xdd),
        makecol(0xaa, 0xdd, 0xff),
        makecol(0xff, 0xdd, 0x00),
        makecol(0xff, 0xdd, 0x33),
        makecol(0xff, 0xdd, 0x55),
        makecol(0xff, 0xdd, 0x77),
        makecol(0xff, 0xdd, 0x99),
        makecol(0xff, 0xdd, 0xbb),
        makecol(0xff, 0xdd, 0xdd),
        makecol(0xff, 0xdd, 0xff),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x33),
        makecol(0x00, 0xff, 0x55),
        makecol(0x00, 0xff, 0x77),
        makecol(0x00, 0xff, 0x99),
        makecol(0x00, 0xff, 0xbb),
        makecol(0x00, 0xff, 0xdd),
        makecol(0x00, 0xff, 0xff),
        makecol(0x55, 0xff, 0x00),
        makecol(0x55, 0xff, 0x33),
        makecol(0x55, 0xff, 0x55),
        makecol(0x55, 0xff, 0x77),
        makecol(0x55, 0xff, 0x99),
        makecol(0x55, 0xff, 0xbb),
        makecol(0x55, 0xff, 0xdd),
        makecol(0x55, 0xff, 0xff),
        makecol(0xaa, 0xff, 0x00),
        makecol(0xaa, 0xff, 0x33),
        makecol(0xaa, 0xff, 0x55),
        makecol(0xaa, 0xff, 0x77),
        makecol(0xaa, 0xff, 0x99),
        makecol(0xaa, 0xff, 0xbb),
        makecol(0xaa, 0xff, 0xdd),
        makecol(0xaa, 0xff, 0xff),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x33),
        makecol(0xff, 0xff, 0x55),
        makecol(0xff, 0xff, 0x77),
        makecol(0xff, 0xff, 0x99),
        makecol(0xff, 0xff, 0xbb),
        makecol(0xff, 0xff, 0xdd),
        makecol(0xff, 0xff, 0xff),
    },
    /* Palette 4: 3-3-2 truecolour */
    {
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x55),
        makecol(0x00, 0x00, 0xaa),
        makecol(0x00, 0x00, 0xff),
        makecol(0x00, 0x33, 0x00),
        makecol(0x00, 0x33, 0x55),
        makecol(0x00, 0x33, 0xaa),
        makecol(0x00, 0x33, 0xff),
        makecol(0x00, 0x55, 0x00),
        makecol(0x00, 0x55, 0x55),
        makecol(0x00, 0x55, 0xaa),
        makecol(0x00, 0x55, 0xff),
        makecol(0x00, 0x77, 0x00),
        makecol(0x00, 0x77, 0x55),
        makecol(0x00, 0x77, 0xaa),
        makecol(0x00, 0x77, 0xff),
        makecol(0x00, 0x99, 0x00),
        makecol(0x00, 0x99, 0x55),
        makecol(0x00, 0x99, 0xaa),
        makecol(0x00, 0x99, 0xff),
        makecol(0x00, 0xbb, 0x00),
        makecol(0x00, 0xbb, 0x55),
        makecol(0x00, 0xbb, 0xaa),
        makecol(0x00, 0xbb, 0xff),
        makecol(0x00, 0xdd, 0x00),
        makecol(0x00, 0xdd, 0x55),
        makecol(0x00, 0xdd, 0xaa),
        makecol(0x00, 0xdd, 0xff),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x55),
        makecol(0x00, 0xff, 0xaa),
        makecol(0x00, 0xff, 0xff),
        makecol(0x33, 0x00, 0x00),
        makecol(0x33, 0x00, 0x55),
        makecol(0x33, 0x00, 0xaa),
        makecol(0x33, 0x00, 0xff),
        makecol(0x33, 0x33, 0x00),
        makecol(0x33, 0x33, 0x55),
        makecol(0x33, 0x33, 0xaa),
        makecol(0x33, 0x33, 0xff),
        makecol(0x33, 0x55, 0x00),
        makecol(0x33, 0x55, 0x55),
        makecol(0x33, 0x55, 0xaa),
        makecol(0x33, 0x55, 0xff),
        makecol(0x33, 0x77, 0x00),
        makecol(0x33, 0x77, 0x55),
        makecol(0x33, 0x77, 0xaa),
        makecol(0x33, 0x77, 0xff),
        makecol(0x33, 0x99, 0x00),
        makecol(0x33, 0x99, 0x55),
        makecol(0x33, 0x99, 0xaa),
        makecol(0x33, 0x99, 0xff),
        makecol(0x33, 0xbb, 0x00),
        makecol(0x33, 0xbb, 0x55),
        makecol(0x33, 0xbb, 0xaa),
        makecol(0x33, 0xbb, 0xff),
        makecol(0x33, 0xdd, 0x00),
        makecol(0x33, 0xdd, 0x55),
        makecol(0x33, 0xdd, 0xaa),
        makecol(0x33, 0xdd, 0xff),
        makecol(0x33, 0xff, 0x00),
        makecol(0x33, 0xff, 0x55),
        makecol(0x33, 0xff, 0xaa),
        makecol(0x33, 0xff, 0xff),
        makecol(0x55, 0x00, 0x00),
        makecol(0x55, 0x00, 0x55),
        makecol(0x55, 0x00, 0xaa),
        makecol(0x55, 0x00, 0xff),
        makecol(0x55, 0x33, 0x00),
        makecol(0x55, 0x33, 0x55),
        makecol(0x55, 0x33, 0xaa),
        makecol(0x55, 0x33, 0xff),
        makecol(0x55, 0x55, 0x00),
        makecol(0x55, 0x55, 0x55),
        makecol(0x55, 0x55, 0xaa),
        makecol(0x55, 0x55, 0xff),
        makecol(0x55, 0x77, 0x00),
        makecol(0x55, 0x77, 0x55),
        makecol(0x55, 0x77, 0xaa),
        makecol(0x55, 0x77, 0xff),
        makecol(0x55, 0x99, 0x00),
        makecol(0x55, 0x99, 0x55),
        makecol(0x55, 0x99, 0xaa),
        makecol(0x55, 0x99, 0xff),
        makecol(0x55, 0xbb, 0x00),
        makecol(0x55, 0xbb, 0x55),
        makecol(0x55, 0xbb, 0xaa),
        makecol(0x55, 0xbb, 0xff),
        makecol(0x55, 0xdd, 0x00),
        makecol(0x55, 0xdd, 0x55),
        makecol(0x55, 0xdd, 0xaa),
        makecol(0x55, 0xdd, 0xff),
        makecol(0x55, 0xff, 0x00),
        makecol(0x55, 0xff, 0x55),
        makecol(0x55, 0xff, 0xaa),
        makecol(0x55, 0xff, 0xff),
        makecol(0x77, 0x00, 0x00),
        makecol(0x77, 0x00, 0x55),
        makecol(0x77, 0x00, 0xaa),
        makecol(0x77, 0x00, 0xff),
        makecol(0x77, 0x33, 0x00),
        makecol(0x77, 0x33, 0x55),
        makecol(0x77, 0x33, 0xaa),
        makecol(0x77, 0x33, 0xff),
        makecol(0x77, 0x55, 0x00),
        makecol(0x77, 0x55, 0x55),
        makecol(0x77, 0x55, 0xaa),
        makecol(0x77, 0x55, 0xff),
        makecol(0x77, 0x77, 0x00),
        makecol(0x77, 0x77, 0x55),
        makecol(0x77, 0x77, 0xaa),
        makecol(0x77, 0x77, 0xff),
        makecol(0x77, 0x99, 0x00),
        makecol(0x77, 0x99, 0x55),
        makecol(0x77, 0x99, 0xaa),
        makecol(0x77, 0x99, 0xff),
        makecol(0x77, 0xbb, 0x00),
        makecol(0x77, 0xbb, 0x55),
        makecol(0x77, 0xbb, 0xaa),
        makecol(0x77, 0xbb, 0xff),
        makecol(0x77, 0xdd, 0x00),
        makecol(0x77, 0xdd, 0x55),
        makecol(0x77, 0xdd, 0xaa),
        makecol(0x77, 0xdd, 0xff),
        makecol(0x77, 0xff, 0x00),
        makecol(0x77, 0xff, 0x55),
        makecol(0x77, 0xff, 0xaa),
        makecol(0x77, 0xff, 0xff),
        makecol(0x99, 0x00, 0x00),
        makecol(0x99, 0x00, 0x55),
        makecol(0x99, 0x00, 0xaa),
        makecol(0x99, 0x00, 0xff),
        makecol(0x99, 0x33, 0x00),
        makecol(0x99, 0x33, 0x55),
        makecol(0x99, 0x33, 0xaa),
        makecol(0x99, 0x33, 0xff),
        makecol(0x99, 0x55, 0x00),
        makecol(0x99, 0x55, 0x55),
        makecol(0x99, 0x55, 0xaa),
        makecol(0x99, 0x55, 0xff),
        makecol(0x99, 0x77, 0x00),
        makecol(0x99, 0x77, 0x55),
        makecol(0x99, 0x77, 0xaa),
        makecol(0x99, 0x77, 0xff),
        makecol(0x99, 0x99, 0x00),
        makecol(0x99, 0x99, 0x55),
        makecol(0x99, 0x99, 0xaa),
        makecol(0x99, 0x99, 0xff),
        makecol(0x99, 0xbb, 0x00),
        makecol(0x99, 0xbb, 0x55),
        makecol(0x99, 0xbb, 0xaa),
        makecol(0x99, 0xbb, 0xff),
        makecol(0x99, 0xdd, 0x00),
        makecol(0x99, 0xdd, 0x55),
        makecol(0x99, 0xdd, 0xaa),
        makecol(0x99, 0xdd, 0xff),
        makecol(0x99, 0xff, 0x00),
        makecol(0x99, 0xff, 0x55),
        makecol(0x99, 0xff, 0xaa),
        makecol(0x99, 0xff, 0xff),
        makecol(0xbb, 0x00, 0x00),
        makecol(0xbb, 0x00, 0x55),
        makecol(0xbb, 0x00, 0xaa),
        makecol(0xbb, 0x00, 0xff),
        makecol(0xbb, 0x33, 0x00),
        makecol(0xbb, 0x33, 0x55),
        makecol(0xbb, 0x33, 0xaa),
        makecol(0xbb, 0x33, 0xff),
        makecol(0xbb, 0x55, 0x00),
        makecol(0xbb, 0x55, 0x55),
        makecol(0xbb, 0x55, 0xaa),
        makecol(0xbb, 0x55, 0xff),
        makecol(0xbb, 0x77, 0x00),
        makecol(0xbb, 0x77, 0x55),
        makecol(0xbb, 0x77, 0xaa),
        makecol(0xbb, 0x77, 0xff),
        makecol(0xbb, 0x99, 0x00),
        makecol(0xbb, 0x99, 0x55),
        makecol(0xbb, 0x99, 0xaa),
        makecol(0xbb, 0x99, 0xff),
        makecol(0xbb, 0xbb, 0x00),
        makecol(0xbb, 0xbb, 0x55),
        makecol(0xbb, 0xbb, 0xaa),
        makecol(0xbb, 0xbb, 0xff),
        makecol(0xbb, 0xdd, 0x00),
        makecol(0xbb, 0xdd, 0x55),
        makecol(0xbb, 0xdd, 0xaa),
        makecol(0xbb, 0xdd, 0xff),
        makecol(0xbb, 0xff, 0x00),
        makecol(0xbb, 0xff, 0x55),
        makecol(0xbb, 0xff, 0xaa),
        makecol(0xbb, 0xff, 0xff),
        makecol(0xdd, 0x00, 0x00),
        makecol(0xdd, 0x00, 0x55),
        makecol(0xdd, 0x00, 0xaa),
        makecol(0xdd, 0x00, 0xff),
        makecol(0xdd, 0x33, 0x00),
        makecol(0xdd, 0x33, 0x55),
        makecol(0xdd, 0x33, 0xaa),
        makecol(0xdd, 0x33, 0xff),
        makecol(0xdd, 0x55, 0x00),
        makecol(0xdd, 0x55, 0x55),
        makecol(0xdd, 0x55, 0xaa),
        makecol(0xdd, 0x55, 0xff),
        makecol(0xdd, 0x77, 0x00),
        makecol(0xdd, 0x77, 0x55),
        makecol(0xdd, 0x77, 0xaa),
        makecol(0xdd, 0x77, 0xff),
        makecol(0xdd, 0x99, 0x00),
        makecol(0xdd, 0x99, 0x55),
        makecol(0xdd, 0x99, 0xaa),
        makecol(0xdd, 0x99, 0xff),
        makecol(0xdd, 0xbb, 0x00),
        makecol(0xdd, 0xbb, 0x55),
        makecol(0xdd, 0xbb, 0xaa),
        makecol(0xdd, 0xbb, 0xff),
        makecol(0xdd, 0xdd, 0x00),
        makecol(0xdd, 0xdd, 0x55),
        makecol(0xdd, 0xdd, 0xaa),
        makecol(0xdd, 0xdd, 0xff),
        makecol(0xdd, 0xff, 0x00),
        makecol(0xdd, 0xff, 0x55),
        makecol(0xdd, 0xff, 0xaa),
        makecol(0xdd, 0xff, 0xff),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x55),
        makecol(0xff, 0x00, 0xaa),
        makecol(0xff, 0x00, 0xff),
        makecol(0xff, 0x33, 0x00),
        makecol(0xff, 0x33, 0x55),
        makecol(0xff, 0x33, 0xaa),
        makecol(0xff, 0x33, 0xff),
        makecol(0xff, 0x55, 0x00),
        makecol(0xff, 0x55, 0x55),
        makecol(0xff, 0x55, 0xaa),
        makecol(0xff, 0x55, 0xff),
        makecol(0xff, 0x77, 0x00),
        makecol(0xff, 0x77, 0x55),
        makecol(0xff, 0x77, 0xaa),
        makecol(0xff, 0x77, 0xff),
        makecol(0xff, 0x99, 0x00),
        makecol(0xff, 0x99, 0x55),
        makecol(0xff, 0x99, 0xaa),
        makecol(0xff, 0x99, 0xff),
        makecol(0xff, 0xbb, 0x00),
        makecol(0xff, 0xbb, 0x55),
        makecol(0xff, 0xbb, 0xaa),
        makecol(0xff, 0xbb, 0xff),
        makecol(0xff, 0xdd, 0x00),
        makecol(0xff, 0xdd, 0x55),
        makecol(0xff, 0xdd, 0xaa),
        makecol(0xff, 0xdd, 0xff),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x55),
        makecol(0xff, 0xff, 0xaa),
        makecol(0xff, 0xff, 0xff),
    },
    /* Palette 5: 6x6x6 colour cube */
    {
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x33),
        makecol(0x00, 0x00, 0x66),
        makecol(0x00, 0x00, 0x99),
        makecol(0x00, 0x00, 0xcc),
        makecol(0x00, 0x00, 0xff),
        makecol(0x33, 0x00, 0x00),
        makecol(0x33, 0x00, 0x33),
        makecol(0x33, 0x00, 0x66),
        makecol(0x33, 0x00, 0x99),
        makecol(0x33, 0x00, 0xcc),
        makecol(0x33, 0x00, 0xff),
        makecol(0x66, 0x00, 0x00),
        makecol(0x66, 0x00, 0x33),
        makecol(0x66, 0x00, 0x66),
        makecol(0x66, 0x00, 0x99),
        makecol(0x66, 0x00, 0xcc),
        makecol(0x66, 0x00, 0xff),
        makecol(0x99, 0x00, 0x00),
        makecol(0x99, 0x00, 0x33),
        makecol(0x99, 0x00, 0x66),
        makecol(0x99, 0x00, 0x99),
        makecol(0x99, 0x00, 0xcc),
        makecol(0x99, 0x00, 0xff),
        makecol(0xcc, 0x00, 0x00),
        makecol(0xcc, 0x00, 0x33),
        makecol(0xcc, 0x00, 0x66),
        makecol(0xcc, 0x00, 0x99),
        makecol(0xcc, 0x00, 0xcc),
        makecol(0xcc, 0x00, 0xff),
        makecol(0xff, 0x00, 0x00),
        makecol(0xff, 0x00, 0x33),
        makecol(0xff, 0x00, 0x66),
        makecol(0xff, 0x00, 0x99),
        makecol(0xff, 0x00, 0xcc),
        makecol(0xff, 0x00, 0xff),
        makecol(0x00, 0x33, 0x00),
        makecol(0x00, 0x33, 0x33),
        makecol(0x00, 0x33, 0x66),
        makecol(0x00, 0x33, 0x99),
        makecol(0x00, 0x33, 0xcc),
        makecol(0x00, 0x33, 0xff),
        makecol(0x33, 0x33, 0x00),
        makecol(0x33, 0x33, 0x33),
        makecol(0x33, 0x33, 0x66),
        makecol(0x33, 0x33, 0x99),
        makecol(0x33, 0x33, 0xcc),
        makecol(0x33, 0x33, 0xff),
        makecol(0x66, 0x33, 0x00),
        makecol(0x66, 0x33, 0x33),
        makecol(0x66, 0x33, 0x66),
        makecol(0x66, 0x33, 0x99),
        makecol(0x66, 0x33, 0xcc),
        makecol(0x66, 0x33, 0xff),
        makecol(0x99, 0x33, 0x00),
        makecol(0x99, 0x33, 0x33),
        makecol(0x99, 0x33, 0x66),
        makecol(0x99, 0x33, 0x99),
        makecol(0x99, 0x33, 0xcc),
        makecol(0x99, 0x33, 0xff),
        makecol(0xcc, 0x33, 0x00),
        makecol(0xcc, 0x33, 0x33),
        makecol(0xcc, 0x33, 0x66),
        makecol(0xcc, 0x33, 0x99),
        makecol(0xcc, 0x33, 0xcc),
        makecol(0xcc, 0x33, 0xff),
        makecol(0xff, 0x33, 0x00),
        makecol(0xff, 0x33, 0x33),
        makecol(0xff, 0x33, 0x66),
        makecol(0xff, 0x33, 0x99),
        makecol(0xff, 0x33, 0xcc),
        makecol(0xff, 0x33, 0xff),
        makecol(0x00, 0x66, 0x00),
        makecol(0x00, 0x66, 0x33),
        makecol(0x00, 0x66, 0x66),
        makecol(0x00, 0x66, 0x99),
        makecol(0x00, 0x66, 0xcc),
        makecol(0x00, 0x66, 0xff),
        makecol(0x33, 0x66, 0x00),
        makecol(0x33, 0x66, 0x33),
        makecol(0x33, 0x66, 0x66),
        makecol(0x33, 0x66, 0x99),
        makecol(0x33, 0x66, 0xcc),
        makecol(0x33, 0x66, 0xff),
        makecol(0x66, 0x66, 0x00),
        makecol(0x66, 0x66, 0x33),
        makecol(0x66, 0x66, 0x66),
        makecol(0x66, 0x66, 0x99),
        makecol(0x66, 0x66, 0xcc),
        makecol(0x66, 0x66, 0xff),
        makecol(0x99, 0x66, 0x00),
        makecol(0x99, 0x66, 0x33),
        makecol(0x99, 0x66, 0x66),
        makecol(0x99, 0x66, 0x99),
        makecol(0x99, 0x66, 0xcc),
        makecol(0x99, 0x66, 0xff),
        makecol(0xcc, 0x66, 0x00),
        makecol(0xcc, 0x66, 0x33),
        makecol(0xcc, 0x66, 0x66),
        makecol(0xcc, 0x66, 0x99),
        makecol(0xcc, 0x66, 0xcc),
        makecol(0xcc, 0x66, 0xff),
        makecol(0xff, 0x66, 0x00),
        makecol(0xff, 0x66, 0x33),
        makecol(0xff, 0x66, 0x66),
        makecol(0xff, 0x66, 0x99),
        makecol(0xff, 0x66, 0xcc),
        makecol(0xff, 0x66, 0xff),
        makecol(0x00, 0x99, 0x00),
        makecol(0x00, 0x99, 0x33),
        makecol(0x00, 0x99, 0x66),
        makecol(0x00, 0x99, 0x99),
        makecol(0x00, 0x99, 0xcc),
        makecol(0x00, 0x99, 0xff),
        makecol(0x33, 0x99, 0x00),
        makecol(0x33, 0x99, 0x33),
        makecol(0x33, 0x99, 0x66),
        makecol(0x33, 0x99, 0x99),
        makecol(0x33, 0x99, 0xcc),
        makecol(0x33, 0x99, 0xff),
        makecol(0x66, 0x99, 0x00),
        makecol(0x66, 0x99, 0x33),
        makecol(0x66, 0x99, 0x66),
        makecol(0x66, 0x99, 0x99),
        makecol(0x66, 0x99, 0xcc),
        makecol(0x66, 0x99, 0xff),
        makecol(0x99, 0x99, 0x00),
        makecol(0x99, 0x99, 0x33),
        makecol(0x99, 0x99, 0x66),
        makecol(0x99, 0x99, 0x99),
        makecol(0x99, 0x99, 0xcc),
        makecol(0x99, 0x99, 0xff),
        makecol(0xcc, 0x99, 0x00),
        makecol(0xcc, 0x99, 0x33),
        makecol(0xcc, 0x99, 0x66),
        makecol(0xcc, 0x99, 0x99),
        makecol(0xcc, 0x99, 0xcc),
        makecol(0xcc, 0x99, 0xff),
        makecol(0xff, 0x99, 0x00),
        makecol(0xff, 0x99, 0x33),
        makecol(0xff, 0x99, 0x66),
        makecol(0xff, 0x99, 0x99),
        makecol(0xff, 0x99, 0xcc),
        makecol(0xff, 0x99, 0xff),
        makecol(0x00, 0xcc, 0x00),
        makecol(0x00, 0xcc, 0x33),
        makecol(0x00, 0xcc, 0x66),
        makecol(0x00, 0xcc, 0x99),
        makecol(0x00, 0xcc, 0xcc),
        makecol(0x00, 0xcc, 0xff),
        makecol(0x33, 0xcc, 0x00),
        makecol(0x33, 0xcc, 0x33),
        makecol(0x33, 0xcc, 0x66),
        makecol(0x33, 0xcc, 0x99),
        makecol(0x33, 0xcc, 0xcc),
        makecol(0x33, 0xcc, 0xff),
        makecol(0x66, 0xcc, 0x00),
        makecol(0x66, 0xcc, 0x33),
        makecol(0x66, 0xcc, 0x66),
        makecol(0x66, 0xcc, 0x99),
        makecol(0x66, 0xcc, 0xcc),
        makecol(0x66, 0xcc, 0xff),
        makecol(0x99, 0xcc, 0x00),
        makecol(0x99, 0xcc, 0x33),
        makecol(0x99, 0xcc, 0x66),
        makecol(0x99, 0xcc, 0x99),
        makecol(0x99, 0xcc, 0xcc),
        makecol(0x99, 0xcc, 0xff),
        makecol(0xcc, 0xcc, 0x00),
        makecol(0xcc, 0xcc, 0x33),
        makecol(0xcc, 0xcc, 0x66),
        makecol(0xcc, 0xcc, 0x99),
        makecol(0xcc, 0xcc, 0xcc),
        makecol(0xcc, 0xcc, 0xff),
        makecol(0xff, 0xcc, 0x00),
        makecol(0xff, 0xcc, 0x33),
        makecol(0xff, 0xcc, 0x66),
        makecol(0xff, 0xcc, 0x99),
        makecol(0xff, 0xcc, 0xcc),
        makecol(0xff, 0xcc, 0xff),
        makecol(0x00, 0xff, 0x00),
        makecol(0x00, 0xff, 0x33),
        makecol(0x00, 0xff, 0x66),
        makecol(0x00, 0xff, 0x99),
        makecol(0x00, 0xff, 0xcc),
        makecol(0x00, 0xff, 0xff),
        makecol(0x33, 0xff, 0x00),
        makecol(0x33, 0xff, 0x33),
        makecol(0x33, 0xff, 0x66),
        makecol(0x33, 0xff, 0x99),
        makecol(0x33, 0xff, 0xcc),
        makecol(0x33, 0xff, 0xff),
        makecol(0x66, 0xff, 0x00),
        makecol(0x66, 0xff, 0x33),
        makecol(0x66, 0xff, 0x66),
        makecol(0x66, 0xff, 0x99),
        makecol(0x66, 0xff, 0xcc),
        makecol(0x66, 0xff, 0xff),
        makecol(0x99, 0xff, 0x00),
        makecol(0x99, 0xff, 0x33),
        makecol(0x99, 0xff, 0x66),
        makecol(0x99, 0xff, 0x99),
        makecol(0x99, 0xff, 0xcc),
        makecol(0x99, 0xff, 0xff),
        makecol(0xcc, 0xff, 0x00),
        makecol(0xcc, 0xff, 0x33),
        makecol(0xcc, 0xff, 0x66),
        makecol(0xcc, 0xff, 0x99),
        makecol(0xcc, 0xff, 0xcc),
        makecol(0xcc, 0xff, 0xff),
        makecol(0xff, 0xff, 0x00),
        makecol(0xff, 0xff, 0x33),
        makecol(0xff, 0xff, 0x66),
        makecol(0xff, 0xff, 0x99),
        makecol(0xff, 0xff, 0xcc),
        makecol(0xff, 0xff, 0xff),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
        makecol(0x00, 0x00, 0x00),
    },

#endif /*VID_PGC_PALETTE_H*/
