RabbitMQ `3.9.12` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 23.2, and supports Erlang 24. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.



## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).
Contributors are encouraged to update them together with their changes. This helps with release automation and a more consistent release schedule.

### Core Server

#### Bug Fixes

 * Work around a slow [Windows-specific memory leak in Erlang's `file:read_file/1`](https://github.com/erlang/otp/issues/5527).

   GitHub issues: [#3936](https://github.com/rabbitmq/rabbitmq-server/pull/3936), [#3906](https://github.com/rabbitmq/rabbitmq-server/pull/3906)

 * `log.file.rotation.date` pattern parser now supports more values and is closer to Lager in
   RabbitMQ 3.7 and earlier releases.

   GitHub issue: [#3831](https://github.com/rabbitmq/rabbitmq-server/issues/3831)

 * User limits were ignored by definition import.

   GitHub issue: [#3458](https://github.com/rabbitmq/rabbitmq-server/issues/3458)

 * Stream coordinator could run into an exception in some scenarios.

   GitHub issue: [#3908](https://github.com/rabbitmq/rabbitmq-server/pull/3908)

 * On node shutdown, stopped applications were unintentionally logged at the error level.

   GitHub issue: [#3900](https://github.com/rabbitmq/rabbitmq-server/issues/3900)

#### Enhancements

 * `basic.*` AMQP 0-9-1 operations now consume fewer CPU cycles.

   GitHub issue: [#3934](https://github.com/rabbitmq/rabbitmq-server/pull/3934)

 * More efficient (up to 67% more) user addition and updates, including during definition import.

   GitHub issue: [#3894](https://github.com/rabbitmq/rabbitmq-server/pull/3894)

 * Authentiication and authorization backend exceptions could potentially leak user-provided credentials
   to node log.

   Contributed by @luos on behalf of [LKAB](https://www.lkab.com/).

   GitHub issue: [#3903](https://github.com/rabbitmq/rabbitmq-server/pull/3903)

 * When a non-existent stream offset is requested, the server will return a more appropriate
   error code.

   GitHub issue: [#3783](https://github.com/rabbitmq/rabbitmq-server/issues/3783)

 * Stream operations that fail due to an unavailable leader now use a separate error code
   from the case when the stream does not exist.

   GitHub issue: [#3874](https://github.com/rabbitmq/rabbitmq-server/issues/3874)

 * Deprecated classic health check is now less resource intensive (but still very intensive
   compared to [modern alternatives](https://rabbitmq.com/monitoring.html#health-checks)).

   GitHub issue: [#3905](https://github.com/rabbitmq/rabbitmq-server/pull/3905)

 * Operator and regular policy merging now supports keys that use boolean values.
   The operator value overrides the regular policy one.

   GitHub issue: [#3880](https://github.com/rabbitmq/rabbitmq-server/pull/3880)

 * Free disk space monitoring robustness improvements on Windows.

   GitHub issue: [#3895](https://github.com/rabbitmq/rabbitmq-server/pull/3895)

 * Unnamed parameters and policies in definition files will now be rejected
   as invalid.

   Contributed by @polaris-alioth.

   GitHub issue: [#971](https://github.com/rabbitmq/rabbitmq-server/issues/971)


### OAuth 2 Plugin

#### Enhancements

 * HTTPS client and related improvements for JWKS URLs.

   Contributed by @anhanhnguyen on behalf of [LKAB](https://www.lkab.com/).

   GitHub issue: [#3887](https://github.com/rabbitmq/rabbitmq-server/pull/3887)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.12.tar.xz`
instead of the source tarball produced by GitHub.
