## RabbitMQ 3.8.13

RabbitMQ `3.8.13` is a maintenance release.

### Erlang/OTP Compatibility Notes

This release [requires Erlang 22.3](https://www.rabbitmq.com/which-erlang.html).
[Erlang 23](http://blog.erlang.org/OTP-23-Highlights/) is highly recommended
for best forward compatibility with future RabbitMQ versions.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `22.3.x`.


## Upgrade and Compatibility Notes

### Upgrade Doc Guides and Change Log

See [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0) upgrade and
compatibility notes first if upgrading from an earlier release series (e.g. `3.7.x`).

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Upgrading to Erlang 22.x or Later Versions

When upgrading to this release from `3.7.15` or an older version, extra care has to be taken.

Because older RabbitMQ CLI tools can be incompatible with Erlang 22+ releases,
RabbitMQ **must be upgraded at the same time as Erlang**.

Alternatively the node can be upgraded to `3.7.18` on Erlang 21.3 first,
then Erlang 22.3 or 23.x, then RabbitMQ to the most recent 3.8.x release.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

### Core Server

#### Bug Fixes

 * Nodes that had an unusually long name (e.g. 150 or more characters) could overflow
   message property lengths with the [direct reply-to](https://www.rabbitmq.com/direct-reply-to.html) identifier they generated.
   Now the generated values are almost entirely decoupled from node name length.

   GitHub issue: [#2842](https://github.com/rabbitmq/rabbitmq-server/pull/2842)


### Management Plugin

#### Bug Fixes

 * Consumer utilisation metric has been renamed to consumer capacity which more accurately represents
   what it measures. The metric indicates the percentage of time that RabbitMQ has attempted a delivery
   to a consumer of a queue, and was allowed to do so by the [channel prefetch value](https://www.rabbitmq.com/confirms.html#channel-qos-prefetch) and
   the number of currently unacknowledged deliveries.

   For queues that have no consumers, the metric now returns 0%. For consumers that accept all deliveries
   attempted, the metric will be around 100% (optimal).

   For queues that do have consumers but no traffic the metric will be at 100%. The assumption here is that consumers
   can absorb all the load. This case is intentionally treated differently from the one above with no online consumers.

   GitHub issue: [#2843](https://github.com/rabbitmq/rabbitmq-server/pull/2843)


### Prometheus Plugin

#### Bug Fixes

 * Consumer utilisation metric has been renamed to consumer capacity which more accurately represents
   what it measures. See a more detailed note above in the Management plugin section.

   GitHub issue: [#2843](https://github.com/rabbitmq/rabbitmq-server/pull/2843)


### Federation Plugin

#### Enhancements

 * Quorum queues now can be federated.

   GitHub issue: [#2756](https://github.com/rabbitmq/rabbitmq-server/issues/2756)

 * Exchange federation now supports a new option, `channel_use_mode`, which allows a single
   channel to be used for all federation link activity if set to `single`:

   ``` shell
   rabbitmqctl set_parameter federation-upstream dc-2 '{"uri":"amqp://dc2.messaging.coolcorp.local:5672", "channel-use-mode": "single"}'
   ```

   This helps avoid a race condition between topology changes and message flow
   and the cost of topology operations reducing message transfer rates and increasing
   rate variability.

   The default value is `multiple`. It means that every link will use multiple channels (one for message transfer,
   one for topology changes, etc), which has been the case since rabbitmq/rabbitmq-federation#97.
   This is the recommended mode for most environments, and all environments with a mostly static topology.

   See [rabbitmq/rabbitmq-federation#97](https://github.com/rabbitmq/rabbitmq-federation/pull/97) for the background.

   GitHub issue: [#2829](https://github.com/rabbitmq/rabbitmq-server/pull/2829)


### AMQP 1.0 Plugin

#### Bug Fixes

 * The plugin could run into unhandled exceptions.

   GitHub issue: [#2830](https://github.com/rabbitmq/rabbitmq-server/pull/2830)


### OAuth 2 AuthN/AuthZ Backend

#### Enhancements

 * Several settings of the plugin are now exposed to `rabbitmq.conf` and provide validations:

   ``` ini
   auth_backends.1 = oauth2
   auth_oauth2.resource_server_id = a_resource_server_id
   auth_oauth2.additional_scopes_key = a_custom_scope_key
   auth_oauth2.default_key = id1
   auth_oauth2.signing_keys.id1 = /path/to/signing.key1.pem
   auth_oauth2.signing_keys.id2 = /path/to/signing.key2.pem
   ```

   GitHub issue: [#2550](https://github.com/rabbitmq/rabbitmq-server/issues/2550)

 * JWT tokens now can be fetched from a JWKS endpoint provided using the `rabbitmq_auth_backend_oauth2.key_config.jwks_url`
   key in `advanced.config`.

   Contributed by Teo @teozkr Klestrup Röijezon.

   GitHub issue: [#2791](https://github.com/rabbitmq/rabbitmq-server/pull/2791)


## Dependency Upgrades

 * `lager` was [upgraded to 3.8.2](https://github.com/erlang-lager/lager/compare/3.8.0..3.8.2)
 * `cuttlefish` was [upgraded to 2.6.0](https://github.com/kyorai/cuttlefish/compare/v2.4.0..v2.6.0)
 * `credentials_obfuscation` was [upgraded to 2.4.0](https://github.com/rabbitmq/credentials-obfuscation/blob/master/ChangeLog.md#changes-between-230-and-240-february-18-2021)
 * `observer_cli` was [upgraded to 1.6.0](https://github.com/zhongwencool/observer_cli/compare/1.5.4..v1.6.0)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.8.13.tar.xz`
instead of the source tarball produced by GitHub.
