/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger;

public abstract class MachineDescriptionTwosComplement {
    private static final long[] signedMinValues = new long[]{-128L, -32768L, Integer.MIN_VALUE, Long.MIN_VALUE};
    private static final long[] signedMaxValues = new long[]{127L, 32767L, Integer.MAX_VALUE, Long.MAX_VALUE};
    private static final long[] unsignedMaxValues = new long[]{255L, 65535L, 0xFFFFFFFFL, -1L};

    public long cIntegerTypeMaxValue(long sizeInBytes, boolean isUnsigned) {
        if (isUnsigned) {
            return this.tableLookup(sizeInBytes, unsignedMaxValues);
        }
        return this.tableLookup(sizeInBytes, signedMaxValues);
    }

    public long cIntegerTypeMinValue(long sizeInBytes, boolean isUnsigned) {
        if (isUnsigned) {
            return 0L;
        }
        return this.tableLookup(sizeInBytes, signedMinValues);
    }

    public boolean isLP64() {
        return false;
    }

    private long tableLookup(long sizeInBytes, long[] table) {
        switch ((int)sizeInBytes) {
            case 1: {
                return table[0];
            }
            case 2: {
                return table[1];
            }
            case 4: {
                return table[2];
            }
            case 8: {
                return table[3];
            }
        }
        throw new IllegalArgumentException("C integer type of " + sizeInBytes + " not supported");
    }
}

