/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.ConvertingMethod;
import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MXBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import com.sun.jmx.mbeanserver.Util;
import java.lang.reflect.Method;
import java.util.Map;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class MXBeanProxy {
    private final Map<Method, Handler> handlerMap = Util.newMap();

    public MXBeanProxy(Class<?> clazz) {
        MBeanAnalyzer<ConvertingMethod> mBeanAnalyzer;
        if (clazz == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        try {
            mBeanAnalyzer = MXBeanIntrospector.getInstance().getAnalyzer(clazz);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw new IllegalArgumentException(notCompliantMBeanException);
        }
        mBeanAnalyzer.visit(new Visitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Method method, Object[] objectArray) throws Throwable {
        Handler handler = this.handlerMap.get(method);
        ConvertingMethod convertingMethod = handler.getConvertingMethod();
        MXBeanLookup mXBeanLookup = MXBeanLookup.lookupFor(mBeanServerConnection);
        MXBeanLookup mXBeanLookup2 = MXBeanLookup.getLookup();
        try {
            MXBeanLookup.setLookup(mXBeanLookup);
            Object[] objectArray2 = convertingMethod.toOpenParameters(mXBeanLookup, objectArray);
            Object object = handler.invoke(mBeanServerConnection, objectName, objectArray2);
            Object object2 = convertingMethod.fromOpenReturnValue(mXBeanLookup, object);
            return object2;
        }
        finally {
            MXBeanLookup.setLookup(mXBeanLookup2);
        }
    }

    private static class InvokeHandler
    extends Handler {
        private final String[] signature;

        InvokeHandler(String string, String[] stringArray, ConvertingMethod convertingMethod) {
            super(string, convertingMethod);
            this.signature = stringArray;
        }

        @Override
        Object invoke(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Object[] objectArray) throws Exception {
            return mBeanServerConnection.invoke(objectName, this.getName(), objectArray, this.signature);
        }
    }

    private static class SetHandler
    extends Handler {
        SetHandler(String string, ConvertingMethod convertingMethod) {
            super(string, convertingMethod);
        }

        @Override
        Object invoke(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Object[] objectArray) throws Exception {
            assert (objectArray.length == 1);
            Attribute attribute = new Attribute(this.getName(), objectArray[0]);
            mBeanServerConnection.setAttribute(objectName, attribute);
            return null;
        }
    }

    private static class GetHandler
    extends Handler {
        GetHandler(String string, ConvertingMethod convertingMethod) {
            super(string, convertingMethod);
        }

        @Override
        Object invoke(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Object[] objectArray) throws Exception {
            assert (objectArray == null || objectArray.length == 0);
            return mBeanServerConnection.getAttribute(objectName, this.getName());
        }
    }

    private static abstract class Handler {
        private final String name;
        private final ConvertingMethod convertingMethod;

        Handler(String string, ConvertingMethod convertingMethod) {
            this.name = string;
            this.convertingMethod = convertingMethod;
        }

        String getName() {
            return this.name;
        }

        ConvertingMethod getConvertingMethod() {
            return this.convertingMethod;
        }

        abstract Object invoke(MBeanServerConnection var1, ObjectName var2, Object[] var3) throws Exception;
    }

    private class Visitor
    implements MBeanAnalyzer.MBeanVisitor<ConvertingMethod> {
        private Visitor() {
        }

        @Override
        public void visitAttribute(String string, ConvertingMethod convertingMethod, ConvertingMethod convertingMethod2) {
            Method method;
            if (convertingMethod != null) {
                convertingMethod.checkCallToOpen();
                method = convertingMethod.getMethod();
                MXBeanProxy.this.handlerMap.put(method, new GetHandler(string, convertingMethod));
            }
            if (convertingMethod2 != null) {
                method = convertingMethod2.getMethod();
                MXBeanProxy.this.handlerMap.put(method, new SetHandler(string, convertingMethod2));
            }
        }

        @Override
        public void visitOperation(String string, ConvertingMethod convertingMethod) {
            convertingMethod.checkCallToOpen();
            Method method = convertingMethod.getMethod();
            String[] stringArray = convertingMethod.getOpenSignature();
            MXBeanProxy.this.handlerMap.put(method, new InvokeHandler(string, stringArray, convertingMethod));
        }
    }
}

